/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.utils;

import ac.boar.shaded.asm.Type;
import ac.boar.shaded.asm.tree.AbstractInsnNode;
import ac.boar.shaded.asm.tree.ClassNode;
import ac.boar.shaded.asm.tree.FrameNode;
import ac.boar.shaded.asm.tree.IincInsnNode;
import ac.boar.shaded.asm.tree.InsnList;
import ac.boar.shaded.asm.tree.JumpInsnNode;
import ac.boar.shaded.asm.tree.LabelNode;
import ac.boar.shaded.asm.tree.LocalVariableNode;
import ac.boar.shaded.asm.tree.MethodInsnNode;
import ac.boar.shaded.asm.tree.MethodNode;
import ac.boar.shaded.asm.tree.TryCatchBlockNode;
import ac.boar.shaded.asm.tree.VarInsnNode;
import ac.boar.shaded.asm.tree.analysis.Analyzer;
import ac.boar.shaded.asm.tree.analysis.BasicInterpreter;
import ac.boar.shaded.asm.tree.analysis.BasicValue;
import ac.boar.shaded.asm.tree.analysis.Frame;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MethodInliner {
    public static void wrappedInline(ClassNode classNode, MethodNode inlinedMethod, String inlinedMethodOwner) {
        for (MethodNode method : classNode.methods) {
            AbstractInsnNode[] inlinedInstructions;
            for (AbstractInsnNode inlinedInstruction : inlinedInstructions = MethodInliner.instructionCalling(method, Modifier.isStatic(inlinedMethod.access) ? 184 : 182, inlinedMethodOwner, inlinedMethod.name, inlinedMethod.desc)) {
                MethodInliner.wrappedInline(classNode.name, method, inlinedInstruction, ASMUtils.cloneMethod(inlinedMethod));
            }
        }
        classNode.methods.remove(inlinedMethod);
    }

    private static AbstractInsnNode[] instructionCalling(MethodNode method, int callOpcode, String owner, String name, String desc) {
        ArrayList<AbstractInsnNode> insns = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode instruction : method.instructions) {
            if (!(instruction instanceof MethodInsnNode) || instruction.getOpcode() != callOpcode) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)instruction;
            if (!methodInsn.owner.equals(owner) || !methodInsn.name.equals(name) || !methodInsn.desc.equals(desc)) continue;
            insns.add(instruction);
        }
        return insns.toArray(new AbstractInsnNode[0]);
    }

    private static void wrappedInline(String methodOwner, MethodNode method, AbstractInsnNode inlinedInstruction, MethodNode inlinedMethod) {
        int freeVarSpace = ASMUtils.getFreeVarIndex(method);
        HashMap<Integer, Integer> varMappings = new HashMap<Integer, Integer>();
        ArrayList<StackVariable> stackVariables = new ArrayList<StackVariable>();
        Type[] inlinedMethodArgs = Type.getArgumentTypes(inlinedMethod.desc);
        Type inlinedReturnType = Type.getReturnType(inlinedMethod.desc);
        LabelNode returnLabel = new LabelNode();
        InsnList instructions = new InsnList();
        int offset = Modifier.isStatic(inlinedMethod.access) ? 0 : 1;
        for (Type argType : inlinedMethodArgs) {
            instructions.insert(new VarInsnNode(argType.getOpcode(54), freeVarSpace));
            varMappings.put(offset, freeVarSpace);
            freeVarSpace += argType.getSize();
            offset += argType.getSize();
        }
        if (!Modifier.isStatic(inlinedMethod.access)) {
            instructions.add(new VarInsnNode(58, freeVarSpace));
            varMappings.put(0, freeVarSpace);
            ++freeVarSpace;
        }
        try {
            Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
            Frame<V>[] frames = analyzer.analyze(methodOwner, method);
            Frame inlinedInstructionFrame = frames[method.instructions.indexOf(inlinedInstruction)];
            if (inlinedInstructionFrame != null) {
                int stackSize = inlinedInstructionFrame.getStackSize() - varMappings.size();
                for (int i2 = 0; i2 < stackSize; ++i2) {
                    Type stackType = ((BasicValue)inlinedInstructionFrame.getStack(stackSize - i2 - 1)).getType();
                    instructions.add(new VarInsnNode(stackType.getOpcode(54), freeVarSpace));
                    stackVariables.add(new StackVariable(stackType, freeVarSpace));
                    freeVarSpace += stackType.getSize();
                }
            }
        }
        catch (Throwable analyzer) {
            // empty catch block
        }
        for (AbstractInsnNode instruction : inlinedMethod.instructions) {
            if (instruction instanceof FrameNode) continue;
            if (instruction.getOpcode() >= 172 && instruction.getOpcode() <= 177) {
                instructions.add(new JumpInsnNode(167, returnLabel));
                continue;
            }
            if (instruction instanceof VarInsnNode) {
                VarInsnNode varInsn = (VarInsnNode)instruction;
                varMappings.putIfAbsent(varInsn.var, varInsn.var + freeVarSpace);
                varInsn.var = (Integer)varMappings.get(varInsn.var);
            } else if (instruction instanceof IincInsnNode) {
                IincInsnNode iincInsn = (IincInsnNode)instruction;
                varMappings.putIfAbsent(iincInsn.var, iincInsn.var + freeVarSpace);
                iincInsn.var = (Integer)varMappings.get(iincInsn.var);
            }
            instructions.add(instruction);
        }
        instructions.add(returnLabel);
        if (!stackVariables.isEmpty()) {
            int returnVar = freeVarSpace + varMappings.values().stream().mapToInt(i -> i).max().orElse(0);
            if (!inlinedReturnType.equals(Type.VOID_TYPE)) {
                instructions.add(new VarInsnNode(inlinedReturnType.getOpcode(54), returnVar));
            }
            for (int i3 = stackVariables.size() - 1; i3 >= 0; --i3) {
                StackVariable stackVariable = (StackVariable)stackVariables.get(i3);
                instructions.add(new VarInsnNode(stackVariable.type.getOpcode(21), stackVariable.varIndex));
            }
            if (!inlinedReturnType.equals(Type.VOID_TYPE)) {
                instructions.add(new VarInsnNode(inlinedReturnType.getOpcode(21), returnVar));
            }
        }
        method.instructions.insertBefore(inlinedInstruction, instructions);
        method.instructions.remove(inlinedInstruction);
        method.tryCatchBlocks = MethodInliner.mergeTryCatchBlockNodes(method.tryCatchBlocks, inlinedMethod.tryCatchBlocks);
        method.localVariables = MethodInliner.mergeLocalVariableTable(method.localVariables, inlinedMethod.localVariables, freeVarSpace, varMappings);
        method.exceptions = MethodInliner.mergeExceptions(method.exceptions, inlinedMethod.exceptions);
    }

    private static List<TryCatchBlockNode> mergeTryCatchBlockNodes(@Nullable List<TryCatchBlockNode> tryCatchBlockNodes, @Nullable List<TryCatchBlockNode> inlinedTryCatchBlockNodes) {
        ArrayList<TryCatchBlockNode> mergedTryCatchBlockNodes = new ArrayList<TryCatchBlockNode>();
        if (tryCatchBlockNodes != null) {
            mergedTryCatchBlockNodes.addAll(tryCatchBlockNodes);
        }
        if (inlinedTryCatchBlockNodes != null) {
            mergedTryCatchBlockNodes.addAll(inlinedTryCatchBlockNodes);
        }
        return mergedTryCatchBlockNodes;
    }

    private static List<LocalVariableNode> mergeLocalVariableTable(@Nullable List<LocalVariableNode> localVariables, @Nullable List<LocalVariableNode> inlinedLocalVariables, int freeVarSpace, Map<Integer, Integer> varMappings) {
        ArrayList<LocalVariableNode> mergedLocalVariables = new ArrayList<LocalVariableNode>();
        if (localVariables != null) {
            mergedLocalVariables.addAll(localVariables);
        }
        if (inlinedLocalVariables != null) {
            for (LocalVariableNode inlinedLocalVariable : inlinedLocalVariables) {
                inlinedLocalVariable.index = varMappings.containsKey(inlinedLocalVariable.index) ? varMappings.get(inlinedLocalVariable.index) : (inlinedLocalVariable.index += freeVarSpace);
                mergedLocalVariables.add(inlinedLocalVariable);
            }
        }
        return mergedLocalVariables;
    }

    private static List<String> mergeExceptions(@Nullable List<String> exceptions, @Nullable List<String> inlinedExceptions) {
        HashSet<String> mergedExceptions = new HashSet<String>();
        if (exceptions != null) {
            mergedExceptions.addAll(exceptions);
        }
        if (inlinedExceptions != null) {
            mergedExceptions.addAll(inlinedExceptions);
        }
        return new ArrayList<String>(mergedExceptions);
    }

    private static class StackVariable {
        private final Type type;
        private final int varIndex;

        private StackVariable(Type type, int varIndex) {
            this.type = type;
            this.varIndex = varIndex;
        }
    }
}

