/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.validator.click;

import ac.boar.anticheat.compensated.CompensatedInventory;
import ac.boar.anticheat.compensated.cache.container.ContainerCache;
import ac.boar.anticheat.data.inventory.ItemCache;
import ac.boar.anticheat.validator.click.ItemRequestProcessor;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.TransferItemStackRequestAction;

public final class BundleClickProcessor {
    public static BundleResponse processBundleClick(CompensatedInventory inventory, TransferItemStackRequestAction action) {
        if (!BundleClickProcessor.isBundle(action.getDestination()) && !BundleClickProcessor.isBundle(action.getSource())) {
            return new BundleResponse(false, false);
        }
        if (BundleClickProcessor.isBundle(action.getDestination()) && BundleClickProcessor.isBundle(action.getSource())) {
            return new BundleResponse(true, false);
        }
        ItemStackRequestSlotData source = action.getSource();
        ItemStackRequestSlotData destination = action.getDestination();
        int sourceSlot = source.getSlot();
        int destinationSlot = destination.getSlot();
        if (sourceSlot < 0 || destinationSlot < 0 || action.getCount() <= 0) {
            return new BundleResponse(true, false);
        }
        int count = action.getCount();
        if (BundleClickProcessor.isBundle(action.getSource())) {
            ContainerCache destinationContainer = ItemRequestProcessor.findContainer(inventory, destination.getContainer());
            if (sourceSlot > 64 || destinationSlot >= destinationContainer.getContainerSize()) {
                return new BundleResponse(true, false);
            }
            ItemCache bundleItem = inventory.getBundleCache().get(source.getContainerName().getDynamicId());
            if (bundleItem == null) {
                return new BundleResponse(true, false);
            }
            ItemCache cache = bundleItem.getBundle().getContents()[sourceSlot];
            if (cache.getData().isNull() || count > cache.count()) {
                return new BundleResponse(true, false);
            }
            if (cache.count() == count) {
                destinationContainer.set(destinationSlot, cache);
                bundleItem.getBundle().getContents()[sourceSlot] = ItemCache.AIR;
            } else {
                cache.count(cache.count() - count);
                destinationContainer.set(destinationSlot, cache.clone().count(count));
            }
            bundleItem.getBundle().count -= count;
        } else {
            ContainerCache sourceContainer = ItemRequestProcessor.findContainer(inventory, source.getContainer());
            if (destinationSlot > 64 || sourceSlot >= sourceContainer.getContainerSize()) {
                return new BundleResponse(true, false);
            }
            ItemCache bundleItem = inventory.getBundleCache().get(destination.getContainerName().getDynamicId());
            if (bundleItem == null) {
                return new BundleResponse(true, false);
            }
            ItemCache sourceCache = sourceContainer.get(sourceSlot);
            if (sourceCache.getData().isNull() || count > sourceCache.getData().getCount()) {
                return new BundleResponse(true, false);
            }
            boolean valid = bundleItem.getBundle().add(destinationSlot, sourceCache);
            if (valid) {
                if (count == sourceCache.count()) {
                    sourceContainer.set(sourceSlot, ItemCache.AIR);
                } else {
                    sourceContainer.set(sourceSlot, sourceCache.count(sourceCache.count() - count));
                }
            }
            return new BundleResponse(true, valid);
        }
        return new BundleResponse(true, true);
    }

    private static boolean isBundle(ItemStackRequestSlotData request) {
        return request.getContainerName().getContainer() == ContainerSlotType.DYNAMIC_CONTAINER;
    }

    public record BundleResponse(boolean bundle, boolean valid) {
    }
}

