/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util;

import ac.boar.anticheat.util.math.Vec3;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;

public class MathUtil {
    public static final float DEGREE_TO_RAD = (float)Math.PI / 180;

    public static boolean sameDirection(Vec3 vec3, Vec3 vec32) {
        return MathUtil.sign(vec3.x) == MathUtil.sign(vec32.x) && MathUtil.sign(vec3.y) == MathUtil.sign(vec32.y) && MathUtil.sign(vec3.z) == MathUtil.sign(vec32.z);
    }

    public static boolean sameDirectionHorizontal(Vec3 vec3, Vec3 vec32) {
        return MathUtil.sign(vec3.x) == MathUtil.sign(vec32.x) && MathUtil.sign(vec3.z) == MathUtil.sign(vec32.z);
    }

    public static Vec3 signAll(Vec3 vec3) {
        return new Vec3(MathUtil.sign(vec3.x), MathUtil.sign(vec3.y), MathUtil.sign(vec3.z));
    }

    public static int sign(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            return 0;
        }
        return value == 0.0f ? 0 : (value > 0.0f ? 1 : -1);
    }

    public static float wrapDegrees(float f) {
        float g = f % 360.0f;
        if (g >= 180.0f) {
            g -= 360.0f;
        }
        if (g < -180.0f) {
            g += 360.0f;
        }
        return g;
    }

    public static boolean equal(float d, float e) {
        return Math.abs(e - d) < 1.0E-7f;
    }

    public static float lerp(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    public static float square(float v) {
        return v * v;
    }

    public static float clamp(float value, float min, float max) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            return 0.0f;
        }
        return value < min ? min : Math.min(value, max);
    }

    public static boolean compare(Vector3i vector3i, Vector3i vector3i1) {
        return vector3i != null && vector3i1 != null && vector3i.getX() == vector3i1.getX() && vector3i.getY() == vector3i1.getY() && vector3i.getZ() == vector3i1.getZ();
    }

    public static boolean isValid(Vector3i vector3i) {
        return Float.isFinite(vector3i.getX()) && Float.isFinite(vector3i.getY()) && Float.isFinite(vector3i.getZ());
    }

    public static boolean isValid(Vector3f vector3i) {
        return Float.isFinite(vector3i.getX()) && Float.isFinite(vector3i.getY()) && Float.isFinite(vector3i.getZ());
    }

    public static Vec3 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = TrigMath.cos((double)g);
        float i = TrigMath.sin((double)g);
        float j = TrigMath.cos((double)f);
        float k = TrigMath.sin((double)f);
        return new Vec3(i * j, -k, h * j);
    }

    public static Vec3 getInputVector(Vec3 movementInput, float speed, float yaw) {
        float d = movementInput.lengthSquared();
        if ((double)d < 1.0E-7) {
            return Vec3.ZERO;
        }
        Vec3 lv = ((double)d > 1.0 ? movementInput.normalize() : movementInput).multiply(speed);
        float h = TrigMath.sin((double)(yaw * ((float)Math.PI / 180)));
        float i = TrigMath.cos((double)(yaw * ((float)Math.PI / 180)));
        return new Vec3(lv.x * i - lv.z * h, lv.y, lv.z * i + lv.x * h);
    }

    public static int blockPosition(int x, int y, int z) {
        return x << 8 | z << 4 | y;
    }
}

