/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util.block;

import ac.boar.anticheat.data.block.BoarBlockState;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.math.DirectionUtil;
import ac.boar.mappings.BlockMappings;
import java.util.BitSet;
import java.util.Locale;
import java.util.Objects;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.ChestType;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.property.Property;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.SkullBlock;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityInfo;

public class BlockUtil {
    public static void restoreCorrectBlock(GeyserSession session, Vector3i vector, BlockState blockState) {
        SkullCache.Skull skull;
        SkullBlock skullBlock;
        GeyserBedrockBlock bedrockBlock = session.getBlockMappings().getBedrockBlock(blockState);
        Block block = blockState.block();
        if (block instanceof SkullBlock && (skullBlock = (SkullBlock)block).skullType() == SkullBlock.Type.PLAYER && (skull = (SkullCache.Skull)session.getSkullCache().getSkulls().get(vector)) != null && skull.getBlockDefinition() != null) {
            bedrockBlock = skull.getBlockDefinition();
        }
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setBlockPosition(vector);
        updateBlockPacket.setDefinition((BlockDefinition)bedrockBlock);
        updateBlockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket((BedrockPacket)updateBlockPacket);
        UpdateBlockPacket updateWaterPacket = new UpdateBlockPacket();
        updateWaterPacket.setDataLayer(1);
        updateWaterPacket.setBlockPosition(vector);
        updateWaterPacket.setDefinition((BlockDefinition)(((BitSet)BlockRegistries.WATERLOGGED.get()).get(blockState.javaId()) ? session.getBlockMappings().getBedrockWater() : session.getBlockMappings().getBedrockAir()));
        updateWaterPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket((BedrockPacket)updateWaterPacket);
        session.getPlayerInventoryHolder().updateSlot(session.getPlayerInventory().getHeldItemSlot());
    }

    public static Vector3i getBlockPosition(Vector3i blockPos, int face) {
        return switch (face) {
            case 0 -> blockPos.sub(0, 1, 0);
            case 1 -> blockPos.add(0, 1, 0);
            case 2 -> blockPos.sub(0, 0, 1);
            case 3 -> blockPos.add(0, 0, 1);
            case 4 -> blockPos.sub(1, 0, 0);
            case 5 -> blockPos.add(1, 0, 0);
            default -> blockPos;
        };
    }

    public static void restoreCorrectBlock(GeyserSession session, Vector3i blockPos) {
        BlockUtil.restoreCorrectBlock(session, blockPos, session.getGeyser().getWorldManager().blockAt(session, blockPos));
    }

    public static BlockState getPlacementState(BoarPlayer player, Block block, Vector3i position) {
        return block.defaultBlockState();
    }

    public static BlockState findChestState(BoarPlayer player, BlockState state, Vector3i vector3i) {
        BlockEntityInfo blockEntity = player.compensatedWorld.getBlockEntity(vector3i.getX(), vector3i.getY(), vector3i.getZ());
        if (blockEntity == null || blockEntity.getNbt() == null) {
            return state.withValue((Property)Properties.CHEST_TYPE, (Comparable)ChestType.SINGLE);
        }
        int pairX = blockEntity.getNbt().getInt("pairx", 0);
        int pairZ = blockEntity.getNbt().getInt("pairz", 0);
        if (Math.abs(vector3i.getX() - pairX) > 1 || Math.abs(vector3i.getZ() - pairZ) > 1) {
            return state.withValue((Property)Properties.CHEST_TYPE, (Comparable)ChestType.SINGLE);
        }
        Vector3i attachedPos = Vector3i.from((int)pairX, (int)vector3i.getY(), (int)pairZ);
        int id = player.compensatedWorld.getBlockAt(attachedPos.getX(), attachedPos.getY(), attachedPos.getZ(), 0);
        if (BlockState.of((int)id).block().javaId() != state.block().javaId()) {
            return state.withValue((Property)Properties.CHEST_TYPE, (Comparable)ChestType.SINGLE);
        }
        int pairLead = blockEntity.getNbt().getInt("pairlead", 0);
        return state.withValue((Property)Properties.CHEST_TYPE, (Comparable)(pairLead == 1 ? ChestType.RIGHT : ChestType.LEFT));
    }

    public static boolean determineCanBreak(BoarPlayer player, BlockState state) {
        if (state.is(Blocks.AIR) || state.is(Blocks.CAVE_AIR) || state.is(Blocks.VOID_AIR) || state.is(Blocks.LAVA) || state.is(Blocks.WATER)) {
            return false;
        }
        float destroyTime = state.block().destroyTime();
        return destroyTime != -1.0f || player.gameType == GameType.CREATIVE;
    }

    public static BlockState findFenceBlockState(BoarPlayer player, BlockState main, Vector3i position) {
        BoarBlockState blockState = player.compensatedWorld.getBlockState(position.north(), 0);
        BoarBlockState blockState2 = player.compensatedWorld.getBlockState(position.east(), 0);
        BoarBlockState blockState3 = player.compensatedWorld.getBlockState(position.south(), 0);
        BoarBlockState blockState4 = player.compensatedWorld.getBlockState(position.west(), 0);
        boolean north = BlockUtil.connectsTo(main, blockState.getState(), blockState.isFaceSturdy(player), Direction.SOUTH);
        boolean east = BlockUtil.connectsTo(main, blockState2.getState(), blockState2.isFaceSturdy(player), Direction.WEST);
        boolean south = BlockUtil.connectsTo(main, blockState3.getState(), blockState3.isFaceSturdy(player), Direction.NORTH);
        boolean west = BlockUtil.connectsTo(main, blockState4.getState(), blockState4.isFaceSturdy(player), Direction.EAST);
        String identifier = main.block().defaultBlockState().toString().intern();
        identifier = identifier.replace("north=true", "north=" + north);
        identifier = identifier.replace("east=true", "east=" + east);
        identifier = identifier.replace("south=true", "south=" + south);
        identifier = identifier.replace("west=true", "west=" + west);
        identifier = identifier.replace("waterlogged=true", "waterlogged=false");
        return BlockState.of((int)((Integer)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.getOrDefault((Object)identifier, (Object)main.javaId())));
    }

    public static BlockState findIronBarsBlockState(BoarPlayer player, BlockState state, Vector3i position) {
        BoarBlockState blockState = player.compensatedWorld.getBlockState(position.north(), 0);
        BoarBlockState blockState2 = player.compensatedWorld.getBlockState(position.south(), 0);
        BoarBlockState blockState3 = player.compensatedWorld.getBlockState(position.west(), 0);
        BoarBlockState blockState4 = player.compensatedWorld.getBlockState(position.east(), 0);
        boolean north = BlockUtil.attachsTo(blockState.getState(), blockState.isFaceSturdy(player));
        boolean south = BlockUtil.attachsTo(blockState2.getState(), blockState2.isFaceSturdy(player));
        boolean west = BlockUtil.attachsTo(blockState3.getState(), blockState3.isFaceSturdy(player));
        boolean east = BlockUtil.attachsTo(blockState4.getState(), blockState4.isFaceSturdy(player));
        String identifier = state.block().defaultBlockState().toString().intern();
        identifier = identifier.replace("north=true", "north=" + north);
        identifier = identifier.replace("east=true", "east=" + east);
        identifier = identifier.replace("south=true", "south=" + south);
        identifier = identifier.replace("west=true", "west=" + west);
        identifier = identifier.replace("waterlogged=true", "waterlogged=false");
        return BlockState.of((int)((Integer)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.getOrDefault((Object)identifier, (Object)state.javaId())));
    }

    private static boolean connectsTo(BlockState blockState, BlockState neighbour, boolean bl, Direction direction) {
        return !BlockUtil.isExceptionForConnection(neighbour) && bl || BlockUtil.isSameFence(neighbour, blockState) || BlockUtil.connectsToDirection(neighbour, direction);
    }

    private static boolean attachsTo(BlockState blockState, boolean bl) {
        boolean walls = BlockMappings.getWallBlocks().contains(blockState.block());
        return !BlockUtil.isExceptionForConnection(blockState) && bl || blockState.is(Blocks.IRON_BARS) || blockState.toString().toLowerCase(Locale.ROOT).contains("glass_pane") || walls;
    }

    private static boolean isSameFence(BlockState blockState, BlockState currentBlockState) {
        return BlockMappings.getFenceBlocks().contains(blockState.block()) && blockState.is(Blocks.NETHER_BRICK_FENCE) == currentBlockState.is(Blocks.NETHER_BRICK_FENCE);
    }

    public static boolean connectsToDirection(BlockState blockState, Direction direction) {
        if (!BlockMappings.getFenceGateBlocks().contains(blockState.block())) {
            return false;
        }
        return ((Direction)blockState.getValue((Property)Properties.HORIZONTAL_FACING)).getAxis() == DirectionUtil.getClockWise(direction).getAxis();
    }

    public static boolean isExceptionForConnection(BlockState blockState) {
        return BlockMappings.getLeavesBlocks().contains(blockState.block()) || blockState.is(Blocks.BARRIER) || blockState.is(Blocks.CARVED_PUMPKIN) || blockState.is(Blocks.JACK_O_LANTERN) || blockState.is(Blocks.MELON) || blockState.is(Blocks.PUMPKIN) || BlockMappings.getShulkerBlocks().contains(blockState.block());
    }

    public static String getStairShape(BoarPlayer player, BlockState state, Vector3i pos) {
        Direction direction3;
        Direction direction2;
        Direction direction = (Direction)state.getValue((Property)Properties.HORIZONTAL_FACING);
        BlockState blockState = player.compensatedWorld.getBlockState(pos.add(direction.getUnitVector()), 0).getState();
        if (BlockUtil.isStairs(blockState) && Objects.equals(state.getValue((Property)Properties.HALF), blockState.getValue((Property)Properties.HALF)) && (direction2 = (Direction)blockState.getValue((Property)Properties.HORIZONTAL_FACING)).getAxis() != ((Direction)state.getValue((Property)Properties.HORIZONTAL_FACING)).getAxis() && BlockUtil.isDifferentOrientation(player, state, pos, direction2.reversed())) {
            if (direction2 == DirectionUtil.rotateYCounterclockwise(direction)) {
                return "outer_left";
            }
            return "outer_right";
        }
        BlockState blockState2 = player.compensatedWorld.getBlockState(pos.add(direction.reversed().getUnitVector()), 0).getState();
        if (BlockUtil.isStairs(blockState2) && Objects.equals(state.getValue((Property)Properties.HALF), blockState2.getValue((Property)Properties.HALF)) && (direction3 = (Direction)blockState2.getValue((Property)Properties.HORIZONTAL_FACING)).getAxis() != ((Direction)state.getValue((Property)Properties.HORIZONTAL_FACING)).getAxis() && BlockUtil.isDifferentOrientation(player, state, pos, direction3)) {
            if (direction3 == DirectionUtil.rotateYCounterclockwise(direction)) {
                return "inner_left";
            }
            return "inner_right";
        }
        return "straight";
    }

    private static boolean isDifferentOrientation(BoarPlayer player, BlockState state, Vector3i pos, Direction dir) {
        BlockState blockState = player.compensatedWorld.getBlockState(pos.add(dir.getUnitVector()), 0).getState();
        return !BlockUtil.isStairs(blockState) || blockState.getValue((Property)Properties.HORIZONTAL_FACING) != state.getValue((Property)Properties.HORIZONTAL_FACING) || !Objects.equals(blockState.getValue((Property)Properties.HALF), state.getValue((Property)Properties.HALF));
    }

    public static boolean isStairs(BlockState state) {
        return BlockMappings.getStairsBlocks().contains(state.block());
    }
}

