/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.compensated.world.base;

import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.data.EntityDimensions;
import ac.boar.anticheat.data.block.BoarBlockState;
import ac.boar.anticheat.data.block.impl.BedBlockState;
import ac.boar.anticheat.data.block.impl.HoneyBlockState;
import ac.boar.anticheat.data.block.impl.SlimeBlockState;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.geyser.BoarChunkSection;
import ac.boar.anticheat.util.math.Mutable;
import ac.boar.shaded.fastutil.longs.Long2ObjectMap;
import ac.boar.shaded.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.cache.tags.BlockTag;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public class CompensatedWorld {
    private final BoarPlayer player;
    private final Long2ObjectMap<BoarChunkSection[]> chunks = new Long2ObjectOpenHashMap<BoarChunkSection[]>();
    private BedrockDimension dimension;
    private final Long2ObjectMap<EntityCache> entities = new Long2ObjectOpenHashMap<EntityCache>();
    private final Map<Long, Long> uniqueIdToRuntimeId = new HashMap<Long, Long>();

    public void removeEntity(long uniqueId) {
        long key = this.uniqueIdToRuntimeId.getOrDefault(uniqueId, -1L);
        if (key == -1L) {
            return;
        }
        this.entities.remove(key);
    }

    public EntityCache getEntity(long id) {
        return (EntityCache)this.entities.get(id);
    }

    public EntityCache addToCache(BoarPlayer player, long runtimeId, long uniqueId) {
        Entity entity = player.getSession().getEntityCache().getEntityByGeyserId(runtimeId);
        if (entity == null || entity.getDefinition() == null || runtimeId == player.runtimeEntityId) {
            return null;
        }
        EntityDefinition definition = entity.getDefinition();
        boolean affectedByOffset = definition.entityType() == EntityType.PLAYER || definition.identifier().equalsIgnoreCase("minecraft:boat") || definition.identifier().equalsIgnoreCase("minecraft:chest_boat");
        player.sendLatencyStack();
        EntityCache cache = new EntityCache(player, definition.entityType(), definition, player.sentStackId.get(), runtimeId);
        cache.setAffectedByOffset(affectedByOffset);
        cache.setDimensions(EntityDimensions.fixed(definition.width(), definition.height()));
        this.entities.put(runtimeId, cache);
        this.uniqueIdToRuntimeId.put(uniqueId, runtimeId);
        return cache;
    }

    public void addToCache(int x, int z, BoarChunkSection[] chunks) {
        long chunkPosition = MathUtils.chunkPositionToLong((int)x, (int)z);
        this.chunks.put(chunkPosition, chunks);
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        return this.getChunk(chunkX >> 4, chunkZ >> 4) != null;
    }

    public void updateBlock(Vector3i position, int layer, int block) {
        this.updateBlock(position.getX(), position.getY(), position.getZ(), layer, block);
    }

    public void updateBlock(int x, int y, int z, int layer, int block) {
        BoarChunkSection[] column = this.getChunk(x >> 4, z >> 4);
        if (column == null) {
            return;
        }
        if (y < this.getMinY() || y - this.getMinY() >> 4 > column.length - 1) {
            return;
        }
        BoarChunkSection palette = column[y - this.getMinY() >> 4];
        if (palette == null) {
            if (block != 0) {
                column[y - this.getMinY() >> 4] = palette = new BoarChunkSection(this.player.BEDROCK_AIR, 0);
            } else {
                return;
            }
        }
        palette.setFullBlock(x & 0xF, y & 0xF, z & 0xF, layer, block);
    }

    public BoarBlockState getBlockState(Mutable vector3i, int layer) {
        return this.getBlockState(vector3i.getX(), vector3i.getY(), vector3i.getZ(), layer);
    }

    public BoarBlockState getBlockState(Vector3i vector3i, int layer) {
        return this.getBlockState(vector3i.getX(), vector3i.getY(), vector3i.getZ(), layer);
    }

    public BoarBlockState getBlockState(int x, int y, int z, int layer) {
        BlockState state = BlockState.of((int)this.getBlockAt(x, y, z, layer));
        if (state.is(Blocks.HONEY_BLOCK)) {
            return new HoneyBlockState(state, Vector3i.from((int)x, (int)y, (int)z), layer);
        }
        if (state.is(Blocks.SLIME_BLOCK)) {
            return new SlimeBlockState(state, Vector3i.from((int)x, (int)y, (int)z), layer);
        }
        if (this.player.getSession().getTagCache().is(BlockTag.BEDS, (Object)state.block())) {
            return new BedBlockState(state, Vector3i.from((int)x, (int)y, (int)z), layer);
        }
        return new BoarBlockState(state, Vector3i.from((int)x, (int)y, (int)z), layer);
    }

    public int getBlockAt(int x, int y, int z, int layer) {
        BoarChunkSection[] column = this.getChunk(x >> 4, z >> 4);
        if (column == null) {
            return 0;
        }
        if (y < this.getMinY() || y - this.getMinY() >> 4 > column.length - 1) {
            return 0;
        }
        BoarChunkSection chunk = column[y - this.getMinY() >> 4];
        if (chunk != null) {
            try {
                return this.player.bedrockBlockToJava.getOrDefault(chunk.getFullBlock(x & 0xF, y & 0xF, z & 0xF, layer), 0);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    private BoarChunkSection[] getChunk(int chunkX, int chunkZ) {
        long chunkPosition = MathUtils.chunkPositionToLong((int)chunkX, (int)chunkZ);
        return this.chunks.getOrDefault(chunkPosition, (BoarChunkSection[])null);
    }

    public int getMinY() {
        return this.dimension.minY();
    }

    public int getHeightY() {
        return this.dimension.maxY();
    }

    @Generated
    public CompensatedWorld(BoarPlayer player) {
        this.player = player;
    }

    @Generated
    public void setDimension(BedrockDimension dimension) {
        this.dimension = dimension;
    }

    @Generated
    public BoarPlayer getPlayer() {
        return this.player;
    }

    @Generated
    public Long2ObjectMap<BoarChunkSection[]> getChunks() {
        return this.chunks;
    }

    @Generated
    public BedrockDimension getDimension() {
        return this.dimension;
    }

    @Generated
    public Long2ObjectMap<EntityCache> getEntities() {
        return this.entities;
    }

    @Generated
    public Map<Long, Long> getUniqueIdToRuntimeId() {
        return this.uniqueIdToRuntimeId;
    }
}

