/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.validator;

import ac.boar.anticheat.data.BreakingData;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.block.BlockUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.PlayerActionType;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.PlayerBlockActionData;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.ItemUseTransaction;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.bedrock.BedrockInventoryTransactionTranslator;

public final class BreakingBlockValidator {
    private static final List<PlayerActionType> allowedActions = List.of(PlayerActionType.START_BREAK, PlayerActionType.STOP_BREAK, PlayerActionType.CONTINUE_BREAK, PlayerActionType.ABORT_BREAK);
    private final BoarPlayer player;
    private final List<BreakingData> cachedBlockBreak = new ArrayList<BreakingData>();

    public void handle(PlayerAuthInputPacket packet) {
        boolean isPerformingBlockAction = packet.getInputData().contains(PlayerAuthInputData.PERFORM_BLOCK_ACTIONS);
        if (isPerformingBlockAction) {
            this.handleBlockAction(packet);
        }
        boolean isPerformingInteraction = packet.getInputData().contains(PlayerAuthInputData.PERFORM_ITEM_INTERACTION);
        ItemUseTransaction transaction = packet.getItemUseTransaction();
        if (transaction != null && transaction.getActionType() == 2 && isPerformingInteraction) {
            Vector3i position = transaction.getBlockPosition();
            int face = transaction.getBlockFace();
            if (position == null || !MathUtil.isValid(position) || face < 0 || face >= Direction.VALUES.length) {
                packet.getInputData().remove(PlayerAuthInputData.PERFORM_ITEM_INTERACTION);
                packet.setItemUseTransaction(null);
                return;
            }
            double distance = position.distance(this.player.position.toVector3i());
            if (distance > 12.0) {
                this.resyncBlock(position);
                packet.setItemUseTransaction(null);
                packet.getInputData().remove(PlayerAuthInputData.PERFORM_ITEM_INTERACTION);
                return;
            }
            BlockState state = this.player.compensatedWorld.getBlockState(position, 0).getState();
            BreakingData data = this.findCacheUsingPosition(position);
            if (data == null || !BlockUtil.determineCanBreak(this.player, state)) {
                packet.setItemUseTransaction(null);
                this.resyncBlock(position);
            } else {
                if (data.getBreakingProcess() >= 1.0f) {
                    this.player.compensatedWorld.updateBlock(data.getPosition(), 0, this.player.BEDROCK_AIR);
                } else {
                    packet.setItemUseTransaction(null);
                    this.resyncBlock(position);
                }
                this.cachedBlockBreak.remove(data);
            }
        }
        if (packet.getItemUseTransaction() == null && isPerformingInteraction) {
            packet.getInputData().remove(PlayerAuthInputData.PERFORM_ITEM_INTERACTION);
        }
    }

    private void handleBlockAction(PlayerAuthInputPacket packet) {
        ArrayList<PlayerBlockActionData> valid = new ArrayList<PlayerBlockActionData>();
        for (PlayerBlockActionData action : packet.getPlayerActions()) {
            double distance;
            if (action.getBlockPosition() == null || !MathUtil.isValid(action.getBlockPosition()) && action.getAction() != PlayerActionType.START_BREAK || (action.getFace() < 0 || action.getFace() >= Direction.VALUES.length) && action.getAction() != PlayerActionType.ABORT_BREAK || !allowedActions.contains(action.getAction())) continue;
            BreakingData data = this.findCacheUsingPosition(action.getBlockPosition());
            if (data != null && (distance = (double)data.getPosition().distance(this.player.position.toVector3i())) > 12.0) {
                this.resyncBlock(data.getPosition());
                continue;
            }
            if (action.getAction() == PlayerActionType.START_BREAK) {
                if (data != null) {
                    this.cachedBlockBreak.remove(data);
                }
                this.cachedBlockBreak.add(new BreakingData(action.getAction(), action.getBlockPosition(), action.getFace()));
                valid.add(action);
            }
            if (action.getAction() == PlayerActionType.CONTINUE_BREAK && data != null) {
                this.tickBreaking(data);
                data.setFace(action.getFace());
                data.setState(PlayerActionType.CONTINUE_BREAK);
                valid.add(action);
            }
            if (!(action.getAction() == PlayerActionType.ABORT_BREAK & data != null)) continue;
            this.cachedBlockBreak.remove(data);
            valid.add(action);
        }
        packet.getPlayerActions().clear();
        packet.getPlayerActions().addAll(valid);
        if (packet.getPlayerActions().isEmpty()) {
            packet.getInputData().remove(PlayerAuthInputData.PERFORM_BLOCK_ACTIONS);
        }
    }

    private void tickBreaking(BreakingData data) {
        data.setBreakingProcess(1.0f);
    }

    private void resyncBlock(Vector3i vector3i) {
        BedrockInventoryTransactionTranslator.restoreCorrectBlock((GeyserSession)this.player.getSession(), (Vector3i)vector3i);
    }

    private BreakingData findCacheUsingPosition(Vector3i vector3i) {
        for (BreakingData data : this.cachedBlockBreak) {
            if (!MathUtil.compare(vector3i, data.getPosition())) continue;
            return data;
        }
        return null;
    }

    @Generated
    public BreakingBlockValidator(BoarPlayer player) {
        this.player = player;
    }
}

