/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.geyser;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.alert.AlertManager;
import ac.boar.anticheat.player.BoarPlayer;
import lombok.Generated;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.command.CommandSource;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.event.bedrock.SessionDisconnectEvent;
import org.geysermc.geyser.api.event.bedrock.SessionLoginEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCommandsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserRegisterPermissionsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserShutdownEvent;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.extension.ExtensionLogger;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.session.GeyserSession;

public class GeyserBoar
implements Extension {
    private static ExtensionLogger logger;

    @Subscribe
    public void onSessionJoin(SessionLoginEvent event) {
        Boar.getInstance().getPlayerManager().add(event.connection());
    }

    @Subscribe
    public void onSessionLeave(SessionDisconnectEvent event) {
        Boar.getInstance().getPlayerManager().remove(event.connection());
    }

    @Subscribe
    public void onGeyserPostInitializeEvent(GeyserPostInitializeEvent event) {
        logger = this.logger();
        Boar.getInstance().init(this);
    }

    @Subscribe
    public void onGeyserShutdown(GeyserShutdownEvent event) {
        Boar.getInstance().terminate(this);
    }

    @Subscribe
    public void onRegisterPermissions(GeyserRegisterPermissionsEvent event) {
        event.register("boar.exempt", TriState.FALSE);
        event.register("boar.alert", TriState.NOT_SET);
        event.register("boar.preddebug", TriState.NOT_SET);
    }

    @Subscribe
    public void onDefineCommands(GeyserDefineCommandsEvent event) {
        event.register(Command.builder((Extension)this).source(CommandSource.class).name("alert").playerOnly(true).description("Enable alert messages.").permission("boar.alert").executor((source, cmd, args) -> {
            AlertManager alertManager = Boar.getInstance().getAlertManager();
            String prefix = alertManager.getPrefix(source);
            if (alertManager.hasAlert(source)) {
                alertManager.removeAlert(source);
                source.sendMessage(prefix + "\u00a7fDisabled alerts.");
            } else {
                alertManager.addAlert(source);
                source.sendMessage(prefix + "\u00a7fEnabled alerts.");
            }
        }).build());
        event.register(Command.builder((Extension)this).source(CommandSource.class).name("preddebug").playerOnly(true).bedrockOnly(true).description("Enable prediction debug message.").permission("boar.preddebug").executor((source, cmd, args) -> {
            GeyserConnection patt3227$temp = source.connection();
            if (!(patt3227$temp instanceof GeyserSession)) {
                source.sendMessage("Failed, not GeyserSession!");
                return;
            }
            GeyserSession session = (GeyserSession)patt3227$temp;
            BoarPlayer player = (BoarPlayer)Boar.getInstance().getPlayerManager().get(session);
            if (player == null) {
                source.sendMessage("Failed, can't find player session!");
                return;
            }
            player.setDebugMode(!player.isDebugMode());
            source.sendMessage("Done! Current debug state: " + player.isDebugMode());
        }).build());
    }

    @Generated
    public static ExtensionLogger getLogger() {
        return logger;
    }
}

