/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.prediction.engine.impl.fluid;

import ac.boar.anticheat.compensated.CompensatedInventory;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.prediction.engine.base.PredictionEngine;
import ac.boar.anticheat.util.math.Vec3;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class WaterPredictionEngine
extends PredictionEngine {
    private float tickEndSpeed;

    public WaterPredictionEngine(BoarPlayer player) {
        super(player);
    }

    @Override
    public Vec3 travel(Vec3 vec3) {
        ItemData boostSlot = this.player.compensatedInventory.armorContainer.get(3).getData();
        Map<BedrockEnchantment, Integer> enchantments = CompensatedInventory.getEnchantments(boostSlot);
        Integer depthStrider = enchantments.get(BedrockEnchantment.DEPTH_STRIDER);
        float h = 0.0f;
        if (depthStrider != null) {
            h = 0.33333334f + 0.33333334f * (float)(depthStrider - 1);
        }
        if (!this.player.onGround && this.player.getFlagTracker().has(EntityFlag.SWIMMING)) {
            h *= 0.5f;
        }
        this.tickEndSpeed = h;
        this.player.hasDepthStrider = this.tickEndSpeed > 0.0f;
        return this.moveRelative(vec3, h > 0.0f ? 0.02f + (this.player.getSpeed() - 0.02f) * h : 0.02f);
    }

    @Override
    public void finalizeMovement() {
        boolean fastTickEnd;
        if (!this.player.getFlagTracker().has(EntityFlag.SWIMMING) && !this.player.onGround) {
            this.tickEndSpeed *= 0.5f;
        }
        boolean sprinting = this.player.getFlagTracker().has(EntityFlag.SPRINTING);
        boolean bl = fastTickEnd = this.player.getFlagTracker().has(EntityFlag.SWIMMING) && sprinting;
        if (sprinting && !fastTickEnd) {
            if (!GameProtocol.is1_21_80orHigher((GeyserSession)this.player.getSession()) || GameProtocol.is1_21_90orHigher((GeyserSession)this.player.getSession())) {
                fastTickEnd = true;
            } else {
                Vec3 slow = this.player.velocity.multiply(0.8f + -0.25399995f * this.tickEndSpeed, 0.8f, 0.8f + -0.25399995f * this.tickEndSpeed);
                if (slow.horizontalLengthSquared() < this.player.unvalidatedTickEnd.horizontalLengthSquared()) {
                    fastTickEnd = true;
                }
            }
        }
        float f = fastTickEnd ? 0.9f : 0.8f;
        f += (0.54600006f - f) * this.tickEndSpeed;
        this.player.velocity = this.player.velocity.multiply(f, 0.8f, f);
        this.player.velocity = this.getFluidFallingAdjustedMovement(this.player.getEffectiveGravity(), this.player.velocity);
    }

    private Vec3 getFluidFallingAdjustedMovement(float gravity, Vec3 motion) {
        if (this.player.hasEffect(Effect.LEVITATION)) {
            float y = motion.y + ((float)(this.player.getEffect(Effect.LEVITATION).getAmplifier() + 1) * 0.05f - motion.y) * 0.2f;
            return new Vec3(motion.x, y, motion.z);
        }
        if ((double)gravity != 0.0 && !this.player.getFlagTracker().has(EntityFlag.SWIMMING)) {
            return new Vec3(motion.x, motion.y - gravity / 16.0f, motion.z);
        }
        return motion;
    }
}

