/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util;

import ac.boar.anticheat.player.BoarPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;

public final class LatencyUtil {
    private final BoarPlayer player;
    private final List<Long> sentStackLatency = new CopyOnWriteArrayList<Long>();
    private final Map<Long, StackLatencyData> map = new ConcurrentHashMap<Long, StackLatencyData>();

    public void addLatencyToQueue(long id) {
        this.sentStackLatency.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskToQueue(long id, Runnable runnable) {
        if (id <= this.player.receivedStackId.get()) {
            runnable.run();
            return;
        }
        LatencyUtil latencyUtil = this;
        synchronized (latencyUtil) {
            if (!this.map.containsKey(id)) {
                this.map.put(id, new StackLatencyData(id));
            }
            this.map.get((Object)Long.valueOf((long)id)).tasks.add(runnable);
        }
    }

    public boolean confirmStackId(long id) {
        if (!this.sentStackLatency.contains(id) || id <= this.player.receivedStackId.get()) {
            return false;
        }
        this.sentStackLatency.removeIf(l -> {
            if (this.map.containsKey(l) && l <= id) {
                this.map.remove((Object)l).tasks.forEach(Runnable::run);
            }
            return l <= id;
        });
        this.player.receivedStackId.set(id);
        return true;
    }

    @Generated
    public LatencyUtil(BoarPlayer player) {
        this.player = player;
    }

    private static class StackLatencyData {
        private final long stackId;
        private final List<Runnable> tasks = new ArrayList<Runnable>();

        @Generated
        public StackLatencyData(long stackId) {
            this.stackId = stackId;
        }
    }
}

