/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.server;

import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.math.Vec3;
import ac.boar.protocol.event.CloudburstPacketEvent;
import ac.boar.protocol.listener.PacketListener;
import java.util.Set;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.AddPlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityDeltaPacket;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.RemoveEntityPacket;

public class ServerEntityPackets
implements PacketListener {
    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        Vec3 position;
        Object entity;
        RemoveEntityPacket packet;
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof RemoveEntityPacket) {
            packet = (RemoveEntityPacket)bedrockPacket;
            player.sendLatencyStack(immediate);
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                if (player.vehicleData != null && player.vehicleData.vehicleRuntimeId == packet.getUniqueEntityId()) {
                    player.vehicleData = null;
                }
                player.compensatedWorld.removeEntity(packet.getUniqueEntityId());
            });
        }
        if ((bedrockPacket = event.getPacket()) instanceof AddEntityPacket) {
            packet = (AddEntityPacket)bedrockPacket;
            entity = player.compensatedWorld.addToCache(player, packet.getRuntimeEntityId(), packet.getUniqueEntityId());
            if (entity == null) {
                return;
            }
            position = new Vec3(packet.getPosition());
            ((EntityCache)entity).setServerPosition(position);
            ((EntityCache)entity).init();
            ((EntityCache)entity).interpolate(position, false);
            ((EntityCache)entity).setMetadata(packet.getMetadata());
        }
        if ((entity = event.getPacket()) instanceof AddPlayerPacket) {
            packet = (AddPlayerPacket)entity;
            if ((entity = player.compensatedWorld.addToCache(player, packet.getRuntimeEntityId(), packet.getUniqueEntityId())) == null) {
                return;
            }
            position = new Vec3(packet.getPosition());
            ((EntityCache)entity).setServerPosition(position);
            ((EntityCache)entity).init();
            ((EntityCache)entity).interpolate(position, false);
            ((EntityCache)entity).setMetadata(packet.getMetadata());
        }
        if ((entity = event.getPacket()) instanceof MoveEntityDeltaPacket) {
            boolean useless;
            packet = (MoveEntityDeltaPacket)entity;
            if ((entity = player.compensatedWorld.getEntity(packet.getRuntimeEntityId())) == null) {
                return;
            }
            Set flags = packet.getFlags();
            boolean bl = useless = !flags.contains(MoveEntityDeltaPacket.Flag.HAS_X) && !flags.contains(MoveEntityDeltaPacket.Flag.HAS_Y) && !flags.contains(MoveEntityDeltaPacket.Flag.HAS_Z);
            if (useless) {
                return;
            }
            float x = packet.getX();
            float y = packet.getY();
            float z = packet.getZ();
            if (!flags.contains(MoveEntityDeltaPacket.Flag.HAS_X)) {
                x = ((EntityCache)entity).getServerPosition().getX();
            }
            if (!flags.contains(MoveEntityDeltaPacket.Flag.HAS_Y)) {
                y = ((EntityCache)entity).getServerPosition().getY();
            }
            if (!flags.contains(MoveEntityDeltaPacket.Flag.HAS_Z)) {
                z = ((EntityCache)entity).getServerPosition().getZ();
            }
            this.queuePositionUpdate(event, (EntityCache)entity, Vector3f.from((float)x, (float)y, (float)z), true);
        }
        if ((entity = event.getPacket()) instanceof MoveEntityAbsolutePacket) {
            packet = (MoveEntityAbsolutePacket)entity;
            if ((entity = player.compensatedWorld.getEntity(packet.getRuntimeEntityId())) == null) {
                return;
            }
            this.queuePositionUpdate(event, (EntityCache)entity, packet.getPosition(), false);
        }
        if ((entity = event.getPacket()) instanceof MovePlayerPacket) {
            packet = (MovePlayerPacket)entity;
            if (packet.getRuntimeEntityId() == player.runtimeEntityId) {
                return;
            }
            entity = player.compensatedWorld.getEntity(packet.getRuntimeEntityId());
            if (entity == null) {
                return;
            }
            this.queuePositionUpdate(event, (EntityCache)entity, packet.getPosition(), packet.getMode() == MovePlayerPacket.Mode.NORMAL);
        }
    }

    private void queuePositionUpdate(CloudburstPacketEvent event, EntityCache entity, Vector3f raw, boolean lerp) {
        BoarPlayer player = event.getPlayer();
        Vec3 position = new Vec3(raw.sub(0.0f, entity.getYOffset(), 0.0f));
        double distance = entity.getServerPosition().squaredDistanceTo(position);
        if (distance < 1.0E-15) {
            return;
        }
        entity.setServerPosition(position);
        player.sendLatencyStack();
        long id = player.sentStackId.get();
        player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> entity.interpolate(position, lerp && distance < 4096.0));
        event.getPostTasks().add(() -> {
            player.sendLatencyStack();
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> entity.setPast(null));
        });
    }
}

