/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.compensated;

import ac.boar.anticheat.compensated.cache.container.ContainerCache;
import ac.boar.anticheat.compensated.cache.container.impl.PlayerContainerCache;
import ac.boar.anticheat.data.inventory.ItemCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.shaded.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.PotionMixData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.RecipeData;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class CompensatedInventory {
    private final BoarPlayer player;
    private Map<Integer, RecipeData> craftingData = new HashMap<Integer, RecipeData>();
    private Map<Integer, ItemData> creativeData = new HashMap<Integer, ItemData>();
    private List<PotionMixData> potionMixData = new ObjectArrayList<PotionMixData>();
    public int heldItemSlot;
    public final PlayerContainerCache inventoryContainer = new PlayerContainerCache(this);
    public final ContainerCache offhandContainer = new ContainerCache(this, 119, ContainerType.INVENTORY, null, -1L);
    public final ContainerCache armorContainer = new ContainerCache(this, 120, ContainerType.INVENTORY, null, -1L);
    public final ContainerCache hudContainer = new ContainerCache(this, 124, ContainerType.INVENTORY, null, -1L);
    public ContainerCache previousContainer = null;
    public ContainerCache openContainer = null;
    private final Map<Integer, ItemCache> bundleCache = new HashMap<Integer, ItemCache>();

    public ItemStack translate(ItemData data) {
        try {
            ItemStack stack = ItemTranslator.translateToJava((GeyserSession)this.player.getSession(), (ItemData)data);
            if (stack == null) {
                stack = new ItemStack(Items.AIR_ID);
            }
            return stack;
        }
        catch (Exception ignored) {
            return new ItemStack(Items.AIR_ID);
        }
    }

    public ItemData translate(ItemStack stack) {
        return ItemTranslator.translateToBedrock((GeyserSession)this.player.getSession(), (ItemStack)stack);
    }

    public ContainerCache getContainer(byte id) {
        if (id == this.inventoryContainer.getId()) {
            return this.inventoryContainer;
        }
        if (id == this.offhandContainer.getId()) {
            return this.offhandContainer;
        }
        if (id == this.armorContainer.getId()) {
            return this.armorContainer;
        }
        if (id == this.hudContainer.getId()) {
            return this.hudContainer;
        }
        if (this.openContainer != null && id == this.openContainer.getId()) {
            return this.openContainer;
        }
        return null;
    }

    @NonNull
    public static Map<BedrockEnchantment, Integer> getEnchantments(ItemData data) {
        if (data == null || data.getTag() == null || !data.getTag().containsKey((Object)"ench")) {
            return Map.of();
        }
        HashMap<BedrockEnchantment, Integer> enchantmentMap = new HashMap<BedrockEnchantment, Integer>();
        List enchantments = data.getTag().getList("ench", NbtType.COMPOUND);
        for (NbtMap nbtMap : enchantments) {
            if (!nbtMap.containsKey((Object)"id") || !nbtMap.containsKey((Object)"lvl")) continue;
            BedrockEnchantment bedrockEnchantment = BedrockEnchantment.getByBedrockId((int)nbtMap.getShort("id"));
            enchantmentMap.put(bedrockEnchantment, Integer.valueOf(nbtMap.getShort("lvl")));
        }
        return enchantmentMap;
    }

    @Generated
    public CompensatedInventory(BoarPlayer player) {
        this.player = player;
    }

    @Generated
    public BoarPlayer getPlayer() {
        return this.player;
    }

    @Generated
    public Map<Integer, RecipeData> getCraftingData() {
        return this.craftingData;
    }

    @Generated
    public void setCraftingData(Map<Integer, RecipeData> craftingData) {
        this.craftingData = craftingData;
    }

    @Generated
    public Map<Integer, ItemData> getCreativeData() {
        return this.creativeData;
    }

    @Generated
    public void setCreativeData(Map<Integer, ItemData> creativeData) {
        this.creativeData = creativeData;
    }

    @Generated
    public List<PotionMixData> getPotionMixData() {
        return this.potionMixData;
    }

    @Generated
    public void setPotionMixData(List<PotionMixData> potionMixData) {
        this.potionMixData = potionMixData;
    }

    @Generated
    public Map<Integer, ItemCache> getBundleCache() {
        return this.bundleCache;
    }
}

