/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.compensated.world.base;

import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.data.EntityDimensions;
import ac.boar.anticheat.data.block.BoarBlockState;
import ac.boar.anticheat.data.block.impl.BedBlockState;
import ac.boar.anticheat.data.block.impl.HoneyBlockState;
import ac.boar.anticheat.data.block.impl.SlimeBlockState;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.geyser.BoarChunk;
import ac.boar.anticheat.util.geyser.BoarChunkSection;
import ac.boar.anticheat.util.math.Mutable;
import ac.boar.shaded.fastutil.longs.Long2ObjectMap;
import ac.boar.shaded.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityInfo;

public class CompensatedWorld {
    private final BoarPlayer player;
    private final Long2ObjectMap<BoarChunk> chunks = new Long2ObjectOpenHashMap<BoarChunk>();
    private BedrockDimension dimension;
    private final Long2ObjectMap<EntityCache> entities = new Long2ObjectOpenHashMap<EntityCache>();
    private final Map<Long, Long> uniqueIdToRuntimeId = new HashMap<Long, Long>();

    public void removeEntity(long uniqueId) {
        Long key = this.uniqueIdToRuntimeId.remove(uniqueId);
        if (key == null) {
            return;
        }
        this.entities.remove(key);
    }

    public EntityCache getEntity(long id) {
        return (EntityCache)this.entities.get(id);
    }

    public EntityCache addToCache(BoarPlayer player, long runtimeId, long uniqueId) {
        Entity entity = player.getSession().getEntityCache().getEntityByGeyserId(runtimeId);
        if (entity == null || entity.getDefinition() == null || runtimeId == player.runtimeEntityId) {
            return null;
        }
        EntityDefinition definition = entity.getDefinition();
        boolean affectedByOffset = definition.entityType() == EntityType.PLAYER || definition.identifier().equalsIgnoreCase("minecraft:boat") || definition.identifier().equalsIgnoreCase("minecraft:chest_boat");
        player.sendLatencyStack();
        EntityCache cache = new EntityCache(player, definition.entityType(), definition, player.sentStackId.get(), runtimeId);
        cache.setAffectedByOffset(affectedByOffset);
        cache.setDimensions(EntityDimensions.fixed(definition.width(), definition.height()));
        this.entities.put(runtimeId, cache);
        this.uniqueIdToRuntimeId.put(uniqueId, runtimeId);
        return cache;
    }

    public void addToCache(int x, int z, BoarChunkSection[] chunks, List<BlockEntityInfo> blockEntities) {
        long chunkPosition = MathUtils.chunkPositionToLong((int)x, (int)z);
        this.chunks.put(chunkPosition, new BoarChunk(chunks, blockEntities));
    }

    public void removeFromCache(int x, int z) {
        this.chunks.remove(MathUtils.chunkPositionToLong((int)x, (int)z));
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        return this.getChunk(chunkX >> 4, chunkZ >> 4) != null;
    }

    public void updateBlock(Vector3i position, int layer, int block) {
        this.updateBlock(position.getX(), position.getY(), position.getZ(), layer, block);
    }

    public void updateBlock(int x, int y, int z, int layer, int block) {
        BoarChunkSection[] column = this.getChunkSections(x >> 4, z >> 4);
        if (column == null) {
            return;
        }
        if (y < this.getMinY() || y - this.getMinY() >> 4 > column.length - 1) {
            return;
        }
        BoarChunkSection palette = column[y - this.getMinY() >> 4];
        if (palette == null) {
            if (block != 0) {
                column[y - this.getMinY() >> 4] = palette = new BoarChunkSection(this.player.BEDROCK_AIR, 0);
            } else {
                return;
            }
        }
        palette.setFullBlock(x & 0xF, y & 0xF, z & 0xF, layer, block);
    }

    public BoarBlockState getBlockState(Mutable vector3i, int layer) {
        return this.getBlockState(vector3i.getX(), vector3i.getY(), vector3i.getZ(), layer);
    }

    public BoarBlockState getBlockState(Vector3i vector3i, int layer) {
        return this.getBlockState(vector3i.getX(), vector3i.getY(), vector3i.getZ(), layer);
    }

    public BoarBlockState getBlockState(int x, int y, int z, int layer) {
        BlockState state = BlockState.of((int)this.getBlockAt(x, y, z, layer));
        if (state.is(Blocks.HONEY_BLOCK)) {
            return new HoneyBlockState(state, Vector3i.from((int)x, (int)y, (int)z), layer);
        }
        if (state.is(Blocks.SLIME_BLOCK)) {
            return new SlimeBlockState(state, Vector3i.from((int)x, (int)y, (int)z), layer);
        }
        if (state.block().toString().contains("_bed")) {
            return new BedBlockState(state, Vector3i.from((int)x, (int)y, (int)z), layer);
        }
        return new BoarBlockState(state, Vector3i.from((int)x, (int)y, (int)z), layer);
    }

    public int getRawBlockAt(int x, int y, int z, int layer) {
        BoarChunkSection[] column = this.getChunkSections(x >> 4, z >> 4);
        if (column == null) {
            return this.player.BEDROCK_AIR;
        }
        if (y < this.getMinY() || y - this.getMinY() >> 4 > column.length - 1) {
            return this.player.BEDROCK_AIR;
        }
        BoarChunkSection chunk = column[y - this.getMinY() >> 4];
        if (chunk != null) {
            try {
                return chunk.getFullBlock(x & 0xF, y & 0xF, z & 0xF, layer);
            }
            catch (Exception e) {
                return this.player.BEDROCK_AIR;
            }
        }
        return this.player.BEDROCK_AIR;
    }

    public int getBlockAt(int x, int y, int z, int layer) {
        return this.player.bedrockBlockToJava.getOrDefault(this.getRawBlockAt(x, y, z, layer), 0);
    }

    public BlockEntityInfo getBlockEntity(int x, int y, int z) {
        BoarChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk == null) {
            return null;
        }
        for (BlockEntityInfo info : chunk.blockEntities()) {
            if (info.getX() != x || info.getY() != y || info.getZ() != z) continue;
            return info;
        }
        return null;
    }

    public BoarChunk getChunk(int chunkX, int chunkZ) {
        long chunkPosition = MathUtils.chunkPositionToLong((int)chunkX, (int)chunkZ);
        return this.chunks.getOrDefault(chunkPosition, (BoarChunk)null);
    }

    private BoarChunkSection[] getChunkSections(int chunkX, int chunkZ) {
        BoarChunk chunk = this.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            return null;
        }
        return chunk.sections();
    }

    public int getMinY() {
        return this.dimension.minY();
    }

    public int getHeightY() {
        return this.dimension.maxY();
    }

    @Generated
    public CompensatedWorld(BoarPlayer player) {
        this.player = player;
    }

    @Generated
    public void setDimension(BedrockDimension dimension) {
        this.dimension = dimension;
    }

    @Generated
    public BoarPlayer getPlayer() {
        return this.player;
    }

    @Generated
    public Long2ObjectMap<BoarChunk> getChunks() {
        return this.chunks;
    }

    @Generated
    public BedrockDimension getDimension() {
        return this.dimension;
    }

    @Generated
    public Long2ObjectMap<EntityCache> getEntities() {
        return this.entities;
    }

    @Generated
    public Map<Long, Long> getUniqueIdToRuntimeId() {
        return this.uniqueIdToRuntimeId;
    }
}

