/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.player.data.tracker;

import ac.boar.anticheat.data.ItemUseTracker;
import ac.boar.anticheat.player.BoarPlayer;
import java.util.EnumSet;
import java.util.Set;
import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;

public final class FlagTracker {
    private final Set<EntityFlag> flags = EnumSet.noneOf(EntityFlag.class);
    private boolean flying;
    private boolean wasFlying;

    public void flying(boolean flying) {
        this.flying = this.wasFlying = flying;
    }

    public void setFlying(boolean flying) {
        this.wasFlying = this.flying;
        this.flying = flying;
    }

    public void clear() {
        this.flags.clear();
    }

    public void set(BoarPlayer player, Set<EntityFlag> flags) {
        this.set(player, flags, true);
    }

    public void set(BoarPlayer player, Set<EntityFlag> flags, boolean server) {
        boolean oldUsingItem;
        boolean sneaking = this.has(EntityFlag.SNEAKING);
        boolean swimming = this.has(EntityFlag.SWIMMING);
        this.clear();
        this.flags.addAll(flags);
        if (server) {
            this.set(EntityFlag.SNEAKING, sneaking);
            this.set(EntityFlag.SWIMMING, swimming);
        }
        boolean bl = oldUsingItem = player.getItemUseTracker().getUsedItem() != ItemData.AIR;
        if (this.has(EntityFlag.USING_ITEM)) {
            this.set(EntityFlag.USING_ITEM, oldUsingItem);
            if (!oldUsingItem) {
                player.getItemUseTracker().setDirtyUsing(ItemUseTracker.DirtyUsing.METADATA);
            }
        } else {
            player.getItemUseTracker().setDirtyUsing(ItemUseTracker.DirtyUsing.NONE);
        }
    }

    public void set(EntityFlag flag, boolean value) {
        if (value) {
            this.flags.add(flag);
        } else {
            this.flags.remove(flag);
        }
    }

    public boolean has(EntityFlag flag) {
        return this.flags.contains(flag);
    }

    public EnumSet<EntityFlag> cloneFlags() {
        EnumSet<EntityFlag> flags = EnumSet.noneOf(EntityFlag.class);
        flags.addAll(this.flags);
        return flags;
    }

    @Generated
    public boolean isFlying() {
        return this.flying;
    }

    @Generated
    public boolean isWasFlying() {
        return this.wasFlying;
    }
}

