/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.reflect.proxy;

import ac.boar.shaded.reflect.Constructors;
import ac.boar.shaded.reflect.Objects;
import ac.boar.shaded.reflect.exceptions.ConstructorNotFoundException;
import ac.boar.shaded.reflect.proxy.InvocationHandler;
import ac.boar.shaded.reflect.proxy.impl.Proxy;
import java.lang.reflect.Constructor;

public class ProxyClass {
    private final Class<?> proxyClass;
    private InvocationHandler invocationHandler;

    public ProxyClass(Class<?> proxyClass, InvocationHandler invocationHandler) {
        this.proxyClass = proxyClass;
        this.invocationHandler = invocationHandler;
    }

    public Class<?> getProxyClass() {
        return this.proxyClass;
    }

    public InvocationHandler getInvocationHandler() {
        return this.invocationHandler;
    }

    public void setInvocationHandler(InvocationHandler invocationHandler) {
        this.invocationHandler = invocationHandler;
    }

    public <T> T allocateInstance() {
        Object instance = Objects.allocate(this.proxyClass);
        ((Proxy)instance).setInvocationHandler(this.invocationHandler);
        return (T)instance;
    }

    public <T> T instantiate(Class<?>[] constructorParameters, Object[] constructorArguments) {
        Constructor<?> constructor = Constructors.getDeclaredConstructor(this.proxyClass, constructorParameters);
        if (constructor == null) {
            throw new ConstructorNotFoundException("Proxy", constructorParameters);
        }
        Object instance = Constructors.invoke(constructor, constructorArguments);
        ((Proxy)instance).setInvocationHandler(this.invocationHandler);
        return (T)instance;
    }
}

