/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.data.block;

import ac.boar.anticheat.collision.BedrockCollision;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.block.BlockUtil;
import ac.boar.anticheat.util.math.Box;
import ac.boar.anticheat.util.math.Mutable;
import ac.boar.anticheat.util.math.Vec3;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.property.Property;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.cache.tags.BlockTag;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.SolidCollision;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class BoarBlockState {
    private final BlockState state;
    private final Vector3i position;
    private final int layer;

    public boolean isFaceSturdy(BoarPlayer player) {
        if (this.state.is(Blocks.SCAFFOLDING)) {
            return false;
        }
        return BlockUtils.getCollision((int)this.state.javaId()) instanceof SolidCollision;
    }

    public boolean isAir() {
        return this.state.is(Blocks.AIR) || this.state.is(Blocks.CAVE_AIR) || this.state.is(Blocks.VOID_AIR);
    }

    public void onSteppedOn(BoarPlayer player, Vector3i vector3i) {
    }

    public boolean blocksMotion(BoarPlayer player) {
        return !this.state.is(Blocks.COBWEB) && !this.state.is(Blocks.BAMBOO_SAPLING) && this.isSolid(player);
    }

    public Vec3 pre12180RandomOffset() {
        int v1 = 3129871 * this.position.getX() ^ 116129781 * this.position.getZ();
        long randomSeed = Integer.toUnsignedLong(v1 * (42317861 * v1 + 11));
        long randomX = randomSeed % 12L + 1L;
        long randomZ = (randomSeed >> 8) % 12L + 1L;
        float offsetX = (float)randomX * 0.0625f;
        float offsetZ = (float)randomZ * 0.0625f;
        return new Vec3(offsetX, 0.0f, offsetZ);
    }

    public void entityInside(BoarPlayer player, Mutable pos) {
        boolean zLargerThanThreshold;
        if (this.state.is(Blocks.POWDER_SNOW) && player.boundingBox.offset(0.0f, 0.001f, 0.0f).contains(pos.getX(), pos.getY(), pos.getZ())) {
            return;
        }
        if (this.state.is(Blocks.BUBBLE_COLUMN)) {
            boolean drag = (Boolean)this.state.getValue((Property)Properties.DRAG);
            Vec3 lv = player.velocity;
            lv.y = player.compensatedWorld.getBlockState(pos.getX(), pos.getY() + 1, pos.getZ(), 0).isAir() ? (drag ? Math.max(-0.9f, lv.y - 0.03f) : Math.min(1.8f, lv.y + 0.1f)) : (drag ? Math.max(-0.3f, lv.y - 0.03f) : Math.min(0.7f, lv.y + 0.06f));
        }
        Vec3 movementMultiplier = Vec3.ZERO;
        if (this.state.is(Blocks.SWEET_BERRY_BUSH)) {
            movementMultiplier = new Vec3(0.8f, 0.75f, 0.8f);
        } else if (this.state.is(Blocks.POWDER_SNOW) && player.position.y < (float)(pos.getY() + 1) - 1.0E-5f) {
            movementMultiplier = new Vec3(0.9f, 1.5f, 0.9f);
        } else if (this.state.is(Blocks.COBWEB)) {
            movementMultiplier = new Vec3(0.25f, 0.05f, 0.25f);
            if (player.hasEffect(Effect.WEAVING)) {
                movementMultiplier = new Vec3(0.5f, 0.25f, 0.5f);
            }
        }
        if (movementMultiplier.equals(Vec3.ZERO)) {
            return;
        }
        boolean xLargerThanThreshold = (double)Math.abs(player.stuckSpeedMultiplier.x) >= 1.0E-7;
        boolean yLargerThanThreshold = (double)Math.abs(player.stuckSpeedMultiplier.y) >= 1.0E-7;
        boolean bl = zLargerThanThreshold = (double)Math.abs(player.stuckSpeedMultiplier.z) >= 1.0E-7;
        if (xLargerThanThreshold || yLargerThanThreshold || zLargerThanThreshold) {
            player.stuckSpeedMultiplier.x = Math.min(player.stuckSpeedMultiplier.x, movementMultiplier.x);
            player.stuckSpeedMultiplier.y = Math.min(player.stuckSpeedMultiplier.y, movementMultiplier.y);
            player.stuckSpeedMultiplier.z = Math.min(player.stuckSpeedMultiplier.z, movementMultiplier.z);
        } else {
            player.stuckSpeedMultiplier = movementMultiplier;
        }
    }

    private boolean isSolid(BoarPlayer player) {
        List<Box> boxes = this.findCollision(player, Vector3i.ZERO, Box.EMPTY, false);
        if (boxes.isEmpty()) {
            return false;
        }
        Box box = new Box(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        for (Box box1 : boxes) {
            box = box1.union(box);
        }
        return (double)box.getAverageSideLength() >= 0.7291666666666666 || (double)box.getLengthY() >= 1.0;
    }

    public void updateEntityMovementAfterFallOn(BoarPlayer player, boolean living) {
        player.velocity.y = 0.0f;
    }

    public List<Box> findCollision(BoarPlayer player, Vector3i pos, Box playerAABB, boolean checkAAB) {
        BlockState state = this.state;
        if (player.getSession().getTagCache().is(BlockTag.FENCES, (Object)state.block())) {
            state = BlockUtil.findFenceBlockState(player, this.getState(), pos);
        } else if (state.is(Blocks.IRON_BARS) || state.toString().toLowerCase(Locale.ROOT).contains("glass_pane")) {
            state = BlockUtil.findIronBarsBlockState(player, this.getState(), pos);
        }
        ArrayList<Box> list = new ArrayList<Box>();
        List<Box> collisions = BedrockCollision.getCollisionBox(player, pos, state);
        if (collisions != null) {
            for (Box aabb : collisions) {
                aabb = aabb.offset(pos.getX(), pos.getY(), pos.getZ());
                if (checkAAB && !aabb.intersects(playerAABB)) continue;
                list.add(aabb);
            }
            return list;
        }
        BlockCollision collision = BlockUtils.getCollision((int)state.javaId());
        if (collision == null) {
            return list;
        }
        for (BoundingBox geyserBB : collision.getBoundingBoxes()) {
            Box box = new Box(geyserBB).offset(pos.getX(), pos.getY(), pos.getZ());
            if (checkAAB && !box.intersects(playerAABB)) continue;
            list.add(box);
        }
        return list;
    }

    public float getJumpFactor() {
        return this.state.is(Blocks.HONEY_BLOCK) ? 0.6f : 1.0f;
    }

    public float getFriction() {
        if (this.state.is(Blocks.ICE) || this.state.is(Blocks.PACKED_ICE) || this.state.is(Blocks.FROSTED_ICE)) {
            return 0.98f;
        }
        if (this.state.is(Blocks.SLIME_BLOCK) || this.state.is(Blocks.HONEY_BLOCK)) {
            return 0.8f;
        }
        if (this.state.is(Blocks.BLUE_ICE)) {
            return 0.989f;
        }
        return 0.6f;
    }

    @Generated
    public BoarBlockState(BlockState state, Vector3i position, int layer) {
        this.state = state;
        this.position = position;
        this.layer = layer;
    }

    @Generated
    public BlockState getState() {
        return this.state;
    }

    @Generated
    public Vector3i getPosition() {
        return this.position;
    }

    @Generated
    public int getLayer() {
        return this.layer;
    }
}

