/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.input;

import ac.boar.anticheat.check.impl.timer.Timer;
import ac.boar.anticheat.data.input.PredictionData;
import ac.boar.anticheat.packets.input.legacy.LegacyAuthInputPackets;
import ac.boar.anticheat.packets.input.teleport.TeleportHandler;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.prediction.PredictionRunner;
import ac.boar.anticheat.prediction.engine.data.Vector;
import ac.boar.anticheat.teleport.data.TeleportCache;
import ac.boar.anticheat.util.DimensionUtil;
import ac.boar.anticheat.util.math.Vec3;
import ac.boar.protocol.event.CloudburstPacketEvent;
import ac.boar.protocol.listener.PacketListener;
import java.util.Iterator;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ChangeDimensionPacket;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.cloudburstmc.protocol.bedrock.packet.RespawnPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.level.BedrockDimension;

public class AuthInputPackets
extends TeleportHandler
implements PacketListener {
    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        if (event.isCancelled()) {
            return;
        }
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (!(bedrockPacket instanceof PlayerAuthInputPacket)) {
            return;
        }
        PlayerAuthInputPacket packet = (PlayerAuthInputPacket)bedrockPacket;
        ++player.sinceLoadingScreen;
        Timer timer = (Timer)player.getCheckHolder().get(Timer.class);
        if (player.tick == Long.MIN_VALUE && timer == null) {
            player.tick = Math.max(0L, packet.getTick()) - 1L;
        }
        if (timer != null) {
            if (timer.tick(packet.getTick())) {
                return;
            }
        } else {
            ++player.tick;
            if (packet.getTick() != player.tick || packet.getTick() <= 0L) {
                player.kick("Invalid tick id=" + packet.getTick());
                return;
            }
        }
        player.breakingValidator.handle(packet);
        player.tick();
        LegacyAuthInputPackets.processAuthInput(player, packet, true);
        LegacyAuthInputPackets.updateUnvalidatedPosition(player, packet);
        if (player.vehicleData != null) {
            player.position = player.unvalidatedPosition;
            return;
        }
        if (player.isMovementExempted()) {
            Map.Entry entry;
            player.setPos(player.unvalidatedPosition);
            Iterator iterator = player.queuedVelocities.entrySet().iterator();
            while (iterator.hasNext() && (entry = iterator.next()) != null && (Long)entry.getKey() < player.receivedStackId.get()) {
                iterator.remove();
            }
            player.predictionResult = new PredictionData(Vec3.ZERO, player.velocity.y < 0.0f && player.getInputData().contains(PlayerAuthInputData.VERTICAL_COLLISION) ? new Vec3(0.0f, 1.0f, 0.0f) : Vec3.ZERO, player.unvalidatedTickEnd);
            player.velocity = player.unvalidatedTickEnd.clone();
            player.bestPossibility = Vector.NONE;
        } else {
            new PredictionRunner(player).run();
        }
        this.processQueuedTeleports(player, packet);
        LegacyAuthInputPackets.doPostPrediction(player, packet);
    }

    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        ChangeDimensionPacket packet;
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof ChangeDimensionPacket) {
            packet = (ChangeDimensionPacket)bedrockPacket;
            int dimensionId = packet.getDimension();
            BedrockDimension dimension = DimensionUtil.dimensionFromId(dimensionId);
            player.sendLatencyStack(immediate);
            player.getTeleportUtil().getQueuedTeleports().add(new TeleportCache.DimensionSwitch(player.sentStackId.get(), new Vec3(packet.getPosition().up(EntityDefinitions.PLAYER.offset()))));
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                player.compensatedWorld.getChunks().clear();
                player.compensatedWorld.setDimension(dimension);
                player.currentLoadingScreen = packet.getLoadingScreenId();
                player.inLoadingScreen = true;
                player.getFlagTracker().clear();
                player.getFlagTracker().flying(false);
                player.tick = Long.MIN_VALUE;
            });
        }
        if ((bedrockPacket = event.getPacket()) instanceof RespawnPacket && (packet = (RespawnPacket)bedrockPacket).getState() == RespawnPacket.State.SERVER_READY) {
            if (packet.getRuntimeEntityId() != 0L) {
                return;
            }
            player.sendLatencyStack(immediate);
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                player.tick = Long.MIN_VALUE;
            });
        }
        if ((bedrockPacket = event.getPacket()) instanceof MovePlayerPacket) {
            packet = (MovePlayerPacket)bedrockPacket;
            if (packet.getMode() == MovePlayerPacket.Mode.HEAD_ROTATION) {
                return;
            }
            if (player.runtimeEntityId != packet.getRuntimeEntityId()) {
                return;
            }
            if (packet.getMode() == MovePlayerPacket.Mode.NORMAL) {
                packet.setMode(MovePlayerPacket.Mode.TELEPORT);
            }
            player.getTeleportUtil().queueTeleport(new Vec3(packet.getPosition()), immediate);
        }
    }
}

