/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.data.vanilla;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.data.attribute.AttributeModifierData;
import org.cloudburstmc.protocol.bedrock.data.attribute.AttributeOperation;

public class AttributeInstance {
    private float baseValue;
    private float value;
    private boolean dirty = true;
    private final Map<String, AttributeModifierData> modifiers = new HashMap<String, AttributeModifierData>();

    public AttributeInstance(float baseValue) {
        this.baseValue = baseValue;
    }

    public void setBaseValue(float baseValue) {
        if (this.baseValue == baseValue) {
            return;
        }
        this.baseValue = this.value;
        this.setDirty();
    }

    public void clearModifiers() {
        if (!this.modifiers.isEmpty()) {
            this.update();
        }
        this.modifiers.clear();
    }

    public void removeModifier(String id) {
        AttributeModifierData lv = this.modifiers.remove(id);
        if (lv != null) {
            this.update();
        }
    }

    public void addTemporaryModifier(AttributeModifierData modifier) {
        this.addModifier(modifier);
    }

    private void addModifier(AttributeModifierData modifier) {
        AttributeModifierData lv = this.modifiers.putIfAbsent(modifier.getId(), modifier);
        if (lv == null) {
            this.update();
        }
    }

    protected void update() {
        this.value = this.computeValue();
    }

    public float getValue() {
        if (this.dirty) {
            this.value = this.computeValue();
            this.dirty = false;
        }
        return this.value;
    }

    public void setDirty() {
        this.dirty = true;
    }

    private float computeValue() {
        AttributeModifierData modifier;
        float base = this.getBaseValue();
        for (Map.Entry<String, AttributeModifierData> entry : this.modifiers.entrySet()) {
            AttributeModifierData modifier2 = entry.getValue();
            if (modifier2.getOperation() != AttributeOperation.ADDITION) continue;
            base += modifier2.getAmount();
        }
        float value = base;
        for (Map.Entry<String, AttributeModifierData> entry : this.modifiers.entrySet()) {
            modifier = entry.getValue();
            if (modifier.getOperation() != AttributeOperation.MULTIPLY_BASE) continue;
            value += base * modifier.getAmount();
        }
        for (Map.Entry<String, AttributeModifierData> entry : this.modifiers.entrySet()) {
            modifier = entry.getValue();
            if (modifier.getOperation() != AttributeOperation.MULTIPLY_TOTAL) continue;
            value *= 1.0f + modifier.getAmount();
        }
        return value;
    }

    @Generated
    public float getBaseValue() {
        return this.baseValue;
    }

    @Generated
    public boolean isDirty() {
        return this.dirty;
    }

    @Generated
    public Map<String, AttributeModifierData> getModifiers() {
        return this.modifiers;
    }

    @Generated
    public void setValue(float value) {
        this.value = value;
    }
}

