/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.player;

import ac.boar.anticheat.compensated.CompensatedInventory;
import ac.boar.anticheat.compensated.cache.container.ContainerCache;
import ac.boar.anticheat.compensated.cache.container.impl.TradeContainerCache;
import ac.boar.anticheat.data.inventory.ItemCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.protocol.event.CloudburstPacketEvent;
import ac.boar.protocol.listener.PacketListener;
import java.util.Objects;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.MultiRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.RecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapedRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.SmithingTransformRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.SmithingTrimRecipeData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerClosePacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerOpenPacket;
import org.cloudburstmc.protocol.bedrock.packet.CraftingDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.CreativeContentPacket;
import org.cloudburstmc.protocol.bedrock.packet.InteractPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventoryContentPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventoryTransactionPacket;
import org.cloudburstmc.protocol.bedrock.packet.ItemStackRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.MobEquipmentPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerHotbarPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateEquipPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateTradePacket;

public class PlayerInventoryPackets
implements PacketListener {
    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        BedrockPacket cancelled2;
        InventoryTransactionPacket packet;
        BoarPlayer player = event.getPlayer();
        CompensatedInventory inventory = player.compensatedInventory;
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof InventoryTransactionPacket) {
            packet = (InventoryTransactionPacket)bedrockPacket;
            try {
                boolean cancelled2 = !player.transactionValidator.handle(packet);
                event.setCancelled(cancelled2);
            }
            catch (Exception cancelled2) {
                // empty catch block
            }
        }
        if ((cancelled2 = event.getPacket()) instanceof ItemStackRequestPacket) {
            packet = (ItemStackRequestPacket)cancelled2;
            player.transactionValidator.handle((ItemStackRequestPacket)packet);
        }
        if ((cancelled2 = event.getPacket()) instanceof InteractPacket) {
            packet = (InteractPacket)cancelled2;
            if (player.runtimeEntityId != packet.getRuntimeEntityId()) {
                return;
            }
            if (packet.getAction() == InteractPacket.Action.OPEN_INVENTORY) {
                // empty if block
            }
        }
        if ((cancelled2 = event.getPacket()) instanceof ContainerClosePacket) {
            packet = (ContainerClosePacket)cancelled2;
            if (inventory.openContainer == null) {
                return;
            }
            if (packet.getId() != inventory.openContainer.getId() && packet.getId() != -1) {
                return;
            }
            inventory.openContainer = null;
        }
        if ((cancelled2 = event.getPacket()) instanceof MobEquipmentPacket) {
            packet = (MobEquipmentPacket)cancelled2;
            int newSlot = packet.getHotbarSlot();
            if (player.runtimeEntityId != packet.getRuntimeEntityId()) {
                return;
            }
            if (newSlot < 0 || newSlot > 8 || packet.getContainerId() != 0 || inventory.heldItemSlot == newSlot) {
                return;
            }
            inventory.heldItemSlot = newSlot;
        }
    }

    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        CreativeContentPacket packet;
        BoarPlayer player = event.getPlayer();
        CompensatedInventory inventory = player.compensatedInventory;
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof CreativeContentPacket) {
            packet = (CreativeContentPacket)bedrockPacket;
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                inventory.getCreativeData().clear();
                for (CreativeItemData data : packet.getContents()) {
                    inventory.getCreativeData().put(data.getNetId(), data.getItem());
                }
            });
        }
        if ((bedrockPacket = event.getPacket()) instanceof CraftingDataPacket) {
            packet = (CraftingDataPacket)bedrockPacket;
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> PlayerInventoryPackets.lambda$onPacketSend$1(inventory, (CraftingDataPacket)packet));
        }
        if ((bedrockPacket = event.getPacket()) instanceof ContainerOpenPacket) {
            packet = (ContainerOpenPacket)bedrockPacket;
            player.sendLatencyStack(immediate);
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> PlayerInventoryPackets.lambda$onPacketSend$3(inventory, (ContainerOpenPacket)packet));
        }
        if ((bedrockPacket = event.getPacket()) instanceof UpdateEquipPacket) {
            packet = (UpdateEquipPacket)bedrockPacket;
        }
        if ((bedrockPacket = event.getPacket()) instanceof UpdateTradePacket) {
            packet = (UpdateTradePacket)bedrockPacket;
            if (packet.getPlayerUniqueEntityId() != player.runtimeEntityId || packet.getContainerType() != ContainerType.TRADE) {
                return;
            }
            player.sendLatencyStack(immediate);
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> PlayerInventoryPackets.lambda$onPacketSend$4(inventory, (UpdateTradePacket)packet));
        }
        if ((bedrockPacket = event.getPacket()) instanceof InventorySlotPacket) {
            packet = (InventorySlotPacket)bedrockPacket;
            player.sendLatencyStack(immediate);
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> PlayerInventoryPackets.lambda$onPacketSend$5((InventorySlotPacket)packet, inventory));
        }
        if ((bedrockPacket = event.getPacket()) instanceof InventoryContentPacket) {
            packet = (InventoryContentPacket)bedrockPacket;
            player.sendLatencyStack(immediate);
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> PlayerInventoryPackets.lambda$onPacketSend$6((InventoryContentPacket)packet, inventory));
        }
        if ((bedrockPacket = event.getPacket()) instanceof PlayerHotbarPacket) {
            packet = (PlayerHotbarPacket)bedrockPacket;
            if (packet.getContainerId() != inventory.inventoryContainer.getId() || !packet.isSelectHotbarSlot()) {
                return;
            }
            int slot = packet.getSelectedHotbarSlot();
            if (slot >= 0 && slot < 9) {
                player.sendLatencyStack();
                player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                    inventory.heldItemSlot = slot;
                });
            }
        }
    }

    private static /* synthetic */ void lambda$onPacketSend$6(InventoryContentPacket packet, CompensatedInventory inventory) {
        if (packet.getContainerId() == 125) {
            ItemCache cache;
            try {
                cache = inventory.getBundleCache().get(Objects.requireNonNull(packet.getStorageItem().getTag()).getInt("bundle_id"));
            }
            catch (Exception ignored) {
                return;
            }
            if (cache == null) {
                return;
            }
            for (int i = 0; i < packet.getContents().size() && i < 64; ++i) {
                cache.getBundle().getContents()[i] = ItemCache.build(inventory, (ItemData)packet.getContents().get(i));
            }
            return;
        }
        ContainerCache container = inventory.getContainer((byte)packet.getContainerId());
        if (container == null) {
            return;
        }
        for (int i = 0; i < packet.getContents().size(); ++i) {
            container.set(i, (ItemData)packet.getContents().get(i), false);
        }
    }

    private static /* synthetic */ void lambda$onPacketSend$5(InventorySlotPacket packet, CompensatedInventory inventory) {
        if (packet.getContainerId() == 125) {
            ItemCache cache;
            try {
                cache = inventory.getBundleCache().get(Objects.requireNonNull(packet.getStorageItem().getTag()).getInt("bundle_id"));
            }
            catch (Exception ignored) {
                return;
            }
            if (cache == null) {
                return;
            }
            cache.getBundle().getContents()[packet.getSlot()] = ItemCache.build(inventory, packet.getItem());
            return;
        }
        ContainerCache container = inventory.getContainer((byte)packet.getContainerId());
        if (container == null) {
            return;
        }
        if (packet.getSlot() < 0 || packet.getSlot() >= container.getContainerSize()) {
            return;
        }
        container.set(packet.getSlot(), packet.getItem());
    }

    private static /* synthetic */ void lambda$onPacketSend$4(CompensatedInventory inventory, UpdateTradePacket packet) {
        try {
            inventory.openContainer = new TradeContainerCache(inventory, packet.getOffers(), (byte)packet.getContainerId(), packet.getContainerType(), Vector3i.ZERO, packet.getTraderUniqueEntityId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$onPacketSend$3(CompensatedInventory inventory, ContainerOpenPacket packet) {
        ContainerCache container = inventory.getContainer(packet.getId());
        inventory.openContainer = Objects.requireNonNullElseGet(container, () -> new ContainerCache(inventory, packet.getId(), packet.getType(), packet.getBlockPosition(), packet.getUniqueEntityId()));
    }

    private static /* synthetic */ void lambda$onPacketSend$1(CompensatedInventory inventory, CraftingDataPacket packet) {
        inventory.getCraftingData().clear();
        for (RecipeData data : packet.getCraftingData()) {
            switch (data.getType()) {
                case MULTI: {
                    MultiRecipeData recipe = (MultiRecipeData)data;
                    inventory.getCraftingData().put(recipe.getNetId(), (RecipeData)recipe);
                    break;
                }
                case SHAPED: {
                    MultiRecipeData recipe = (ShapedRecipeData)data;
                    inventory.getCraftingData().put(recipe.getNetId(), (RecipeData)recipe);
                    break;
                }
                case SHAPELESS: {
                    MultiRecipeData recipe = (ShapelessRecipeData)data;
                    inventory.getCraftingData().put(recipe.getNetId(), (RecipeData)recipe);
                    break;
                }
                case SMITHING_TRANSFORM: {
                    MultiRecipeData recipe = (SmithingTransformRecipeData)data;
                    inventory.getCraftingData().put(recipe.getNetId(), (RecipeData)recipe);
                    break;
                }
                case SMITHING_TRIM: {
                    MultiRecipeData recipe = (SmithingTrimRecipeData)data;
                    inventory.getCraftingData().put(recipe.getNetId(), (RecipeData)recipe);
                }
            }
        }
        inventory.setPotionMixData(packet.getPotionMixData());
    }
}

