/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.player;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.check.api.holder.CheckHolder;
import ac.boar.anticheat.collision.util.CuboidBlockIterator;
import ac.boar.anticheat.compensated.CompensatedInventory;
import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.compensated.world.CompensatedWorldImpl;
import ac.boar.anticheat.data.FluidState;
import ac.boar.anticheat.data.ItemUseTracker;
import ac.boar.anticheat.data.vanilla.AttributeInstance;
import ac.boar.anticheat.data.vanilla.StatusEffect;
import ac.boar.anticheat.player.data.PlayerData;
import ac.boar.anticheat.teleport.TeleportUtil;
import ac.boar.anticheat.util.LatencyUtil;
import ac.boar.anticheat.util.math.Box;
import ac.boar.anticheat.util.math.Mutable;
import ac.boar.anticheat.util.math.Vec3;
import ac.boar.anticheat.validator.blockbreak.ServerBreakBlockValidator;
import ac.boar.anticheat.validator.inventory.ItemTransactionValidator;
import ac.boar.mappings.BlockMappings;
import ac.boar.protocol.mitm.CloudburstReceiveListener;
import ac.boar.protocol.mitm.CloudburstSendListener;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.netty.handler.codec.raknet.common.RakSessionCodec;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.data.Ability;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.NetworkStackLatencyPacket;
import org.geysermc.geyser.api.command.CommandSource;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.Fluid;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public final class BoarPlayer
extends PlayerData {
    private final GeyserSession session;
    private BedrockServerSession cloudburstDownstream;
    public CloudburstSendListener cloudburstUpstream;
    public CloudburstReceiveListener downstreamPacketHandler;
    public RakSessionCodec rakSessionCodec;
    public long runtimeEntityId;
    public long javaEntityId;
    private final TeleportUtil teleportUtil = new TeleportUtil(this);
    private final CheckHolder checkHolder = new CheckHolder(this);
    private final LatencyUtil latencyUtil = new LatencyUtil(this);
    public final AtomicLong receivedStackId = new AtomicLong(-1L);
    public final AtomicLong sentStackId = new AtomicLong(0L);
    public final CompensatedWorldImpl compensatedWorld = new CompensatedWorldImpl(this);
    public final CompensatedInventory compensatedInventory = new CompensatedInventory(this);
    public ServerBreakBlockValidator serverBreakBlockValidator;
    public final ItemTransactionValidator transactionValidator = new ItemTransactionValidator(this);
    private final ItemUseTracker itemUseTracker = new ItemUseTracker(this);
    private final Map<UUID, CommandSource> trackedDebugPlayers = new ConcurrentHashMap<UUID, CommandSource>();
    public Vector3i cachedOnPos;

    public BoarPlayer(GeyserSession session) {
        this.session = session;
        org.geysermc.geyser.registry.type.BlockMappings mappings = session.getBlockMappings();
        for (int i = 0; i < mappings.getJavaToBedrockBlocks().length; ++i) {
            this.bedrockBlockToJava.put(mappings.getJavaToBedrockBlocks()[i].getRuntimeId(), i);
        }
        this.BEDROCK_AIR = mappings.getBedrockAir().getRuntimeId();
        this.AIR_IDS.add(this.BEDROCK_AIR);
        this.AIR_IDS.add(mappings.getBedrockBlockId(Blocks.CAVE_AIR.defaultBlockState().javaId()));
        this.AIR_IDS.add(mappings.getBedrockBlockId(Blocks.VOID_AIR.defaultBlockState().javaId()));
        for (GeyserAttributeType type : GeyserAttributeType.values()) {
            String identifier = type.getBedrockIdentifier();
            if (identifier == null || this.attributes.containsKey(type.getBedrockIdentifier())) continue;
            this.attributes.put(identifier, new AttributeInstance(type.getDefaultValue()));
        }
    }

    public void sendLatencyStack() {
        this.sendLatencyStack(false);
    }

    public void sendLatencyStack(boolean immediate) {
        if (this.doTimeOut()) {
            this.kick("Timed out.");
            return;
        }
        long id = this.sentStackId.incrementAndGet();
        if (id == 1234567890L || id == 9876543210L) {
            id = this.sentStackId.incrementAndGet();
        }
        NetworkStackLatencyPacket latencyPacket = new NetworkStackLatencyPacket();
        latencyPacket.setTimestamp(-id);
        latencyPacket.setFromServer(true);
        this.latencyUtil.addLatencyToQueue(id);
        if (immediate) {
            this.getSession().sendUpstreamPacketImmediately((BedrockPacket)latencyPacket);
        } else {
            this.getSession().sendUpstreamPacket((BedrockPacket)latencyPacket);
        }
    }

    private boolean doTimeOut() {
        if (this.sentStackId.get() - this.receivedStackId.get() < 5L) {
            return false;
        }
        if (this.latencyUtil.getNextSentTime() == this.latencyUtil.getLastSentTime()) {
            return false;
        }
        long latencyFault = Math.max(0L, this.latencyUtil.getNextSentTime().ms() - this.latencyUtil.getLastSentTime().ms());
        long distance = System.currentTimeMillis() - this.latencyUtil.getLastRespondTime();
        return (distance -= latencyFault) >= Boar.getConfig().maxLatencyWait();
    }

    public boolean isMovementExempted() {
        try {
            if (this.session.hasPermission("boar.exempt")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.abilities.contains(Ability.MAY_FLY) || this.getFlagTracker().isFlying() || this.getFlagTracker().isWasFlying();
    }

    public void kick(String reason) {
        this.session.disconnect(Boar.getInstance().getAlertManager().getPrefix((CommandSource)this.getSession()) + " " + reason);
    }

    public void tick() {
        this.getActiveEffects().entrySet().removeIf(filter -> {
            ((StatusEffect)filter.getValue()).tick();
            return ((StatusEffect)filter.getValue()).getDuration() == 0;
        });
        try {
            for (EntityCache cache : this.compensatedWorld.getEntities().values()) {
                if (cache.getPast() != null) {
                    cache.getPast().tick();
                }
                if (cache.getCurrent() == null) continue;
                cache.getCurrent().tick();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getItemUseTracker().preTick();
    }

    public void postTick() {
        --this.glideBoostTicks;
        this.getItemUseTracker().postTick();
    }

    public float getYOffset() {
        if (this.vehicleData != null) {
            String identifier;
            EntityCache cache = this.compensatedWorld.getEntity(this.vehicleData.vehicleRuntimeId);
            if (cache != null && ((identifier = cache.getDefinition().identifier()).equals("minecraft:boat") || identifier.equals("minecraft:chest_boat"))) {
                return EntityDefinitions.BIRCH_BOAT.offset();
            }
            return 0.0f;
        }
        return EntityDefinitions.PLAYER.offset();
    }

    public float getFrictionInfluencedSpeed(float slipperiness) {
        if (this.onGround) {
            float speed = this.getSpeed() * (0.21600002f / (slipperiness * slipperiness * slipperiness));
            if (!CompensatedInventory.getEnchantments(this.compensatedInventory.armorContainer.get(3).getData()).containsKey(BedrockEnchantment.SOUL_SPEED) && this.soulSandBelow) {
                speed *= 0.55f;
            }
            return speed;
        }
        return this.getFlagTracker().has(EntityFlag.SPRINTING) ? 0.026f : 0.02f;
    }

    public BlockState getInBlockState() {
        if (this.inBlockState == null) {
            this.inBlockState = this.compensatedWorld.getBlockState(this.position.toVector3i(), 0).getState();
        }
        return this.inBlockState;
    }

    public boolean onClimbable() {
        return BlockMappings.getClimbableBlocks().contains(this.getInBlockState().block());
    }

    public float getJumpPower() {
        return 0.42f * this.getBlockJumpFactor() + this.getJumpBoostPower();
    }

    public float getJumpBoostPower() {
        return this.hasEffect(Effect.JUMP_BOOST) ? 0.1f * ((float)this.getActiveEffects().get(Effect.JUMP_BOOST).getAmplifier() + 1.0f) : 0.0f;
    }

    public Vec3 jump(Vec3 vec3) {
        boolean autoJumping = this.getInputData().contains(PlayerAuthInputData.AUTO_JUMPING_IN_WATER);
        boolean jumping = this.getInputData().contains(PlayerAuthInputData.JUMPING);
        boolean canJumpInWater = this.getFluidHeight(Fluid.WATER) != 0.0f;
        boolean canJumpInLava = this.isInLava();
        if ((jumping || autoJumping) && (canJumpInWater || canJumpInLava)) {
            vec3 = vec3.add(0.0f, 0.04f, 0.0f);
        } else if (this.onGround && this.getInputData().contains(PlayerAuthInputData.START_JUMPING)) {
            vec3 = this.jumpFromGround(vec3);
        }
        return vec3;
    }

    private Vec3 jumpFromGround(Vec3 vec3) {
        float f = this.getJumpPower();
        if (f <= 1.0E-5f) {
            return vec3;
        }
        vec3 = new Vec3(vec3.x, Math.max(f, vec3.y), vec3.z);
        if (this.getFlagTracker().has(EntityFlag.SPRINTING)) {
            float g = this.yaw * ((float)Math.PI / 180);
            vec3 = vec3.add(-TrigMath.sin((double)g) * 0.2f, 0.0f, TrigMath.cos((double)g) * 0.2f);
        }
        return vec3;
    }

    public float getBlockJumpFactor() {
        float f = this.compensatedWorld.getBlockState(this.position.toVector3i(), 0).getJumpFactor();
        float g = this.compensatedWorld.getBlockState(this.getBlockPosBelowThatAffectsMyMovement(), 0).getJumpFactor();
        return (double)f == 1.0 ? g : f;
    }

    public Vector3i getBlockPosBelowThatAffectsMyMovement() {
        return this.position.down(0.1f).toVector3i();
    }

    public Vector3i getOnPos(float offset) {
        if (this.cachedOnPos == null) {
            Vector3i blockPos = null;
            float d = Float.MAX_VALUE;
            CuboidBlockIterator iterator = CuboidBlockIterator.iterator(this.boundingBox.expand(0.001f));
            while (iterator.step()) {
                float e;
                int x = iterator.getX();
                int y = iterator.getY();
                int z = iterator.getZ();
                Vector3i blockPos2 = Vector3i.from((int)x, (int)y, (int)z);
                if (this.compensatedWorld.getBlockState(x, y, z, 0).findCollision(this, Vector3i.from((int)x, (int)y, (int)z), null, false).isEmpty() || !((e = new Vec3(blockPos2).distToCenterSqr(this.position)) < d) && (e != d || blockPos != null && new Vec3(blockPos).compareTo(blockPos2) >= 0)) continue;
                blockPos = blockPos2;
                d = e;
            }
            this.cachedOnPos = blockPos != null ? blockPos : this.position.toVector3i();
        }
        return Vector3i.from((int)this.cachedOnPos.getX(), (int)GenericMath.floor((float)(this.position.y - offset)), (int)this.cachedOnPos.getZ());
    }

    public boolean isRegionUnloaded() {
        int l;
        Box lv = this.boundingBox.expand(1.0f);
        int i = GenericMath.floor((float)lv.minX);
        int j = GenericMath.ceil((float)lv.maxX);
        int k = GenericMath.floor((float)lv.minZ);
        return !this.compensatedWorld.hasChunksAt(i, k, j, l = GenericMath.ceil((float)lv.maxZ));
    }

    public boolean containsFluid(Box box) {
        int i = GenericMath.floor((float)box.minX);
        int j = GenericMath.ceil((float)box.maxX);
        int k = GenericMath.floor((float)box.minY);
        int l = GenericMath.ceil((float)box.maxY);
        int m = GenericMath.floor((float)box.minZ);
        int n = GenericMath.ceil((float)box.maxZ);
        Mutable lv = new Mutable();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    lv.set(o, p, q);
                    FluidState lv2 = this.compensatedWorld.getFluidState(lv);
                    if (lv2.fluid() == Fluid.EMPTY) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean doesNotCollide(float offsetX, float offsetY, float offsetZ) {
        return this.doesNotCollide(this.boundingBox.offset(offsetX, offsetY, offsetZ));
    }

    private boolean doesNotCollide(Box box) {
        return this.compensatedWorld.noCollision(box) && !this.containsFluid(box);
    }

    @Generated
    public GeyserSession getSession() {
        return this.session;
    }

    @Generated
    public BedrockServerSession getCloudburstDownstream() {
        return this.cloudburstDownstream;
    }

    @Generated
    public void setCloudburstDownstream(BedrockServerSession cloudburstDownstream) {
        this.cloudburstDownstream = cloudburstDownstream;
    }

    @Generated
    public TeleportUtil getTeleportUtil() {
        return this.teleportUtil;
    }

    @Generated
    public CheckHolder getCheckHolder() {
        return this.checkHolder;
    }

    @Generated
    public LatencyUtil getLatencyUtil() {
        return this.latencyUtil;
    }

    @Generated
    public ItemUseTracker getItemUseTracker() {
        return this.itemUseTracker;
    }

    @Generated
    public Map<UUID, CommandSource> getTrackedDebugPlayers() {
        return this.trackedDebugPlayers;
    }
}

