/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util.geyser;

import ac.boar.shaded.fastutil.ints.IntArrayList;
import ac.boar.shaded.fastutil.ints.IntList;
import lombok.Generated;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;

public class BlockStorage {
    public static final int SIZE = 4096;
    private final IntList palette;
    private BitArray bitArray;

    public BlockStorage(int airBlockId) {
        this(airBlockId, BitArrayVersion.V2);
    }

    public BlockStorage(int airBlockId, BitArrayVersion version) {
        this.bitArray = version.createArray(4096);
        this.palette = new IntArrayList(16);
        this.palette.add(airBlockId);
    }

    public BlockStorage(BitArray bitArray, IntList palette) {
        this.palette = palette;
        this.bitArray = bitArray;
    }

    public int getFullBlock(int index) {
        return this.palette.getInt(this.bitArray.get(index));
    }

    public void setFullBlock(int index, int runtimeId) {
        int idx = this.idFor(runtimeId);
        this.bitArray.set(index, idx);
    }

    private void onResize(BitArrayVersion version) {
        BitArray newBitArray = version.createArray(4096);
        for (int i = 0; i < 4096; ++i) {
            newBitArray.set(i, this.bitArray.get(i));
        }
        this.bitArray = newBitArray;
    }

    public int idFor(int runtimeId) {
        BitArrayVersion next;
        int index = this.palette.indexOf(runtimeId);
        if (index != -1) {
            return index;
        }
        index = this.palette.size();
        this.palette.add(runtimeId);
        BitArrayVersion version = this.bitArray.getVersion();
        if (index > version.getMaxEntryValue() && (next = version.next()) != null) {
            this.onResize(next);
        }
        return index;
    }

    @Generated
    public IntList getPalette() {
        return this.palette;
    }

    @Generated
    public BitArray getBitArray() {
        return this.bitArray;
    }
}

