/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util.math;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.Pair;
import ac.boar.anticheat.util.math.Box;
import ac.boar.anticheat.util.math.Vec3;
import org.cloudburstmc.protocol.bedrock.data.InputMode;

public class ReachUtil {
    public static float calculateReach(BoarPlayer player, Pair<Vec3, Vec3> pair, EntityCache entity) {
        float distance = Float.MAX_VALUE;
        float MAX_RANGE = MathUtil.square(Boar.getConfig().toleranceReach());
        float deltaTicks = 0.0f;
        while ((double)deltaTicks < 1.001) {
            Vec3 prevHitResult;
            Vec3 rotationVec = ReachUtil.getRotationVector(player, deltaTicks);
            Vec3 min = ReachUtil.getEyePosition(player, pair, deltaTicks);
            Vec3 max = min.add(rotationVec.multiply(7.0f));
            Vec3 hitResult = ReachUtil.calculateHitResult(entity.getCurrent().calculateBoundingBox(), min, max);
            if (hitResult != null) {
                distance = Math.min(distance, hitResult.squaredDistanceTo(min));
            }
            if (distance > MAX_RANGE && entity.getPast() != null && (prevHitResult = ReachUtil.calculateHitResult(entity.getPast().calculateBoundingBox(), min, max)) != null) {
                distance = Math.min(distance, prevHitResult.squaredDistanceTo(min));
            }
            if (distance <= MAX_RANGE) break;
            deltaTicks += 0.1f;
        }
        return distance == Float.MAX_VALUE ? distance : (float)Math.sqrt(distance);
    }

    private static Vec3 calculateHitResult(Box box, Vec3 min, Vec3 max) {
        Box lv5 = box.expand(0.1f);
        if (lv5.contains(min)) {
            return min;
        }
        return lv5.clip(min, max).orElse(null);
    }

    private static Vec3 getRotationVector(BoarPlayer player, float f) {
        return MathUtil.getRotationVector(player.inputMode == InputMode.TOUCH ? player.interactRotation.getX() : MathUtil.lerp(f, player.prevPitch, player.pitch), player.inputMode == InputMode.TOUCH ? player.interactRotation.getY() : MathUtil.lerp(f, player.prevYaw, player.yaw));
    }

    private static Vec3 getEyePosition(BoarPlayer player, Pair<Vec3, Vec3> pair, float f) {
        float d = MathUtil.lerp(f, pair.a().x, pair.b().x);
        float e = MathUtil.lerp(f, pair.a().y, pair.b().y) + player.dimensions.eyeHeight();
        float g = MathUtil.lerp(f, pair.a().z, pair.b().z);
        return new Vec3(d, e, g);
    }
}

