/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.debugger;

import ac.boar.shaded.classtransform.debugger.timings.TimedGroup;
import ac.boar.shaded.classtransform.debugger.timings.TimedTransformer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TransformerTimings {
    private final Map<TimedTransformer, Integer> timings = new LinkedHashMap<TimedTransformer, Integer>();
    private TimedGroup currentGroup;
    private String currentTransformer;
    private long currentStart;

    public Map<TimedTransformer, Integer> getTimings() {
        return Collections.unmodifiableMap(this.timings);
    }

    public void start(TimedGroup group, String transformer) {
        this.currentGroup = group;
        this.currentTransformer = transformer;
        this.currentStart = System.currentTimeMillis();
    }

    public void end() {
        long end = System.currentTimeMillis();
        this.timings.put(new TimedTransformer(this.currentGroup, this.currentTransformer), (int)(end - this.currentStart));
    }
}

