/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.transformer.impl.redirect;

import ac.boar.shaded.asm.Type;
import ac.boar.shaded.asm.tree.AbstractInsnNode;
import ac.boar.shaded.asm.tree.ClassNode;
import ac.boar.shaded.asm.tree.FieldInsnNode;
import ac.boar.shaded.asm.tree.InsnNode;
import ac.boar.shaded.asm.tree.MethodInsnNode;
import ac.boar.shaded.asm.tree.MethodNode;
import ac.boar.shaded.asm.tree.TypeInsnNode;
import ac.boar.shaded.asm.tree.VarInsnNode;
import ac.boar.shaded.classtransform.exceptions.TransformerException;
import ac.boar.shaded.classtransform.transformer.impl.redirect.IRedirectTarget;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import ac.boar.shaded.classtransform.utils.Codifier;
import ac.boar.shaded.classtransform.utils.Types;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CRedirectField
implements IRedirectTarget {
    @Override
    public void inject(ClassNode targetClass, MethodNode targetMethod, ClassNode transformer, MethodNode transformerMethod, AbstractInsnNode targetNode, List<MethodInsnNode> transformerMethodCalls) {
        if (targetNode.getOpcode() == 178 || targetNode.getOpcode() == 180) {
            this.redirectGetField(targetClass, targetMethod, transformer, transformerMethod, (FieldInsnNode)targetNode, transformerMethodCalls);
        } else if (targetNode.getOpcode() == 179 || targetNode.getOpcode() == 181) {
            this.redirectPutField(targetClass, targetMethod, transformer, transformerMethod, (FieldInsnNode)targetNode, transformerMethodCalls);
        }
    }

    private void redirectGetField(ClassNode targetClass, MethodNode targetMethod, ClassNode transformer, MethodNode transformerMethod, FieldInsnNode fieldInsnNode, List<MethodInsnNode> transformerMethodCalls) {
        Type returnType = Types.returnType(transformerMethod.desc);
        Type[] argumentTypes = Types.argumentTypes(transformerMethod.desc);
        Type originalType = Types.type(fieldInsnNode.desc);
        Type originalOwnerType = Types.type(fieldInsnNode.owner);
        if (!ASMUtils.compareType(originalType, returnType)) {
            throw new TransformerException(transformerMethod, transformer, "does not have same return type as field").help(Codifier.of(transformerMethod).returnType(originalType));
        }
        if (fieldInsnNode.getOpcode() != 178) {
            if (!ASMUtils.compareTypes(new Type[]{originalOwnerType}, argumentTypes)) {
                throw new TransformerException(transformerMethod, transformer, "does not have first argument type as field owner").help(Codifier.of(transformerMethod).param(null).param(originalOwnerType));
            }
        } else if (argumentTypes.length != 0) {
            throw new TransformerException(transformerMethod, transformer, "does not have no arguments").help(Codifier.of(transformerMethod).param(null));
        }
        if (!Modifier.isStatic(transformerMethod.access)) {
            targetMethod.instructions.insertBefore((AbstractInsnNode)fieldInsnNode, new VarInsnNode(25, 0));
        }
        if (fieldInsnNode.getOpcode() != 178 && !Modifier.isStatic(transformerMethod.access)) {
            targetMethod.instructions.insertBefore((AbstractInsnNode)fieldInsnNode, new InsnNode(95));
        }
        if (!originalType.equals(returnType)) {
            targetMethod.instructions.insert((AbstractInsnNode)fieldInsnNode, new TypeInsnNode(192, originalType.getInternalName()));
        }
        this.callTransformerMethod(targetClass, targetMethod, transformerMethod, fieldInsnNode, transformerMethodCalls);
    }

    private void redirectPutField(ClassNode targetClass, MethodNode targetMethod, ClassNode transformer, MethodNode transformerMethod, FieldInsnNode fieldInsnNode, List<MethodInsnNode> transformerMethodCalls) {
        Type returnType = Types.returnType(transformerMethod.desc);
        Type[] argumentTypes = Types.argumentTypes(transformerMethod.desc);
        Type originalType = Types.type(fieldInsnNode.desc);
        Type originalOwnerType = Types.type(fieldInsnNode.owner);
        if (!returnType.equals(Type.VOID_TYPE)) {
            throw new TransformerException(transformerMethod, transformer, "must be a void method").help(Codifier.of(transformerMethod).returnType(Type.VOID_TYPE));
        }
        if (fieldInsnNode.getOpcode() != 179) {
            if (!ASMUtils.compareTypes(new Type[]{originalOwnerType, originalType}, argumentTypes)) {
                throw new TransformerException(transformerMethod, transformer, "does not have owner and value as arguments").help(Codifier.of(transformerMethod).param(null).params(originalOwnerType, originalType));
            }
        } else if (!ASMUtils.compareTypes(new Type[]{originalType}, argumentTypes)) {
            throw new TransformerException(transformerMethod, transformer, "does not have value as argument").help(Codifier.of(transformerMethod).param(null).param(originalType));
        }
        int ownerStore = ASMUtils.getFreeVarIndex(targetMethod);
        int valueStore = ownerStore + 1;
        if (fieldInsnNode.getOpcode() == 181) {
            targetMethod.instructions.insertBefore((AbstractInsnNode)fieldInsnNode, new VarInsnNode(ASMUtils.getStoreOpcode(originalType), valueStore));
            targetMethod.instructions.insertBefore((AbstractInsnNode)fieldInsnNode, new VarInsnNode(ASMUtils.getStoreOpcode(originalOwnerType), ownerStore));
        } else {
            targetMethod.instructions.insertBefore((AbstractInsnNode)fieldInsnNode, new VarInsnNode(ASMUtils.getStoreOpcode(originalType), valueStore));
        }
        if (!Modifier.isStatic(transformerMethod.access)) {
            targetMethod.instructions.insertBefore((AbstractInsnNode)fieldInsnNode, new VarInsnNode(25, 0));
        }
        if (fieldInsnNode.getOpcode() == 181) {
            targetMethod.instructions.insertBefore((AbstractInsnNode)fieldInsnNode, new VarInsnNode(ASMUtils.getLoadOpcode(originalOwnerType), ownerStore));
        }
        targetMethod.instructions.insertBefore((AbstractInsnNode)fieldInsnNode, new VarInsnNode(ASMUtils.getLoadOpcode(originalType), valueStore));
        this.callTransformerMethod(targetClass, targetMethod, transformerMethod, fieldInsnNode, transformerMethodCalls);
    }

    private void callTransformerMethod(ClassNode targetClass, MethodNode targetMethod, MethodNode transformerMethod, FieldInsnNode fieldInsnNode, List<MethodInsnNode> transformerMethodCalls) {
        MethodInsnNode transformerCall = Modifier.isStatic(transformerMethod.access) ? new MethodInsnNode(184, targetClass.name, transformerMethod.name, transformerMethod.desc, Modifier.isInterface(targetClass.access)) : new MethodInsnNode(Modifier.isInterface(targetClass.access) ? 185 : 182, targetClass.name, transformerMethod.name, transformerMethod.desc);
        targetMethod.instructions.set(fieldInsnNode, transformerCall);
        transformerMethodCalls.add(transformerCall);
    }
}

