/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.transformer.types;

import ac.boar.shaded.asm.tree.ClassNode;
import ac.boar.shaded.asm.tree.MethodNode;
import ac.boar.shaded.classtransform.TransformerManager;
import ac.boar.shaded.classtransform.transformer.AnnotationHandler;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class RemovingAnnotationHandler<T extends Annotation>
extends AnnotationHandler {
    private final Class<? extends Annotation> annotationClass;

    public RemovingAnnotationHandler(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    @Override
    public final void transform(TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer) {
        Iterator<MethodNode> it = transformer.methods.iterator();
        while (it.hasNext()) {
            MethodNode transformerMethod = it.next();
            Annotation annotation = this.getAnnotation(this.annotationClass, transformerMethod, transformerManager);
            if (annotation == null || !this.shouldExecute(annotation)) continue;
            it.remove();
            this.transform(annotation, transformerManager, transformedClass, transformer, ASMUtils.cloneMethod(transformerMethod));
        }
    }

    public abstract void transform(T var1, TransformerManager var2, ClassNode var3, ClassNode var4, MethodNode var5);

    public boolean shouldExecute(T annotation) {
        return true;
    }
}

