/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.utils;

import ac.boar.shaded.asm.tree.FieldInsnNode;
import ac.boar.shaded.asm.tree.MethodInsnNode;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MemberDeclaration {
    private final String owner;
    private final String name;
    private final String desc;

    public MemberDeclaration(String owner, String name, String desc) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String toString() {
        return "L" + this.owner + ";" + this.name + (this.desc.startsWith("(") ? this.desc : ":" + this.desc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberDeclaration that = (MemberDeclaration)o;
        return Objects.equals(this.owner, that.owner) && Objects.equals(this.name, that.name) && Objects.equals(this.desc, that.desc);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.name, this.desc);
    }

    public boolean is(FieldInsnNode fieldInsnNode) {
        return this.owner.equals(fieldInsnNode.owner) && this.name.equals(fieldInsnNode.name) && this.desc.equals(fieldInsnNode.desc);
    }

    public boolean is(MethodInsnNode methodInsnNode) {
        return this.owner.equals(methodInsnNode.owner) && this.name.equals(methodInsnNode.name) && this.desc.equals(methodInsnNode.desc);
    }

    public boolean is(String owner, String name, String desc) {
        return this.owner.equals(owner) && this.name.equals(name) && this.desc.equals(desc);
    }

    public boolean isFieldMapping() {
        return !this.desc.startsWith("(");
    }

    public boolean isMethodMapping() {
        return this.desc.startsWith("(");
    }
}

