/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.jackson.databind.deser.impl;

import ac.boar.shaded.jackson.databind.BeanProperty;
import ac.boar.shaded.jackson.databind.DeserializationContext;
import ac.boar.shaded.jackson.databind.JavaType;
import ac.boar.shaded.jackson.databind.JsonMappingException;
import ac.boar.shaded.jackson.databind.PropertyName;
import ac.boar.shaded.jackson.databind.deser.NullValueProvider;
import ac.boar.shaded.jackson.databind.exc.InvalidNullException;
import ac.boar.shaded.jackson.databind.util.AccessPattern;
import java.io.Serializable;

public class NullsFailProvider
implements NullValueProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final PropertyName _name;
    protected final JavaType _type;

    protected NullsFailProvider(PropertyName name, JavaType type) {
        this._name = name;
        this._type = type;
    }

    public static NullsFailProvider constructForProperty(BeanProperty prop) {
        return NullsFailProvider.constructForProperty(prop, prop.getType());
    }

    public static NullsFailProvider constructForProperty(BeanProperty prop, JavaType type) {
        return new NullsFailProvider(prop.getFullName(), type);
    }

    public static NullsFailProvider constructForRootValue(JavaType t) {
        return new NullsFailProvider(null, t);
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        throw InvalidNullException.from(ctxt, this._name, this._type);
    }
}

