/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.jackson.databind.ser.std;

import ac.boar.shaded.jackson.core.JsonGenerator;
import ac.boar.shaded.jackson.core.JsonToken;
import ac.boar.shaded.jackson.core.type.WritableTypeId;
import ac.boar.shaded.jackson.databind.JavaType;
import ac.boar.shaded.jackson.databind.JsonMappingException;
import ac.boar.shaded.jackson.databind.JsonNode;
import ac.boar.shaded.jackson.databind.SerializerProvider;
import ac.boar.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ac.boar.shaded.jackson.databind.jsontype.TypeSerializer;
import ac.boar.shaded.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

