/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.jackson.databind.ser.std;

import ac.boar.shaded.jackson.core.JsonGenerator;
import ac.boar.shaded.jackson.core.JsonToken;
import ac.boar.shaded.jackson.core.type.WritableTypeId;
import ac.boar.shaded.jackson.databind.JavaType;
import ac.boar.shaded.jackson.databind.JsonMappingException;
import ac.boar.shaded.jackson.databind.JsonNode;
import ac.boar.shaded.jackson.databind.SerializerProvider;
import ac.boar.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ac.boar.shaded.jackson.databind.jsontype.TypeSerializer;
import ac.boar.shaded.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public abstract class ToStringSerializerBase
extends StdSerializer<Object> {
    public ToStringSerializerBase(Class<?> handledType) {
        super(handledType, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        return this.valueToString(value).isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this.valueToString(value));
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }

    public abstract String valueToString(Object var1);
}

