/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.validator;

import ac.boar.anticheat.compensated.CompensatedInventory;
import ac.boar.anticheat.data.InteractionResult;
import ac.boar.anticheat.data.block.BoarBlockState;
import ac.boar.anticheat.data.inventory.ItemCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.StringUtil;
import ac.boar.anticheat.validator.click.ItemRequestProcessor;
import ac.boar.mappings.BedrockMappings;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventoryActionData;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventorySource;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.ItemUseTransaction;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.LegacySetItemSlotData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventoryTransactionPacket;
import org.cloudburstmc.protocol.bedrock.packet.ItemStackRequestPacket;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.property.Property;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.TagCache;
import org.geysermc.geyser.session.cache.tags.BlockTag;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.translator.protocol.bedrock.BedrockInventoryTransactionTranslator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public final class ItemTransactionValidator {
    private final BoarPlayer player;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handle(InventoryTransactionPacket packet) {
        CompensatedInventory inventory = this.player.compensatedInventory;
        block0 : switch (packet.getTransactionType()) {
            case NORMAL: {
                if (packet.getActions().size() != 2) {
                    return false;
                }
                InventoryActionData world = (InventoryActionData)packet.getActions().get(0);
                InventoryActionData container = (InventoryActionData)packet.getActions().get(1);
                if (world.getSource().getType() != InventorySource.Type.WORLD_INTERACTION || world.getSource().getFlag() != InventorySource.Flag.DROP_ITEM) {
                    return false;
                }
                int slot = container.getSlot();
                if (slot < 0 || slot > 8) {
                    return false;
                }
                ItemData slotData = inventory.inventoryContainer.getItemFromSlot(slot).getData();
                ItemData claimedData = world.getToItem();
                int dropCounts = claimedData.getCount();
                if (dropCounts < 1 || dropCounts > slotData.getCount() || !ItemTransactionValidator.validate(slotData, claimedData)) {
                    return false;
                }
                if (dropCounts > 1 && dropCounts < slotData.getCount()) {
                    InventorySlotPacket slotPacket = new InventorySlotPacket();
                    slotPacket.setItem(ItemData.AIR);
                    slotPacket.setContainerId(0);
                    slotPacket.setSlot(slot);
                    this.player.cloudburstUpstream.sendPacket((BedrockPacket)slotPacket);
                }
                if (dropCounts == slotData.getCount()) {
                    inventory.inventoryContainer.set(slot, ItemData.AIR);
                    return true;
                }
                ItemData.Builder builder = slotData.toBuilder();
                builder.count(Math.max(0, slotData.getCount() - dropCounts));
                inventory.inventoryContainer.set(slot, builder.build());
                return true;
            }
            case ITEM_RELEASE: {
                if (packet.getActionType() != 0) return true;
                if (this.player.compensatedInventory.inventoryContainer.getHeldItem().getJavaId() == Items.TRIDENT.javaId()) {
                    this.player.setDirtyRiptide(this.player.sinceTridentUse, this.player.compensatedInventory.inventoryContainer.getHeldItemData());
                }
                this.player.getItemUseTracker().release();
                return true;
            }
            case ITEM_USE: {
                Vector3i position = packet.getBlockPosition();
                int slot = packet.getHotbarSlot();
                if (slot < 0 || slot > 8) {
                    return false;
                }
                ItemData SD1 = inventory.inventoryContainer.getHeldItemData();
                boolean noActions = packet.getActions().isEmpty();
                if (!noActions) {
                    for (InventoryActionData action : packet.getActions()) {
                        if (action.getSlot() < 0 || action.getSlot() > 8) {
                            return false;
                        }
                        ItemData SD2 = inventory.inventoryContainer.getItemFromSlot(action.getSlot()).getData();
                        if (ItemTransactionValidator.validate(SD2, action.getFromItem())) continue;
                        return false;
                    }
                }
                if (noActions && !ItemTransactionValidator.validate(SD1, packet.getItemInHand())) {
                    return false;
                }
                float distance = this.player.position.toVector3f().distanceSquared((float)position.getX(), (float)position.getY(), (float)position.getZ());
                if (!MathUtil.isValid(position) || distance > 144.0f && position.getX() + position.getY() + position.getZ() != 0) {
                    return false;
                }
                BoarBlockState boarState = this.player.compensatedWorld.getBlockState(position, 0);
                BlockState state = boarState.getState();
                Block block = state.block();
                switch (packet.getActionType()) {
                    case 0: {
                        boolean doingSecondaryAction;
                        if (packet.getItemInHand() == null || !ItemTransactionValidator.validate(SD1, packet.getItemInHand())) {
                            return true;
                        }
                        if (packet.getClientInteractPrediction() == ItemUseTransaction.PredictedResult.FAILURE) {
                            return true;
                        }
                        if (packet.getBlockPosition() == null) {
                            return false;
                        }
                        int blockFace = packet.getBlockFace();
                        if (blockFace < 0 || blockFace > 5) {
                            return false;
                        }
                        ItemCache heldItem = inventory.inventoryContainer.getHeldItemCache();
                        GeyserItemStack geyserItemStack = GeyserItemStack.from((ItemStack)inventory.translate(heldItem.getData()));
                        Item item = geyserItemStack.asItem();
                        boolean heldItemExist = !heldItem.isEmpty();
                        boolean bl = doingSecondaryAction = this.player.getInputData().contains(PlayerAuthInputData.SNEAKING) && heldItemExist;
                        if (!doingSecondaryAction) {
                            InteractionResult result = InteractionResult.TRY_WITH_EMPTY_HAND;
                            int itemJavaId = item.javaId();
                            if (state.is(Blocks.CAULDRON) && (itemJavaId == Items.WATER_BUCKET.javaId() || itemJavaId == Items.LAVA_BUCKET.javaId() || itemJavaId == Items.POWDER_SNOW_BUCKET.javaId())) {
                                result = InteractionResult.SUCCESS;
                            }
                            TagCache tagCache = this.player.getSession().getTagCache();
                            if (state.is(Blocks.CAKE) && (tagCache.is(ItemTag.CANDLES, (Object)item) || (Integer)state.getValue((Property)Properties.BITES) == 0)) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (tagCache.is(BlockTag.CANDLES, (Object)block) && geyserItemStack.isEmpty() && ((Boolean)state.getValue((Property)Properties.LIT)).booleanValue()) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (state.is(Blocks.CHISELED_BOOKSHELF)) {
                                // empty if block
                            }
                            if (state.is(Blocks.LECTERN) && !((Boolean)state.getValue((Property)Properties.HAS_BOOK)).booleanValue() && geyserItemStack.isEmpty()) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (state.is(Blocks.NOTE_BLOCK) && tagCache.is(ItemTag.NOTEBLOCK_TOP_INSTRUMENTS, (Object)item) && blockFace == Direction.UP.ordinal()) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (state.is(Blocks.PUMPKIN) || state.is(Blocks.REDSTONE_ORE)) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (state.is(Blocks.RESPAWN_ANCHOR) && itemJavaId == Items.GLOWSTONE.javaId() && (Integer)state.getValue((Property)Properties.RESPAWN_ANCHOR_CHARGES) < 4) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (tagCache.is(BlockTag.ALL_SIGNS, (Object)block)) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (state.is(Blocks.SWEET_BERRY_BUSH) && (Integer)state.getValue((Property)Properties.AGE_3) != 3 && itemJavaId == Items.BONE_MEAL.javaId()) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (state.is(Blocks.TNT) && (itemJavaId == Items.FLINT_AND_STEEL.javaId() || itemJavaId == Items.FIRE_CHARGE.javaId())) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (state.is(Blocks.VAULT) && (geyserItemStack.isEmpty() || !((String)((Object)state.getValue((Property)Properties.VAULT_STATE))).equals("active"))) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (result != InteractionResult.TRY_WITH_EMPTY_HAND) {
                                return true;
                            }
                            if (state.is(Blocks.FURNACE) || state.is(Blocks.BLAST_FURNACE) || state.is(Blocks.ANVIL) || state.is(Blocks.CHIPPED_ANVIL) || state.is(Blocks.DAMAGED_ANVIL) || state.is(Blocks.BARREL) || state.is(Blocks.BEACON) || tagCache.is(BlockTag.BEDS, (Object)block) || state.is(Blocks.BREWING_STAND) || tagCache.is(BlockTag.BUTTONS, (Object)block) || state.is(Blocks.LEVER)) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (state.is(Blocks.BELL) && packet.getClickPosition() != null && ItemTransactionValidator.isProperHit(state, Direction.values()[blockFace], packet.getClickPosition().getY() - (float)packet.getBlockPosition().getY())) {
                                result = InteractionResult.SUCCESS;
                            }
                            if (state.getValue((Property)Properties.OPEN) != null) {
                                this.player.compensatedWorld.updateBlock(position, 0, this.player.getSession().getBlockMappings().getBedrockBlockId(state.withValue((Property)Properties.OPEN, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)Properties.OPEN) == false)).javaId()));
                                result = InteractionResult.SUCCESS;
                            }
                            if (result != InteractionResult.TRY_WITH_EMPTY_HAND) {
                                return true;
                            }
                        }
                        Vector3i newBlockPos = BlockUtils.getBlockPosition((Vector3i)packet.getBlockPosition(), (int)packet.getBlockFace());
                        if ((state.is(Blocks.SCAFFOLDING) || this.player.compensatedWorld.getBlockState(newBlockPos, 0).getState().is(Blocks.SCAFFOLDING)) && item.javaId() == Items.SCAFFOLDING.javaId()) {
                            return true;
                        }
                        if (boarState.isAir()) {
                            BedrockInventoryTransactionTranslator.restoreCorrectBlock((GeyserSession)this.player.getSession(), (Vector3i)newBlockPos);
                            BedrockInventoryTransactionTranslator.restoreCorrectBlock((GeyserSession)this.player.getSession(), (Vector3i)packet.getBlockPosition());
                            this.player.tickSinceBlockResync = 5;
                            return false;
                        }
                        if (item.javaId() == Items.WATER_BUCKET.javaId()) {
                            this.player.compensatedWorld.updateBlock(newBlockPos, 0, this.player.getSession().getBlockMappings().getBedrockWater().getRuntimeId());
                            GeyserItemStack stack = GeyserItemStack.of((int)Items.BUCKET.javaId(), (int)1);
                            inventory.inventoryContainer.set(inventory.heldItemSlot, inventory.translate(stack.getItemStack()));
                        } else if (item.javaId() == Items.LAVA_BUCKET.javaId()) {
                            this.player.compensatedWorld.updateBlock(newBlockPos, 0, this.player.getSession().getBlockMappings().getBedrockBlockId(Blocks.LAVA.defaultBlockState().javaId()));
                            GeyserItemStack stack = GeyserItemStack.of((int)Items.BUCKET.javaId(), (int)1);
                            inventory.inventoryContainer.set(inventory.heldItemSlot, inventory.translate(stack.getItemStack()));
                        } else if (item.javaId() == Items.POWDER_SNOW_BUCKET.javaId()) {
                            this.player.compensatedWorld.updateBlock(newBlockPos, 0, this.player.getSession().getBlockMappings().getBedrockBlockId(Blocks.POWDER_SNOW.defaultBlockState().javaId()));
                            GeyserItemStack stack = GeyserItemStack.of((int)Items.BUCKET.javaId(), (int)1);
                            inventory.inventoryContainer.set(inventory.heldItemSlot, inventory.translate(stack.getItemStack()));
                        } else if (item.javaId() == Items.BUCKET.javaId()) {
                            int javaId = -1;
                            int layer = 0;
                            if (state.is(Blocks.WATER)) {
                                javaId = Items.WATER_BUCKET.javaId();
                            } else if (this.player.compensatedWorld.getBlockState(position, 1).getState().is(Blocks.WATER)) {
                                layer = 1;
                                javaId = Items.WATER_BUCKET.javaId();
                            } else if (state.is(Blocks.LAVA)) {
                                javaId = Items.LAVA_BUCKET.javaId();
                            } else if (state.is(Blocks.POWDER_SNOW)) {
                                javaId = Items.POWDER_SNOW_BUCKET.javaId();
                            }
                            if (javaId == -1) {
                                return true;
                            }
                            this.player.compensatedWorld.updateBlock(newBlockPos, layer, this.player.getSession().getBlockMappings().getBedrockAir().getRuntimeId());
                            GeyserItemStack stack = GeyserItemStack.of((int)javaId, (int)1);
                            inventory.inventoryContainer.set(inventory.heldItemSlot, inventory.translate(stack.getItemStack()));
                        }
                        if (!(item instanceof BlockItem)) return true;
                        BlockItem blockItem = (BlockItem)item;
                        Block mappedBlock = BedrockMappings.getItemToBlock().getOrDefault(blockItem, Blocks.AIR);
                        if (mappedBlock.javaId() != Blocks.AIR.javaId()) {
                            this.player.compensatedWorld.updateBlock(newBlockPos, 0, this.player.getSession().getBlockMappings().getBedrockBlockId(mappedBlock.javaId()));
                        }
                        if (this.player.gameType == GameType.CREATIVE) return true;
                        heldItem.count(heldItem.count() - 1);
                        if (heldItem.count() > 0) return true;
                        inventory.inventoryContainer.set(inventory.heldItemSlot, ItemCache.AIR);
                        break block0;
                    }
                    case 1: {
                        byte actualSlot;
                        LegacySetItemSlotData slotData;
                        if (packet.getItemInHand() == null || !ItemTransactionValidator.validate(SD1, packet.getItemInHand())) {
                            return true;
                        }
                        ItemStack item = this.player.compensatedInventory.translate(SD1);
                        if (item.getId() == Items.FIREWORK_ROCKET.javaId() && this.player.getFlagTracker().has(EntityFlag.GLIDING)) {
                            this.player.glideBoostTicks = 20;
                        }
                        this.player.getItemUseTracker().use(SD1, item.getId());
                        List legacySlots = packet.getLegacySlots();
                        if (packet.getActions().size() != 1 || legacySlots.isEmpty() || packet.getHotbarSlot() != inventory.heldItemSlot || (slotData = (LegacySetItemSlotData)legacySlots.get(0)).getSlots().length == 0 || (actualSlot = slotData.getSlots()[0]) < 0 || actualSlot >= inventory.armorContainer.getContainerSize() || slotData.getContainerId() != 6) return true;
                        ItemData oldHotbar = inventory.inventoryContainer.getHeldItemData();
                        inventory.inventoryContainer.set(packet.getHotbarSlot(), inventory.armorContainer.get(actualSlot));
                        inventory.armorContainer.set((int)actualSlot, oldHotbar);
                    }
                }
            }
        }
        return true;
    }

    public void handle(ItemStackRequestPacket packet) {
        CompensatedInventory inventory = this.player.compensatedInventory;
        if (inventory.openContainer == null) {
            return;
        }
        this.player.doingInventoryAction = true;
        ArrayList clone = new ArrayList(packet.getRequests());
        packet.getRequests().clear();
        ItemRequestProcessor processor = new ItemRequestProcessor(this.player);
        for (ItemStackRequest request : clone) {
            if (request.getActions().length == 0) {
                packet.getRequests().add(request);
                continue;
            }
            if (!processor.processAll(request)) {
                return;
            }
            packet.getRequests().add(request);
        }
    }

    public static boolean validate(ItemData predicted, ItemData claimed) {
        SimpleItemDefinition SID1;
        ItemDefinition ID2;
        ItemDefinition ID1;
        block7: {
            block6: {
                if (predicted == null) {
                    return true;
                }
                if (claimed == null) {
                    return false;
                }
                ID1 = predicted.getDefinition();
                ID2 = claimed.getDefinition();
                if (!(ID1 instanceof SimpleItemDefinition)) break block6;
                SID1 = (SimpleItemDefinition)ID1;
                if (ID2 instanceof SimpleItemDefinition) break block7;
            }
            return true;
        }
        SimpleItemDefinition SID2 = (SimpleItemDefinition)ID2;
        if (!StringUtil.sanitizePrefix(SID1.getIdentifier()).equalsIgnoreCase(StringUtil.sanitizePrefix(SID2.getIdentifier()))) {
            return false;
        }
        return ID1.getRuntimeId() == ID2.getRuntimeId();
    }

    public static boolean validate(ItemDefinition predicted, ItemDefinition claimed) {
        if (predicted == null) {
            return true;
        }
        if (claimed == null) {
            return false;
        }
        if (!StringUtil.sanitizePrefix(predicted.getIdentifier()).equalsIgnoreCase(StringUtil.sanitizePrefix(claimed.getIdentifier()))) {
            return false;
        }
        return predicted.getRuntimeId() == claimed.getRuntimeId();
    }

    private static boolean isProperHit(BlockState blockState, Direction direction, float d) {
        String bellAttachType;
        if (direction.getAxis() == Axis.Y || d > 0.8124f) {
            return false;
        }
        Direction direction2 = (Direction)blockState.getValue((Property)Properties.HORIZONTAL_FACING);
        return switch (bellAttachType = (String)((Object)blockState.getValue((Property)Properties.BELL_ATTACHMENT))) {
            case "floor" -> {
                if (direction2.getAxis() == direction.getAxis()) {
                    yield true;
                }
                yield false;
            }
            case "single_wall", "double_wall" -> {
                if (direction2.getAxis() != direction.getAxis()) {
                    yield true;
                }
                yield false;
            }
            case "ceiling" -> true;
            default -> false;
        };
    }

    @Generated
    public ItemTransactionValidator(BoarPlayer player) {
        this.player = player;
    }
}

