/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util.math;

import ac.boar.anticheat.util.math.Vec3;
import java.util.Optional;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.Direction;
import org.jetbrains.annotations.Nullable;

public class Box
implements Cloneable {
    public static final Box EMPTY = new Box(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final float EPSILON = 1.0E-7f;
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;

    public Box(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    public Box(BoundingBox boundingBox) {
        this.minX = (float)boundingBox.getMin(Axis.X);
        this.minY = (float)boundingBox.getMin(Axis.Y);
        this.minZ = (float)boundingBox.getMin(Axis.Z);
        this.maxX = (float)boundingBox.getMax(Axis.X);
        this.maxY = (float)boundingBox.getMax(Axis.Y);
        this.maxZ = (float)boundingBox.getMax(Axis.Z);
    }

    public Vec3 toVec3f(float width) {
        return new Vec3(this.minX + width / 2.0f, this.minY, this.maxZ - width / 2.0f);
    }

    public static Box of(Vec3 center, float dx, float dy, float dz) {
        return new Box(center.x - dx / 2.0f, center.y - dy / 2.0f, center.z - dz / 2.0f, center.x + dx / 2.0f, center.y + dy / 2.0f, center.z + dz / 2.0f);
    }

    public boolean equals(Box box) {
        return this.minX == box.minX && this.minY == box.minY && this.minZ == box.minZ && this.maxX == box.maxX && this.maxY == box.maxY && this.maxZ == box.maxZ;
    }

    public float chooseMin(Axis axis) {
        return switch (axis) {
            case Axis.X -> this.minX;
            case Axis.Y -> this.minY;
            default -> this.minZ;
        };
    }

    public float chooseMax(Axis axis) {
        return switch (axis) {
            case Axis.X -> this.maxX;
            case Axis.Y -> this.maxY;
            default -> this.maxZ;
        };
    }

    public boolean isOverlapped(Axis axis, Box other) {
        return switch (axis) {
            case Axis.X -> {
                if (other.maxY - this.minY > 0.0f && this.maxY - other.minY > 0.0f && other.maxZ - this.minZ > 0.0f && this.maxZ - other.minZ > 0.0f) {
                    yield true;
                }
                yield false;
            }
            case Axis.Y -> {
                if (other.maxX - this.minX > 0.0f && this.maxX - other.minX > 0.0f && other.maxZ - this.minZ > 0.0f && this.maxZ - other.minZ > 0.0f) {
                    yield true;
                }
                yield false;
            }
            default -> other.maxX - this.minX > 0.0f && this.maxX - other.minX > 0.0f && other.maxY - this.minY > 0.0f && this.maxY - other.minY > 0.0f;
        };
    }

    public float calculateMaxDistance(Axis axis, Box other, float maxDist) {
        if (!this.isOverlapped(axis, other) || maxDist == 0.0f) {
            return maxDist;
        }
        if (maxDist > 0.0f) {
            float d1 = this.chooseMin(axis) - other.chooseMax(axis);
            if ((double)d1 >= -0.001) {
                maxDist = Math.min(maxDist, d1);
            }
        } else {
            float d0 = this.chooseMax(axis) - other.chooseMin(axis);
            if ((double)d0 <= 0.001) {
                maxDist = Math.max(maxDist, d0);
            }
        }
        return maxDist;
    }

    public Optional<Vec3> clip(Vec3 from, Vec3 to) {
        return Box.clip(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, from, to);
    }

    public static Optional<Vec3> clip(float d, float e, float f, float g, float h, float i, Vec3 vec3, Vec3 vec32) {
        float[] ds = new float[]{1.0f};
        float j = vec32.x - vec3.x;
        float k = vec32.y - vec3.y;
        float l = vec32.z - vec3.z;
        Direction direction = Box.getDirection(d, e, f, g, h, i, vec3, ds, null, j, k, l);
        if (direction == null) {
            return Optional.empty();
        }
        float m = ds[0];
        return Optional.of(vec3.add(m * j, m * k, m * l));
    }

    @Nullable
    private static Direction getDirection(Box aABB, Vec3 vec3, float[] ds, @Nullable Direction direction, float d, float e, float f) {
        return Box.getDirection(aABB.minX, aABB.minY, aABB.minZ, aABB.maxX, aABB.maxY, aABB.maxZ, vec3, ds, direction, d, e, f);
    }

    @Nullable
    private static Direction getDirection(float d, float e, float f, float g, float h, float i, Vec3 vec3, float[] ds, @Nullable Direction direction, float j, float k, float l) {
        if ((double)j > 1.0E-7) {
            direction = Box.clipPoint(ds, direction, j, k, l, d, e, h, f, i, Direction.WEST, vec3.x, vec3.y, vec3.z);
        } else if ((double)j < -1.0E-7) {
            direction = Box.clipPoint(ds, direction, j, k, l, g, e, h, f, i, Direction.EAST, vec3.x, vec3.y, vec3.z);
        }
        if ((double)k > 1.0E-7) {
            direction = Box.clipPoint(ds, direction, k, l, j, e, f, i, d, g, Direction.DOWN, vec3.y, vec3.z, vec3.x);
        } else if ((double)k < -1.0E-7) {
            direction = Box.clipPoint(ds, direction, k, l, j, h, f, i, d, g, Direction.UP, vec3.y, vec3.z, vec3.x);
        }
        if ((double)l > 1.0E-7) {
            direction = Box.clipPoint(ds, direction, l, j, k, f, d, g, e, h, Direction.NORTH, vec3.z, vec3.x, vec3.y);
        } else if ((double)l < -1.0E-7) {
            direction = Box.clipPoint(ds, direction, l, j, k, i, d, g, e, h, Direction.SOUTH, vec3.z, vec3.x, vec3.y);
        }
        return direction;
    }

    private static Direction clipPoint(float[] ds, @Nullable Direction direction, float d, float e, float f, float g, float h, float i, float j, float k, Direction direction2, float l, float m, float n) {
        float o = (g - l) / d;
        float p = m + o * e;
        float q = n + o * f;
        if (0.0f < o && o < ds[0] && (double)h - 1.0E-7 < (double)p && (double)p < (double)i + 1.0E-7 && (double)j - 1.0E-7 < (double)q && (double)q < (double)k + 1.0E-7) {
            ds[0] = o;
            return direction2;
        }
        return direction;
    }

    public Box withMinX(float minX) {
        return new Box(minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public Box withMinY(float minY) {
        return new Box(this.minX, minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public Box withMinZ(float minZ) {
        return new Box(this.minX, this.minY, minZ, this.maxX, this.maxY, this.maxZ);
    }

    public Box withMaxX(float maxX) {
        return new Box(this.minX, this.minY, this.minZ, maxX, this.maxY, this.maxZ);
    }

    public Box withMaxY(float maxY) {
        return new Box(this.minX, this.minY, this.minZ, this.maxX, maxY, this.maxZ);
    }

    public Box withMaxZ(float maxZ) {
        return new Box(this.minX, this.minY, this.minZ, this.maxX, this.maxY, maxZ);
    }

    public Box shrink(float x, float y, float z) {
        float d = this.minX;
        float e = this.minY;
        float f = this.minZ;
        float g = this.maxX;
        float h = this.maxY;
        float i = this.maxZ;
        if ((double)x < 0.0) {
            d -= x;
        } else if ((double)x > 0.0) {
            g -= x;
        }
        if ((double)y < 0.0) {
            e -= y;
        } else if ((double)y > 0.0) {
            h -= y;
        }
        if ((double)z < 0.0) {
            f -= z;
        } else if ((double)z > 0.0) {
            i -= z;
        }
        return new Box(d, e, f, g, h, i);
    }

    public Box stretch(Vec3 scale) {
        return this.stretch(scale.x, scale.y, scale.z);
    }

    public Box stretch(float x, float y, float z) {
        float d = this.minX;
        float e = this.minY;
        float f = this.minZ;
        float g = this.maxX;
        float h = this.maxY;
        float i = this.maxZ;
        if ((double)x < 0.0) {
            d += x;
        } else if ((double)x > 0.0) {
            g += x;
        }
        if ((double)y < 0.0) {
            e += y;
        } else if ((double)y > 0.0) {
            h += y;
        }
        if ((double)z < 0.0) {
            f += z;
        } else if ((double)z > 0.0) {
            i += z;
        }
        return new Box(d, e, f, g, h, i);
    }

    public Box expand(float x, float y, float z) {
        float d = this.minX - x;
        float e = this.minY - y;
        float f = this.minZ - z;
        float g = this.maxX + x;
        float h = this.maxY + y;
        float i = this.maxZ + z;
        return new Box(d, e, f, g, h, i);
    }

    public Box expand(float value) {
        return this.expand(value, value, value);
    }

    public Box intersection(Box Box2) {
        float d = Math.max(this.minX, Box2.minX);
        float e = Math.max(this.minY, Box2.minY);
        float f = Math.max(this.minZ, Box2.minZ);
        float g = Math.min(this.maxX, Box2.maxX);
        float h = Math.min(this.maxY, Box2.maxY);
        float i = Math.min(this.maxZ, Box2.maxZ);
        return new Box(d, e, f, g, h, i);
    }

    public Box union(Box Box2) {
        float d = Math.min(this.minX, Box2.minX);
        float e = Math.min(this.minY, Box2.minY);
        float f = Math.min(this.minZ, Box2.minZ);
        float g = Math.max(this.maxX, Box2.maxX);
        float h = Math.max(this.maxY, Box2.maxY);
        float i = Math.max(this.maxZ, Box2.maxZ);
        return new Box(d, e, f, g, h, i);
    }

    public Box offset(float x, float y, float z) {
        return new Box(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Box offset(Vec3 vec) {
        return this.offset(vec.x, vec.y, vec.z);
    }

    public boolean intersects(Box Box2) {
        return this.intersects(Box2.minX, Box2.minY, Box2.minZ, Box2.maxX, Box2.maxY, Box2.maxZ);
    }

    public boolean intersects(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return this.minX < maxX && this.maxX > minX && this.minY < maxY && this.maxY > minY && this.minZ < maxZ && this.maxZ > minZ;
    }

    public boolean intersects(Vec3 pos1, Vec3 pos2) {
        return this.intersects(Math.min(pos1.x, pos2.x), Math.min(pos1.y, pos2.y), Math.min(pos1.z, pos2.z), Math.max(pos1.x, pos2.x), Math.max(pos1.y, pos2.y), Math.max(pos1.z, pos2.z));
    }

    public boolean contains(Vec3 pos) {
        return this.contains(pos.x, pos.y, pos.z);
    }

    public boolean contains(float x, float y, float z) {
        return x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY && z >= this.minZ && z < this.maxZ;
    }

    public Box contract(float x, float y, float z) {
        return this.expand(-x, -y, -z);
    }

    public Box contract(float value) {
        return this.expand(-value);
    }

    public Vec3 getMinPos() {
        return new Vec3(this.minX, this.minY, this.minZ);
    }

    public Vec3 getMaxPos() {
        return new Vec3(this.maxX, this.maxY, this.maxZ);
    }

    public float getAverageSideLength() {
        float d = this.getLengthX();
        float e = this.getLengthY();
        float f = this.getLengthZ();
        return (d + e + f) / 3.0f;
    }

    public float getLengthX() {
        return this.maxX - this.minX;
    }

    public float getLengthY() {
        return this.maxY - this.minY;
    }

    public float getLengthZ() {
        return this.maxZ - this.minZ;
    }

    public boolean isNaN() {
        return Float.isNaN(this.minX) || Float.isNaN(this.minY) || Float.isNaN(this.minZ) || Float.isNaN(this.maxX) || Float.isNaN(this.maxY) || Float.isNaN(this.maxZ);
    }

    public String toString() {
        return "AABB[" + this.minX + ", " + this.minY + ", " + this.minZ + "] -> [" + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public Box clone() {
        return new Box(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

