/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.protocol.mitm;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.DimensionUtil;
import ac.boar.protocol.PacketEvents;
import ac.boar.protocol.event.CloudburstPacketEvent;
import ac.boar.protocol.listener.PacketListener;
import lombok.NonNull;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.data.AuthoritativeMovementMode;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.StartGamePacket;
import org.geysermc.geyser.session.UpstreamSession;

public final class CloudburstSendListener
extends UpstreamSession {
    private final BoarPlayer player;

    public CloudburstSendListener(BoarPlayer player, BedrockServerSession session) {
        super(session);
        this.player = player;
    }

    public void sendPacket(@NonNull BedrockPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        CloudburstPacketEvent event = new CloudburstPacketEvent(this.player, packet);
        for (PacketListener listener : PacketEvents.getApi().getListeners()) {
            listener.onPacketSend(event, false);
        }
        if (event.isCancelled()) {
            return;
        }
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof StartGamePacket) {
            StartGamePacket start = (StartGamePacket)bedrockPacket;
            this.player.runtimeEntityId = start.getRuntimeEntityId();
            this.player.javaEntityId = this.player.getSession().getPlayerEntity().getEntityId();
            this.player.compensatedWorld.setDimension(DimensionUtil.dimensionFromId(start.getDimensionId()));
            this.player.currentLoadingScreen = null;
            this.player.inLoadingScreen = true;
            start.setAuthoritativeMovementMode(AuthoritativeMovementMode.SERVER_WITH_REWIND);
            start.setRewindHistorySize(Boar.getConfig().rewindHistory());
            this.player.sendLatencyStack();
            this.player.getLatencyUtil().addTaskToQueue(this.player.sentStackId.get(), () -> {
                this.player.gameType = start.getPlayerGameType();
            });
        }
        super.sendPacket(event.getPacket());
        event.getPostTasks().forEach(Runnable::run);
        event.getPostTasks().clear();
    }

    public void sendPacketImmediately(@NonNull BedrockPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        CloudburstPacketEvent event = new CloudburstPacketEvent(this.player, packet);
        for (PacketListener listener : PacketEvents.getApi().getListeners()) {
            listener.onPacketSend(event, true);
        }
        if (event.isCancelled()) {
            return;
        }
        super.sendPacketImmediately(event.getPacket());
        event.getPostTasks().forEach(Runnable::run);
        event.getPostTasks().clear();
    }
}

