/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.validator.inventory.click;

import ac.boar.anticheat.compensated.CompensatedInventory;
import ac.boar.anticheat.compensated.cache.container.ContainerCache;
import ac.boar.anticheat.data.inventory.ItemCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.validator.inventory.ItemTransactionValidator;
import ac.boar.anticheat.validator.inventory.click.BundleClickProcessor;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.RecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapedRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.DefaultDescriptor;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.InvalidDescriptor;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptor;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ConsumeAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftCreativeAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftRecipeAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftResultsDeprecatedAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.DestroyAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.DropAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.SwapAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.TransferItemStackRequestAction;

public class ItemRequestProcessor {
    private final BoarPlayer player;
    private final List<ItemCache> queuedItems = new ArrayList<ItemCache>();

    public boolean processAll(ItemStackRequest request) {
        for (ItemStackRequestAction action : request.getActions()) {
            try {
                if (this.handle(action)) continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.queuedItems.clear();
        return true;
    }

    public boolean handle(ItemStackRequestAction action) {
        CompensatedInventory inventory = this.player.compensatedInventory;
        ItemStackRequestActionType type = action.getType();
        ContainerCache cache = inventory.openContainer;
        switch (type) {
            case CRAFT_CREATIVE: {
                if (this.player.gameType != GameType.CREATIVE) {
                    return false;
                }
                CraftCreativeAction creativeAction = (CraftCreativeAction)action;
                ItemData item = inventory.getCreativeData().get(creativeAction.getCreativeItemNetworkId());
                if (item == null) {
                    return false;
                }
                this.queuedItems.add(ItemCache.build(inventory, item));
                break;
            }
            case CRAFT_RECIPE: {
                RecipeData rawRecipe;
                CraftRecipeAction craftAction = (CraftRecipeAction)action;
                if (cache.getType() != ContainerType.WORKBENCH || (rawRecipe = inventory.getCraftingData().get(craftAction.getRecipeNetworkId())) == null) break;
                List<ItemData> ingredients = List.of(cache.get(32).getData(), cache.get(33).getData(), cache.get(34).getData(), cache.get(35).getData(), cache.get(36).getData(), cache.get(37).getData(), cache.get(38).getData(), cache.get(39).getData(), cache.get(40).getData());
                List results = null;
                if (rawRecipe instanceof ShapelessRecipeData) {
                    ShapelessRecipeData shapeless = (ShapelessRecipeData)rawRecipe;
                    for (ItemDescriptorWithCount descriptor : shapeless.getIngredients()) {
                        ItemDescriptor itemDescriptor = descriptor.getDescriptor();
                        if (!(itemDescriptor instanceof DefaultDescriptor)) continue;
                        DefaultDescriptor defaultDescriptor = (DefaultDescriptor)itemDescriptor;
                        boolean valid = false;
                        for (ItemData item : ingredients) {
                            if (!ItemTransactionValidator.validate(item.getDefinition(), defaultDescriptor.getItemId())) continue;
                            valid = true;
                        }
                        if (valid) continue;
                        return false;
                    }
                    results = shapeless.getResults();
                } else if (rawRecipe instanceof ShapedRecipeData) {
                    ShapedRecipeData shaped = (ShapedRecipeData)rawRecipe;
                    ArrayList<ItemDefinition> predictedIngredients = new ArrayList<ItemDefinition>();
                    for (ItemDescriptorWithCount descriptor : shaped.getIngredients()) {
                        ItemDescriptor itemDescriptor = descriptor.getDescriptor();
                        if (itemDescriptor instanceof DefaultDescriptor) {
                            DefaultDescriptor defaultDescriptor = (DefaultDescriptor)itemDescriptor;
                            predictedIngredients.add(defaultDescriptor.getItemId());
                            continue;
                        }
                        if (!(descriptor.getDescriptor() instanceof InvalidDescriptor)) continue;
                        predictedIngredients.add(ItemDefinition.AIR);
                    }
                    for (int i = 0; i < predictedIngredients.size(); ++i) {
                        ItemDefinition claimed;
                        ItemDefinition predicted = (ItemDefinition)predictedIngredients.get(i);
                        if (ItemTransactionValidator.validate(predicted, claimed = ingredients.get(i).getDefinition())) continue;
                        return false;
                    }
                    results = shaped.getResults();
                }
                if (results == null) break;
                for (ItemData data : results) {
                    this.queuedItems.add(ItemCache.build(inventory, data));
                }
                break;
            }
            case CRAFT_RESULTS_DEPRECATED: {
                if (this.queuedItems.isEmpty()) {
                    return false;
                }
                CraftResultsDeprecatedAction craftResult = (CraftResultsDeprecatedAction)action;
                for (ItemData item : craftResult.getResultItems()) {
                    boolean valid = false;
                    for (ItemCache predicted : this.queuedItems) {
                        if (item.isNull() || !ItemTransactionValidator.validate(item, predicted.getData()) || item.getCount() != predicted.count() && this.player.gameType != GameType.CREATIVE) continue;
                        valid = true;
                    }
                    if (valid) continue;
                    return false;
                }
                break;
            }
            case TAKE: 
            case PLACE: {
                boolean create;
                TransferItemStackRequestAction transferAction = (TransferItemStackRequestAction)action;
                BundleClickProcessor.BundleResponse response = BundleClickProcessor.processBundleClick(inventory, transferAction);
                if (response.bundle()) {
                    return response.valid();
                }
                ItemStackRequestSlotData source = transferAction.getSource();
                ItemStackRequestSlotData destination = transferAction.getDestination();
                ContainerCache sourceContainer = this.findContainer(source.getContainer());
                ContainerCache destinationContainer = this.findContainer(destination.getContainer());
                int sourceSlot = source.getSlot();
                int destinationSlot = destination.getSlot();
                boolean bl = create = !this.queuedItems.isEmpty() && sourceSlot == 50 && source.getContainer() == ContainerSlotType.CREATED_OUTPUT;
                if (sourceSlot < 0 || destinationSlot < 0 || sourceSlot >= sourceContainer.getContainerSize() && !create || destinationSlot >= destinationContainer.getContainerSize()) {
                    return false;
                }
                int sourceSlotWithoutOffset = sourceSlot - sourceContainer.getOffset();
                int destinationSlotWithoutOffset = destinationSlot - destinationContainer.getOffset();
                if (sourceSlotWithoutOffset < 0 || !create && sourceSlotWithoutOffset >= sourceContainer.getContents().length) {
                    return false;
                }
                if (destinationSlotWithoutOffset < 0 || !create && destinationSlotWithoutOffset >= sourceContainer.getContents().length) {
                    return false;
                }
                ItemCache sourceData = create ? this.queuedItems.get(0) : sourceContainer.get(sourceSlot);
                ItemCache destinationData = destinationContainer.get(destinationSlot);
                if (!destinationData.getData().isNull() && !ItemTransactionValidator.validate(sourceData.getData(), destinationData.getData())) {
                    return false;
                }
                int count = transferAction.getCount();
                if (!(create && this.player.gameType == GameType.CREATIVE || !sourceData.getData().isNull() && count > 0 && count <= sourceData.count())) {
                    return false;
                }
                count = Math.max(0, count);
                if (!create) {
                    this.remove(sourceContainer, sourceSlot, sourceData, count);
                }
                if (destinationData.getData().isNull()) {
                    ItemCache cache1 = sourceData.clone();
                    cache1.count(count);
                    destinationContainer.set(destinationSlot, cache1);
                    break;
                }
                this.add(destinationData, count);
                break;
            }
            case SWAP: {
                SwapAction swapAction = (SwapAction)action;
                ItemStackRequestSlotData source = swapAction.getSource();
                ItemStackRequestSlotData destination = swapAction.getDestination();
                ContainerCache sourceContainer = this.findContainer(source.getContainer());
                ContainerCache destinationContainer = this.findContainer(destination.getContainer());
                int sourceSlot = source.getSlot();
                int destinationSlot = destination.getSlot();
                if (sourceSlot < 0 || destinationSlot < 0 || sourceSlot >= sourceContainer.getContainerSize() || destinationSlot >= destinationContainer.getContainerSize()) {
                    return false;
                }
                int sourceSlotWithoutOffset = sourceSlot - sourceContainer.getOffset();
                int destinationSlotWithoutOffset = destinationSlot - destinationContainer.getOffset();
                if (sourceSlotWithoutOffset < 0 || sourceSlotWithoutOffset >= sourceContainer.getContents().length) {
                    return false;
                }
                if (destinationSlotWithoutOffset < 0 || destinationSlotWithoutOffset >= sourceContainer.getContents().length) {
                    return false;
                }
                ItemCache sourceData = sourceContainer.get(sourceSlot);
                ItemCache destinationData = destinationContainer.get(destinationSlot);
                if (sourceData.getData().isNull() || destinationData.getData().isNull()) {
                    return false;
                }
                sourceContainer.set(sourceSlot, destinationData);
                destinationContainer.set(destinationSlot, sourceData);
                break;
            }
            case DROP: {
                DropAction dropAction = (DropAction)action;
                int slot = dropAction.getSource().getSlot();
                if (slot < 0 || slot >= cache.getContainerSize()) {
                    return false;
                }
                ItemStackRequestSlotData source = dropAction.getSource();
                if (source.getContainer() == ContainerSlotType.CURSOR) {
                    ItemCache cursor = inventory.hudContainer.get(0);
                    if (!cursor.getData().isValid() || slot != 0) {
                        return false;
                    }
                    this.remove(inventory.hudContainer, 0, cursor, dropAction.getCount());
                    break;
                }
                ItemCache data = cache.get(slot);
                this.remove(cache, slot, data, dropAction.getCount());
                break;
            }
            case DESTROY: {
                DestroyAction destroyAction = (DestroyAction)action;
                ItemStackRequestSlotData source = destroyAction.getSource();
                ContainerCache sourceContainer = this.findContainer(source.getContainer());
                int slot = source.getSlot();
                if (slot < 0 || slot > sourceContainer.getContainerSize()) {
                    return false;
                }
                ItemCache itemData = sourceContainer.get(slot);
                if (destroyAction.getCount() > itemData.count()) {
                    return false;
                }
                this.remove(sourceContainer, slot, itemData, destroyAction.getCount());
                break;
            }
            case CONSUME: {
                ConsumeAction consumeAction = (ConsumeAction)action;
                ItemStackRequestSlotData source = consumeAction.getSource();
                ContainerCache sourceContainer = this.findContainer(source.getContainer());
                int slot = source.getSlot();
                if (slot < 0 || slot > sourceContainer.getContainerSize()) {
                    return false;
                }
                ItemCache itemData = sourceContainer.get(slot);
                if (consumeAction.getCount() > itemData.count()) {
                    return false;
                }
                this.remove(sourceContainer, slot, itemData, consumeAction.getCount());
            }
        }
        return true;
    }

    public void add(ItemCache data, int counts) {
        data.count(data.count() + counts);
    }

    private void remove(ContainerCache cache, int slot, ItemCache data, int counts) {
        if (counts >= data.count()) {
            cache.set(slot, ItemData.AIR);
        } else if (data.count() > 0) {
            if (data.count() - counts <= 0) {
                cache.set(slot, ItemCache.AIR);
            } else {
                data.count(data.count() - counts);
            }
        }
    }

    private ContainerCache findContainer(ContainerSlotType type) {
        return ItemRequestProcessor.findContainer(this.player.compensatedInventory, type);
    }

    public static ContainerCache findContainer(CompensatedInventory inventory, ContainerSlotType type) {
        return switch (type) {
            case ContainerSlotType.CURSOR -> inventory.hudContainer;
            case ContainerSlotType.ARMOR -> inventory.armorContainer;
            case ContainerSlotType.OFFHAND -> inventory.offhandContainer;
            case ContainerSlotType.INVENTORY, ContainerSlotType.HOTBAR, ContainerSlotType.HOTBAR_AND_INVENTORY -> inventory.inventoryContainer;
            default -> inventory.openContainer;
        };
    }

    @Generated
    public ItemRequestProcessor(BoarPlayer player) {
        this.player = player;
    }
}

