/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.transformer.impl.redirect;

import ac.boar.shaded.asm.Type;
import ac.boar.shaded.asm.tree.AbstractInsnNode;
import ac.boar.shaded.asm.tree.ClassNode;
import ac.boar.shaded.asm.tree.InsnList;
import ac.boar.shaded.asm.tree.MethodInsnNode;
import ac.boar.shaded.asm.tree.MethodNode;
import ac.boar.shaded.asm.tree.VarInsnNode;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import ac.boar.shaded.classtransform.utils.Types;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface IRedirectTarget {
    public void inject(ClassNode var1, MethodNode var2, ClassNode var3, MethodNode var4, AbstractInsnNode var5, List<MethodInsnNode> var6);

    default public InsnList[] getLoadStoreOpcodes(@Nullable String owner, String desc, int freeVarIndex) {
        Type[] argumentTypes;
        InsnList storeOpcodes = new InsnList();
        InsnList loadOpcodes = new InsnList();
        if (owner != null) {
            Type ownerType = Types.type(owner);
            storeOpcodes.add(new VarInsnNode(ASMUtils.getStoreOpcode(ownerType), freeVarIndex));
            loadOpcodes.add(new VarInsnNode(ASMUtils.getLoadOpcode(ownerType), freeVarIndex));
            freeVarIndex += ownerType.getSize();
        }
        for (Type argumentType : argumentTypes = Types.argumentTypes(desc)) {
            int storeOpcode = ASMUtils.getStoreOpcode(argumentType);
            int loadOpcode = ASMUtils.getLoadOpcode(argumentType);
            storeOpcodes.add(new VarInsnNode(storeOpcode, freeVarIndex));
            loadOpcodes.add(new VarInsnNode(loadOpcode, freeVarIndex));
            freeVarIndex += argumentType.getSize();
        }
        InsnList reversedStoreOpcodes = new InsnList();
        for (int i = storeOpcodes.size() - 1; i >= 0; --i) {
            reversedStoreOpcodes.add(storeOpcodes.get(i));
        }
        return new InsnList[]{reversedStoreOpcodes, loadOpcodes};
    }
}

