/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.transformer.impl.general.membercopy;

import ac.boar.shaded.classtransform.utils.ASMComparator;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import ac.boar.shaded.classtransform.utils.Types;
import ac.boar.shaded.classtransform.utils.mappings.Remapper;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class InitializerMerger {
    public static void mergeInitializers(ClassNode transformedClass, ClassNode transformer) {
        MethodNode staticBlock;
        Map<String, InsnList> fieldInitializers = null;
        for (MethodNode method : transformer.methods) {
            if (!method.name.equals("<init>")) continue;
            Map<String, InsnList> initializers = InitializerMerger.getFieldInitializers(transformer, method);
            if (fieldInitializers == null) {
                fieldInitializers = initializers;
                continue;
            }
            Set<String> diff = InitializerMerger.diff(fieldInitializers.keySet(), initializers.keySet());
            if (!diff.isEmpty()) {
                throw new IllegalStateException("Class " + transformer.name + " has different field initializers in multiple constructor methods. Field differences: " + diff);
            }
            for (String fieldName : fieldInitializers.keySet()) {
                InsnList instructions2;
                InsnList instructions1 = fieldInitializers.get(fieldName);
                if (ASMComparator.equals(instructions1, instructions2 = initializers.get(fieldName))) continue;
                throw new IllegalStateException("Class " + transformer.name + " has different field initializers in multiple constructor methods. Field instruction difference: " + fieldName);
            }
        }
        if (fieldInitializers != null && !fieldInitializers.isEmpty()) {
            for (MethodNode method : transformedClass.methods) {
                if (!method.name.equals("<init>")) continue;
                InitializerMerger.mergeFieldInitializers(transformer, transformedClass, method, fieldInitializers);
            }
        }
        if ((staticBlock = ASMUtils.getMethod(transformer, "<clinit>", Types.MD_Void)) != null) {
            InitializerMerger.mergeFieldInitializers(transformer, transformedClass, InitializerMerger.getOrCreateClinit(transformedClass), InitializerMerger.getFieldInitializers(transformer, staticBlock));
        }
    }

    private static Map<String, InsnList> getFieldInitializers(ClassNode owner, MethodNode method) {
        AbstractInsnNode firstInstruction = method.name.equals("<init>") ? ASMUtils.getFirstConstructorInstruction(owner.superName, method) : method.instructions.getFirst();
        if (firstInstruction == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, InsnList> fieldInitializers = new LinkedHashMap<String, InsnList>();
        InsnList lastInstructions = new InsnList();
        Map<LabelNode, LabelNode> labels = ASMUtils.cloneLabels(method.instructions);
        for (int i = method.instructions.indexOf(firstInstruction); i < method.instructions.size(); ++i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            if (instruction instanceof LineNumberNode || instruction instanceof FrameNode) continue;
            lastInstructions.add(instruction.clone(labels));
            if (!(instruction instanceof FieldInsnNode) || instruction.getOpcode() != 181 && instruction.getOpcode() != 179) continue;
            FieldInsnNode fieldInsnNode = (FieldInsnNode)instruction;
            if (!fieldInsnNode.owner.equals(owner.name)) {
                throw new IllegalStateException("Can't copy field initializer from " + owner.nestHostClass + " of field belonging to " + fieldInsnNode.owner + " to another class. Please use @CInject into the constructor instead.");
            }
            fieldInitializers.put(fieldInsnNode.name + ":" + fieldInsnNode.desc, lastInstructions);
            lastInstructions = new InsnList();
        }
        return fieldInitializers;
    }

    private static void mergeFieldInitializers(ClassNode source, ClassNode target, MethodNode initializer, Map<String, InsnList> fieldInitializers) {
        if (fieldInitializers.isEmpty()) {
            return;
        }
        AbstractInsnNode firstInstruction = initializer.name.equals("<init>") ? ASMUtils.getFirstConstructorInstruction(target.superName, initializer) : initializer.instructions.getFirst();
        if (firstInstruction == null) {
            firstInstruction = new InsnNode(177);
            initializer.instructions.add(firstInstruction);
        }
        if (firstInstruction.getOpcode() >= 172 && firstInstruction.getOpcode() <= 177) {
            InsnNode newFirstInstruction = new InsnNode(0);
            initializer.instructions.insertBefore(firstInstruction, newFirstInstruction);
            firstInstruction = newFirstInstruction;
        }
        for (AbstractInsnNode instruction : initializer.instructions.toArray()) {
            InsnList instructions;
            if (!(instruction instanceof FieldInsnNode) || instruction.getOpcode() != 181 && instruction.getOpcode() != 179) continue;
            FieldInsnNode fieldInsnNode = (FieldInsnNode)instruction;
            if (!fieldInsnNode.owner.equals(target.name) || (instructions = fieldInitializers.remove(fieldInsnNode.name + ":" + fieldInsnNode.desc)) == null) continue;
            initializer.instructions.insert(instruction, InitializerMerger.remapInstructions(instructions, source.name, target.name));
        }
        for (InsnList instructions : fieldInitializers.values()) {
            initializer.instructions.insert(firstInstruction, InitializerMerger.remapInstructions(instructions, source.name, target.name));
        }
    }

    private static InsnList remapInstructions(InsnList instructions, String fromName, String toName) {
        ClassNode tempClassHolder = new ClassNode();
        tempClassHolder.visit(0, 0, "temp", null, Types.IN_Object, null);
        MethodNode tempMethodHolder = new MethodNode(0, "temp", Types.MD_Void, null, null);
        tempMethodHolder.instructions = instructions;
        Remapper.remapAndAdd(fromName, toName, tempClassHolder, tempMethodHolder);
        return tempClassHolder.methods.get((int)0).instructions;
    }

    private static MethodNode getOrCreateClinit(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("<clinit>")) continue;
            return method;
        }
        MethodNode staticBlock = new MethodNode(8, "<clinit>", Types.MD_Void, null, null);
        staticBlock.instructions.add(new InsnNode(177));
        classNode.methods.add(staticBlock);
        return staticBlock;
    }

    private static Set<String> diff(Set<String> set1, Set<String> set2) {
        HashSet<String> diff = new HashSet<String>();
        for (String s : set1) {
            if (set2.contains(s)) continue;
            diff.add(s);
        }
        for (String s : set2) {
            if (set1.contains(s)) continue;
            diff.add(s);
        }
        return diff;
    }
}

