/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.jackson.databind.ser.std;

import ac.boar.shaded.jackson.core.JsonGenerator;
import ac.boar.shaded.jackson.databind.JavaType;
import ac.boar.shaded.jackson.databind.JsonMappingException;
import ac.boar.shaded.jackson.databind.SerializerProvider;
import ac.boar.shaded.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import ac.boar.shaded.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import ac.boar.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ac.boar.shaded.jackson.databind.ser.std.StdScalarSerializer;
import ac.boar.shaded.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

