/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.teleport;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.data.input.PredictionData;
import ac.boar.anticheat.data.input.TickData;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.teleport.data.TeleportCache;
import ac.boar.anticheat.teleport.data.rewind.RewindData;
import ac.boar.anticheat.util.math.Vec3;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.PredictionType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.CorrectPlayerMovePredictionPacket;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;

public class TeleportUtil {
    private final BoarPlayer player;
    private Vector3f lastKnowValid = Vector3f.ZERO;
    private final Queue<TeleportCache> queuedTeleports = new ConcurrentLinkedQueue<TeleportCache>();
    private final Map<Long, TickData> authInputHistory = new ConcurrentSkipListMap<Long, TickData>();
    private final Map<Long, RewindData> rewindHistory = new ConcurrentSkipListMap<Long, RewindData>();

    public boolean isTeleporting() {
        return !this.queuedTeleports.isEmpty();
    }

    public void teleportTo(Vector3f position) {
        this.teleportTo(new TeleportCache.Normal(0L, new Vec3(position)));
    }

    public void teleportTo(TeleportCache cache) {
        if (this.isTeleporting()) {
            return;
        }
        if (cache instanceof TeleportCache.Rewind) {
            throw new RuntimeException("You're not suppose to pass rewind teleport to this method!");
        }
        TeleportCache.Normal teleport = (TeleportCache.Normal)cache;
        MovePlayerPacket packet = new MovePlayerPacket();
        packet.setRuntimeEntityId(this.player.runtimeEntityId);
        packet.setPosition(teleport.getPosition().toVector3f());
        packet.setRotation(this.player.rotation);
        packet.setOnGround(this.player.onGround);
        packet.setMode(MovePlayerPacket.Mode.TELEPORT);
        packet.setTeleportationCause(MovePlayerPacket.TeleportationCause.BEHAVIOR);
        this.queueTeleport(teleport.getPosition(), false);
        this.player.getCloudburstDownstream().sendPacket((BedrockPacket)packet);
    }

    public void queueTeleport(Vec3 position, boolean immediate) {
        this.player.sendLatencyStack(immediate);
        this.queuedTeleports.add(new TeleportCache.Normal(this.player.sentStackId.get(), position));
        this.lastKnowValid = position.toVector3f();
    }

    public void rewind(long tick) {
        this.rewind(this.rewindHistory.getOrDefault(tick, new RewindData(this.player.tick, this.lastKnowValid, this.player.predictionResult)));
    }

    public void rewind(RewindData rewind) {
        if (this.isTeleporting()) {
            return;
        }
        PredictionData data = rewind.data();
        boolean onGround = data.before().y != data.after().y && data.before().y < 0.0f;
        long tick = rewind.tick();
        CorrectPlayerMovePredictionPacket packet = new CorrectPlayerMovePredictionPacket();
        packet.setPosition(rewind.position().add(data.after().toVector3f()));
        packet.setOnGround(onGround);
        packet.setTick(tick);
        packet.setDelta(data.tickEnd().toVector3f());
        packet.setPredictionType(this.player.vehicleData != null ? PredictionType.VEHICLE : PredictionType.PLAYER);
        this.player.sendLatencyStack();
        this.queuedTeleports.add(new TeleportCache.Rewind(this.player.sentStackId.get(), tick, new Vec3(packet.getPosition()), new Vec3(packet.getDelta()), onGround));
        this.player.getCloudburstDownstream().sendPacket((BedrockPacket)packet);
    }

    public void cachePosition(long tick, Vector3f position) {
        this.rewindHistory.put(tick, new RewindData(tick, this.lastKnowValid.clone(), this.player.predictionResult));
        this.lastKnowValid = position;
    }

    public void pollRewindHistory() {
        Iterator<Map.Entry<Long, RewindData>> iterator = this.rewindHistory.entrySet().iterator();
        while (iterator.hasNext() && this.rewindHistory.size() > Boar.getConfig().rewindHistory()) {
            iterator.next();
            iterator.remove();
        }
        Iterator<Map.Entry<Long, TickData>> iterator1 = this.authInputHistory.entrySet().iterator();
        while (iterator1.hasNext() && this.authInputHistory.size() > Boar.getConfig().rewindHistory()) {
            iterator1.next();
            iterator1.remove();
        }
    }

    @Generated
    public TeleportUtil(BoarPlayer player) {
        this.player = player;
    }

    @Generated
    public BoarPlayer getPlayer() {
        return this.player;
    }

    @Generated
    public Vector3f getLastKnowValid() {
        return this.lastKnowValid;
    }

    @Generated
    public Queue<TeleportCache> getQueuedTeleports() {
        return this.queuedTeleports;
    }

    @Generated
    public Map<Long, TickData> getAuthInputHistory() {
        return this.authInputHistory;
    }

    @Generated
    public Map<Long, RewindData> getRewindHistory() {
        return this.rewindHistory;
    }
}

