/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.other;

import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.player.data.VehicleData;
import ac.boar.protocol.event.CloudburstPacketEvent;
import ac.boar.protocol.listener.PacketListener;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.InteractPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;

public class VehiclePackets
implements PacketListener {
    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof InteractPacket) {
            InteractPacket packet = (InteractPacket)bedrockPacket;
            if (packet.getRuntimeEntityId() != player.runtimeEntityId) {
                return;
            }
            if (packet.getAction() == InteractPacket.Action.LEAVE_VEHICLE) {
                player.vehicleData = null;
            }
        }
    }

    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof SetEntityLinkPacket) {
            SetEntityLinkPacket packet = (SetEntityLinkPacket)bedrockPacket;
            EntityLinkData link = packet.getEntityLink();
            if (link == null) {
                return;
            }
            long entityId = packet.getEntityLink().getFrom();
            long riderId = packet.getEntityLink().getTo();
            if (riderId != player.runtimeEntityId) {
                EntityCache riderCache = player.compensatedWorld.getEntity(riderId);
                if (riderCache != null) {
                    riderCache.setInVehicle(link.getType() != EntityLinkData.Type.REMOVE);
                }
                return;
            }
            EntityCache cache = player.compensatedWorld.getEntity(entityId);
            if (cache == null) {
                return;
            }
            player.getTeleportUtil().getQueuedTeleports().clear();
            player.sendLatencyStack(immediate);
            if (link.getType() == EntityLinkData.Type.REMOVE) {
                player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                    player.vehicleData = null;
                });
                return;
            }
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                player.vehicleData = new VehicleData();
                player.vehicleData.vehicleRuntimeId = entityId;
            });
        }
    }
}

