/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.transformer.impl;

import ac.boar.shaded.asm.tree.ClassNode;
import ac.boar.shaded.asm.tree.MethodNode;
import ac.boar.shaded.classtransform.TransformerManager;
import ac.boar.shaded.classtransform.annotations.injection.COverride;
import ac.boar.shaded.classtransform.exceptions.TransformerException;
import ac.boar.shaded.classtransform.transformer.types.RemovingTargetAnnotationHandler;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import ac.boar.shaded.classtransform.utils.Types;
import ac.boar.shaded.classtransform.utils.mappings.Remapper;
import java.lang.reflect.Modifier;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class COverrideAnnotationHandler
extends RemovingTargetAnnotationHandler<COverride> {
    public COverrideAnnotationHandler() {
        super(COverride.class, COverride::value);
    }

    @Override
    public void transform(COverride annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target) {
        if (Modifier.isStatic(target.access) != Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, Modifier.isStatic(target.access));
        }
        if (!ASMUtils.compareTypes(Types.argumentTypes(target.desc), Types.argumentTypes(transformerMethod.desc))) {
            throw TransformerException.wrongArguments(transformerMethod, transformer, Types.argumentTypes(target.desc));
        }
        if (ASMUtils.isAccessLower(transformerMethod.access, target.access)) {
            throw new TransformerException(transformerMethod, transformer, "must have higher/equal access than original method");
        }
        transformerMethod.name = target.name;
        transformerMethod.desc = target.desc;
        transformedClass.methods.remove(target);
        this.prepareForCopy(transformer, transformerMethod);
        Remapper.remapAndAdd(transformer, transformedClass, transformerMethod);
    }
}

