/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public record ExceptionInfo(String type, String message, String desc, List<StackElement> stack, ExceptionInfo cause) {
    public static ExceptionInfo fromException(Throwable e) {
        String type = e.getClass().getName();
        String desc = e.toString();
        ImmutableList.Builder stackBuilder = new ImmutableList.Builder();
        boolean hitMinescriptJava = false;
        int stackDepth = 0;
        for (StackTraceElement element : e.getStackTrace()) {
            if (++stackDepth > 10) break;
            String className = element.getClassName();
            String fileName = element.getFileName();
            if (className != null) {
                if (!hitMinescriptJava && className.contains("minescript")) {
                    hitMinescriptJava = true;
                } else if (hitMinescriptJava && !className.contains("minescript")) break;
            }
            stackBuilder.add((Object)new StackElement(fileName, element.getMethodName(), element.getLineNumber()));
        }
        Optional<ExceptionInfo> cause = Optional.ofNullable(e.getCause()).map(ExceptionInfo::fromException);
        return new ExceptionInfo(type, e.getMessage(), desc, (List<StackElement>)stackBuilder.build(), cause.orElse(null));
    }

    public record StackElement(String file, String method, int line) {
    }
}

