/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.minescript.common.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceTracker<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String resourceTypeName;
    private final int jobId;
    private final Config config;
    private final AtomicLong idAllocator = new AtomicLong(0L);
    private final Map<Long, T> resources = new HashMap<Long, T>();

    public ResourceTracker(Class<T> resourceType, int jobId, Config config) {
        this.resourceTypeName = resourceType.getSimpleName();
        this.jobId = jobId;
        this.config = config;
    }

    private IdStatus getIdStatus(long id) {
        if (id <= 0L || id > this.idAllocator.get()) {
            return IdStatus.UNALLOCATED;
        }
        if (this.resources.containsKey(id)) {
            return IdStatus.ALLOCATED;
        }
        return IdStatus.RELEASED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long retain(T resource) {
        long id = this.idAllocator.incrementAndGet();
        ResourceTracker resourceTracker = this;
        synchronized (resourceTracker) {
            this.resources.put(id, resource);
        }
        if (this.config.debugOutput()) {
            LOGGER.info("Mapped Job[{}] {}[{}]: {}", (Object)this.jobId, (Object)this.resourceTypeName, (Object)id, resource);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reassignId(long id, T resource) {
        ResourceTracker resourceTracker = this;
        synchronized (resourceTracker) {
            switch (this.getIdStatus(id).ordinal()) {
                case 0: {
                    throw new IllegalArgumentException(String.format("No %s allocated yet with ID %s", this.resourceTypeName, id));
                }
                case 2: {
                    throw new IllegalStateException(String.format("%s with ID %s already released", this.resourceTypeName, id));
                }
                case 1: {
                    this.resources.put(id, resource);
                }
            }
        }
        if (this.config.debugOutput()) {
            LOGGER.info("Remapped Job[{}] {}[{}]: {}", (Object)this.jobId, (Object)this.resourceTypeName, (Object)id, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getById(long id) {
        if (id == 0L) {
            return null;
        }
        ResourceTracker resourceTracker = this;
        synchronized (resourceTracker) {
            switch (this.getIdStatus(id).ordinal()) {
                case 0: {
                    throw new IllegalArgumentException(String.format("No %s allocated yet with ID %s", this.resourceTypeName, id));
                }
                case 2: {
                    throw new IllegalStateException(String.format("%s with ID %s already released", this.resourceTypeName, id));
                }
            }
            return this.resources.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T releaseById(long id) {
        T resource;
        ResourceTracker resourceTracker = this;
        synchronized (resourceTracker) {
            switch (this.getIdStatus(id).ordinal()) {
                case 0: {
                    throw new IllegalArgumentException(String.format("No %s allocated yet with ID %s", this.resourceTypeName, id));
                }
                case 2: {
                    throw new IllegalStateException(String.format("%s with ID %s already released", this.resourceTypeName, id));
                }
            }
            resource = this.resources.remove(id);
        }
        if (this.config.debugOutput()) {
            LOGGER.info("Unmapped Job[{}] {}[{}]: {}", (Object)this.jobId, (Object)this.resourceTypeName, (Object)id, resource);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        ResourceTracker resourceTracker = this;
        synchronized (resourceTracker) {
            if (this.config.debugOutput()) {
                for (Map.Entry<Long, T> entry : this.resources.entrySet()) {
                    long id = entry.getKey();
                    T resource = entry.getValue();
                    LOGGER.info("Unmapped Job[{}] {}[{}]: {}", (Object)this.jobId, (Object)this.resourceTypeName, (Object)id, resource);
                }
            }
            this.resources.clear();
        }
    }

    public static enum IdStatus {
        UNALLOCATED(0),
        ALLOCATED(1),
        RELEASED(2);

        private final int code;

        private IdStatus(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }
}

