/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common.pyjinn;

import java.util.Map;
import net.minescript.common.BlockPack;
import net.minescript.common.BlockPacker;
import net.minescript.common.Message;
import net.minescript.common.Minescript;
import net.minescript.common.blocks.BlockRegionReader;
import net.minescript.common.pyjinn.PyjinnUtil;
import org.pyjinn.interpreter.Script;

public class BlockPack {
    private static final Script.KeywordArgs EMPTY_KEYWORD_ARGS = new Script.KeywordArgs();
    final net.minescript.common.BlockPack impl;

    public BlockPack(net.minescript.common.BlockPack blockpack) {
        this.impl = blockpack;
    }

    public static BlockPack read_world(Object pos1, Object pos2) {
        return BlockPack.read_world(pos1, pos2, EMPTY_KEYWORD_ARGS);
    }

    public static BlockPack read_world(Object pos1, Object pos2, Script.KeywordArgs kwargs) {
        int[] rotation = PyjinnUtil.toNullableIntArray(kwargs.get((Object)"rotation"));
        int[] offset = PyjinnUtil.toNullableIntArray(kwargs.get((Object)"offset"));
        int[] p1 = PyjinnUtil.toRequiredIntArray(pos1);
        int[] p2 = PyjinnUtil.toRequiredIntArray(pos2);
        BlockPacker blockpacker = new BlockPacker();
        Script.PyjDict commentsToAdd = (Script.PyjDict)kwargs.get((Object)"comments");
        if (commentsToAdd != null) {
            Map<String, String> comments = blockpacker.comments();
            for (Script.PyjTuple kvPair : commentsToAdd.items()) {
                comments.put(kvPair.__getitem__((Object)0).toString(), kvPair.__getitem__((Object)1).toString());
            }
        }
        boolean safetyLimit = (Boolean)kwargs.getOrDefault((Object)"safety_limit", (Object)true);
        final BlockPack.TransformedBlockConsumer blockConsumer = new BlockPack.TransformedBlockConsumer(rotation, offset, blockpacker);
        BlockRegionReader blockReader = BlockRegionReader.withBounds(p1[0], p1[1], p1[2], p2[0], p2[1], p2[2], safetyLimit);
        blockReader.readBlocks(new BlockRegionReader.BlockConsumer(){

            @Override
            public void setblock(int x, int y, int z, String block) {
                blockConsumer.setblock(x, y, z, block);
            }

            @Override
            public void setAir(int x, int y, int z) {
            }

            @Override
            public void reportBlockError(int x, int y, int z, String error) {
                Minescript.systemMessageQueue.logUserError(error, new Object[0]);
            }
        });
        return new BlockPack(blockpacker.pack());
    }

    public static BlockPack read_file(String blockpackFilename) throws Exception {
        return new BlockPack(net.minescript.common.BlockPack.readZipFile(blockpackFilename));
    }

    public static BlockPack import_data(String base64Data) {
        return new BlockPack(net.minescript.common.BlockPack.fromBase64EncodedString(base64Data));
    }

    public Script.PyjTuple block_bounds() {
        int[] bounds = this.impl.blockBounds();
        Script.PyjTuple minBound = new Script.PyjTuple(new Object[]{bounds[0], bounds[1], bounds[2]});
        Script.PyjTuple maxBound = new Script.PyjTuple(new Object[]{bounds[3], bounds[4], bounds[5]});
        return new Script.PyjTuple(new Object[]{minBound, maxBound});
    }

    public Script.PyjDict comments() {
        return new Script.PyjDict(this.impl.comments());
    }

    public boolean write_world() {
        return this.write_world(EMPTY_KEYWORD_ARGS);
    }

    public boolean write_world(Script.KeywordArgs kwargs) {
        int[] rotation = PyjinnUtil.toNullableIntArray(kwargs.get((Object)"rotation"));
        int[] offset = PyjinnUtil.toNullableIntArray(kwargs.get((Object)"offset"));
        this.impl.getBlockCommands(rotation, offset, s -> Minescript.systemMessageQueue.add(Message.createMinecraftCommand(s)));
        return true;
    }

    public boolean write_file(String blockpackFilename) throws Exception {
        this.impl.writeZipFile(blockpackFilename);
        return true;
    }

    public String export_data() {
        return this.impl.toBase64EncodedString();
    }

    public void visit_blocks(final SetblockConsumer blockConsumer, final FillConsumer fillConsumer) {
        this.impl.getBlocks(new BlockPack.BlockConsumer(){

            @Override
            public void setblock(int x, int y, int z, String block) {
                blockConsumer.setblock(x, y, z, block);
            }

            @Override
            public void fill(int x1, int y1, int z1, int x2, int y2, int z2, String block) {
                fillConsumer.fill(x1, y1, z1, x2, y2, z2, block);
            }
        });
    }

    public static interface SetblockConsumer {
        public void setblock(int var1, int var2, int var3, String var4);
    }

    public static interface FillConsumer {
        public void fill(int var1, int var2, int var3, int var4, int var5, int var6, String var7);
    }
}

