/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minescript.common.EventListener;
import net.minescript.common.JobOperationId;

class EventDispatcher {
    private Map<JobOperationId, EventListener> listeners = new ConcurrentHashMap<JobOperationId, EventListener>();
    private Function<Map<String, Object>, Optional<Predicate<Object>>> listenerArgsProcessor;

    EventDispatcher() {
        this(args -> Optional.empty());
    }

    EventDispatcher(Function<Map<String, Object>, Optional<Predicate<Object>>> listenerArgsProcessor) {
        this.listenerArgsProcessor = listenerArgsProcessor;
    }

    boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    Set<Map.Entry<JobOperationId, EventListener>> entrySet() {
        return this.listeners.entrySet();
    }

    Set<JobOperationId> keySet() {
        return this.listeners.keySet();
    }

    Collection<EventListener> values() {
        return this.listeners.values();
    }

    boolean containsKey(JobOperationId id) {
        return this.listeners.containsKey(id);
    }

    EventListener addListener(JobOperationId id, Map<String, Object> listenerArgs, EventListener listener) {
        this.initListener(listenerArgs, listener);
        return this.listeners.put(id, listener);
    }

    private void initListener(Map<String, Object> listenerArgs, EventListener listener) {
        this.listenerArgsProcessor.apply(listenerArgs).ifPresent(listener::setFilter);
    }

    EventListener get(JobOperationId id) {
        return this.listeners.get(id);
    }

    EventListener remove(JobOperationId id) {
        return this.listeners.remove(id);
    }
}

