/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minescript.common.ScriptRedirect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path minescriptDir;
    private final ImmutableList<String> builtinCommands;
    private final ImmutableSet<String> ignoreDirs;
    private boolean escapeCommandDoubleQuotes = System.getProperty("os.name").startsWith("Windows");
    private ImmutableList<Path> commandPath = ImmutableList.of((Object)Paths.get("system", "exec"), (Object)Paths.get("", new String[0]));
    private String minescriptCommandPathEnvVar;
    private Map<String, FileTypeConfig> fileTypeMap = new ConcurrentHashMap<String, FileTypeConfig>();
    private List<String> fileExtensions = new ArrayList<String>();

    public ScriptConfig(String minescriptDirName, ImmutableList<String> builtinCommands, ImmutableSet<String> ignoreDirs) {
        this.minescriptDir = Paths.get(System.getProperty("user.dir"), minescriptDirName);
        this.builtinCommands = builtinCommands;
        this.ignoreDirs = ignoreDirs;
        this.minescriptCommandPathEnvVar = "MINESCRIPT_COMMAND_PATH=" + String.join((CharSequence)File.pathSeparator, this.commandPath.stream().map(p -> this.minescriptDir.resolve((Path)p).toString()).collect(Collectors.toList()));
        ImmutableList commandPattern = ImmutableList.of((Object)"{command}", (Object)"{args}");
        ImmutableList environmentVars = ImmutableList.of();
        this.configureFileType(new CommandConfig(".pyj", (List<String>)commandPattern, (List<String>)environmentVars), false);
    }

    public void setCommandPath(List<Path> commandPath) {
        this.commandPath = ImmutableList.copyOf(commandPath);
        this.minescriptCommandPathEnvVar = "MINESCRIPT_COMMAND_PATH=" + String.join((CharSequence)File.pathSeparator, this.commandPath.stream().map(p -> this.minescriptDir.resolve((Path)p).toString()).collect(Collectors.toList()));
    }

    public void setEscapeCommandDoubleQuotes(boolean enable) {
        this.escapeCommandDoubleQuotes = enable;
    }

    public boolean escapeCommandDoubleQuotes() {
        return this.escapeCommandDoubleQuotes;
    }

    public ImmutableList<Path> commandPath() {
        return this.commandPath;
    }

    private void addMatchingFilesInDir(String prefix, Path prefixPath, Path commandDir, List<String> matches) {
        String prefixFileName;
        Path resolvedCommandDir;
        Path resolvedDir = resolvedCommandDir = this.minescriptDir.resolve(commandDir);
        for (int i = 0; i < prefixPath.getNameCount() - 1; ++i) {
            if ((resolvedDir = resolvedDir.resolve(prefixPath.getName(i))) != null && Files.isDirectory(resolvedDir, new LinkOption[0])) continue;
            return;
        }
        if (resolvedDir == null) {
            return;
        }
        if (prefix.length() > 1 && prefix.endsWith(File.separator)) {
            if ((resolvedDir = resolvedDir.resolve(prefixPath.getFileName())) == null || !Files.isDirectory(resolvedDir, new LinkOption[0])) {
                return;
            }
            prefixFileName = "";
        } else {
            Path fileName = prefixPath.getFileName();
            if (fileName == null) {
                return;
            }
            prefixFileName = fileName.toString();
        }
        if (resolvedDir == null || !Files.isDirectory(resolvedDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.list(resolvedDir);){
            paths.forEach(path -> {
                String fileName = path.getFileName().toString();
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (!fileName.startsWith(prefixFileName)) return;
                    try {
                        String relativeName = resolvedCommandDir.relativize((Path)path).toString();
                        if (commandDir.toString().isEmpty() && this.ignoreDirs.contains((Object)relativeName)) return;
                        matches.add(relativeName + File.separator);
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.info("Dir completion: resolvedCommandDir: {}  path: {}", (Object)resolvedCommandDir, path);
                        throw e;
                    }
                }
                if (!this.fileExtensions.contains(ScriptConfig.getFileExtension(fileName))) return;
                try {
                    String scriptName = ScriptConfig.removeFileExtension(resolvedCommandDir.relativize((Path)path).toString());
                    if (!scriptName.startsWith(prefix) || matches.contains(scriptName)) return;
                    matches.add(scriptName);
                    return;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.info("File completion: resolvedCommandDir: {}  path: {}", (Object)resolvedCommandDir, path);
                    throw e;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Error listing files inside dir `{}`: {}", (Object)resolvedDir, (Object)e);
        }
    }

    public List<String> findCommandPrefixMatches(String prefix) {
        ArrayList<String> matches = new ArrayList<String>();
        Path prefixPath = Paths.get(prefix, new String[0]);
        if (prefixPath.isAbsolute()) {
            return new ArrayList<String>();
        }
        for (String builtin : this.builtinCommands) {
            if (!builtin.startsWith(prefix)) continue;
            matches.add(builtin);
        }
        for (Path commandDir : this.commandPath) {
            this.addMatchingFilesInDir(prefix, prefixPath, commandDir, matches);
        }
        return matches;
    }

    public void configureFileType(CommandConfig commandConfig, boolean createsSubprocess) {
        Preconditions.checkNotNull((Object)commandConfig.extension);
        Preconditions.checkArgument((boolean)commandConfig.extension.startsWith("."), (String)"File extension does not start with dot: \"%s\"", (Object)commandConfig.extension);
        FileTypeConfig fileTypeConfig = new FileTypeConfig(CommandBuilder.create(commandConfig.command, () -> createsSubprocess && this.escapeCommandDoubleQuotes), commandConfig.environment == null ? new String[]{} : (String[])commandConfig.environment.stream().map(s -> s.replace("{minescript_dir}", this.minescriptDir.toString())).toArray(String[]::new));
        if (this.fileTypeMap.put(commandConfig.extension, fileTypeConfig) == null) {
            this.fileExtensions.add(commandConfig.extension);
        } else {
            LOGGER.warn("Existing file extension configuration is being replaced: \"{}\"", (Object)commandConfig.extension);
        }
        LOGGER.info("Configured file extension `{}` for commands: {}", (Object)commandConfig.extension, (Object)commandConfig);
    }

    public List<String> supportedFileExtensions() {
        return this.fileExtensions;
    }

    public Path resolveCommandPath(String command) {
        for (Path commandDir : this.commandPath) {
            for (String fileExtension : this.fileExtensions) {
                Path path = this.minescriptDir.resolve(commandDir).resolve(command + fileExtension);
                if (!Files.exists(path, new LinkOption[0])) continue;
                return path;
            }
        }
        return null;
    }

    public ExecutableCommand getExecutableCommand(BoundCommand boundCommand) {
        FileTypeConfig fileTypeConfig = this.fileTypeMap.get(boundCommand.fileExtension());
        if (fileTypeConfig == null) {
            return null;
        }
        ArrayList<String> env = new ArrayList<String>();
        Collections.addAll(env, fileTypeConfig.environment());
        if (!this.minescriptCommandPathEnvVar.isEmpty()) {
            env.add(this.minescriptCommandPathEnvVar);
        }
        return new ExecutableCommand(fileTypeConfig.commandBuilder.buildExecutableCommand(boundCommand), (String[])env.toArray(String[]::new));
    }

    private static String getFileExtension(String fileName) {
        int lastIndex = fileName.lastIndexOf(46);
        if (lastIndex == -1) {
            return "";
        }
        return fileName.substring(lastIndex);
    }

    private static String removeFileExtension(String fileName) {
        int lastIndex = fileName.lastIndexOf(46);
        if (lastIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, lastIndex);
    }

    public record CommandConfig(String extension, List<String> command, List<String> environment) {
    }

    public record FileTypeConfig(CommandBuilder commandBuilder, String[] environment) {
    }

    public record CommandBuilder(String[] pattern, int commandIndex, int argsIndex, Supplier<Boolean> escapeCommandDoubleQuotesSupplier) {
        public static CommandBuilder create(List<String> commandPattern, Supplier<Boolean> escapeCommandDoubleQuotesSupplier) {
            int commandIndex = commandPattern.indexOf("{command}");
            Preconditions.checkArgument((commandIndex >= 0 ? 1 : 0) != 0, (String)"{command} not found in pattern: %s", commandPattern);
            int argsIndex = commandPattern.indexOf("{args}");
            Preconditions.checkArgument((argsIndex >= 0 ? 1 : 0) != 0, (String)"{args} not found in pattern: %s", commandPattern);
            return new CommandBuilder((String[])commandPattern.toArray(String[]::new), commandIndex, argsIndex, escapeCommandDoubleQuotesSupplier);
        }

        public String[] buildExecutableCommand(BoundCommand boundCommand) {
            ArrayList<String> executableCommand = new ArrayList<String>();
            boolean escapeCommandDoubleQuotes = this.escapeCommandDoubleQuotesSupplier.get();
            String[] command = boundCommand.command();
            for (int i = 0; i < this.pattern.length; ++i) {
                if (i == this.commandIndex) {
                    executableCommand.add(boundCommand.scriptPath().toString());
                    continue;
                }
                if (i == this.argsIndex) {
                    for (int j = 1; j < command.length; ++j) {
                        String arg = command[j];
                        if (escapeCommandDoubleQuotes) {
                            arg = arg.replace("\"", "\\\"");
                        }
                        executableCommand.add(arg);
                    }
                    continue;
                }
                executableCommand.add(this.pattern[i]);
            }
            return (String[])executableCommand.toArray(String[]::new);
        }
    }

    public record BoundCommand(Path scriptPath, String[] command, ScriptRedirect.Pair redirects) {
        String fileExtension() {
            if (this.scriptPath == null) {
                return null;
            }
            return ScriptConfig.getFileExtension(this.scriptPath.getFileName().toString());
        }
    }

    public record ExecutableCommand(String[] command, String[] environment) {
    }
}

