/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.List;

public enum ScriptRedirect {
    DEFAULT,
    CHAT,
    ECHO,
    LOG,
    NULL;


    public static Pair parseAndRemoveRedirects(List<String> commandTokens) {
        ScriptRedirect stdout = DEFAULT;
        ScriptRedirect stderr = DEFAULT;
        for (int i = 0; i < 2 && commandTokens.size() >= 3; ++i) {
            String secondLastToken = commandTokens.get(commandTokens.size() - 2);
            String lastToken = commandTokens.get(commandTokens.size() - 1);
            if (secondLastToken.equals(">")) {
                stdout = ScriptRedirect.parseValue(lastToken);
                if (stdout == DEFAULT) continue;
                commandTokens.remove(commandTokens.size() - 1);
                commandTokens.remove(commandTokens.size() - 1);
                continue;
            }
            if (!secondLastToken.equals("2>")) break;
            stderr = ScriptRedirect.parseValue(lastToken);
            if (stderr == DEFAULT) continue;
            commandTokens.remove(commandTokens.size() - 1);
            commandTokens.remove(commandTokens.size() - 1);
        }
        if (stdout == DEFAULT && stderr == DEFAULT) {
            return Pair.DEFAULTS;
        }
        return new Pair(stdout, stderr);
    }

    private static ScriptRedirect parseValue(String value) {
        switch (value) {
            case "chat": {
                return CHAT;
            }
            case "echo": {
                return ECHO;
            }
            case "log": {
                return LOG;
            }
            case "null": {
                return NULL;
            }
        }
        return DEFAULT;
    }

    public record Pair(ScriptRedirect stdout, ScriptRedirect stderr) {
        public static final Pair DEFAULTS = new Pair(DEFAULT, DEFAULT);
    }
}

