/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common.mixin;

import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minescript.common.Minescript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KeyboardHandler.class})
public class KeyboardHandlerMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"KeyboardHandlerMixin");
    private static int KEY_ACTION_DOWN = 1;
    private static int KEY_ACTION_REPEAT = 2;
    private static int KEY_ACTION_UP = 0;

    @Inject(at={@At(value="HEAD")}, method={"keyPress(JIIII)V"}, cancellable=true)
    private void keyPress(long window, int key, int scanCode, int action, int modifiers, CallbackInfo ci) {
        Minescript.onKeyboardEvent(key, scanCode, action, modifiers);
        Screen screen = Minecraft.getInstance().screen;
        if (screen == null) {
            Minescript.onKeyInput(key);
        } else if ((key == Minescript.ENTER_KEY || key == Minescript.config.secondaryEnterKeyCode()) && action == KEY_ACTION_DOWN && Minescript.onKeyboardKeyPressed(screen, key)) {
            ci.cancel();
        }
    }
}

