/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minescript.common.dataclasses.EntityData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityExporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final double positionInterpolation;
    private final boolean includeNbt;
    private final Set<String> exportedEntityUuids = new HashSet<String>();
    private final Map<String, class_1297> entitiesToExport = new HashMap<String, class_1297>();

    public EntityExporter(double positionInterpolation, boolean includeNbt) {
        this.positionInterpolation = positionInterpolation;
        this.includeNbt = includeNbt;
    }

    public EntityData[] export(Iterable<? extends class_1297> entities) {
        EntityData[] result = this.exportEntities(entities);
        this.clear();
        return result;
    }

    public EntityData export(class_1297 entity) {
        EntityData result = this.exportEntity(entity);
        this.clear();
        return result;
    }

    private void clear() {
        this.exportedEntityUuids.clear();
        this.entitiesToExport.clear();
    }

    private EntityData[] exportEntities(Iterable<? extends class_1297> entities) {
        ArrayList<EntityData> jsonEntities = new ArrayList<EntityData>();
        for (class_1297 class_12972 : entities) {
            try {
                jsonEntities.add(this.exportEntity(class_12972));
            }
            catch (DuplicateEntityException e) {
                LOGGER.error("Ignoring duplicate entity while exporting to JSON: {}", (Object)e.getMessage());
            }
        }
        for (class_1297 class_12973 : this.entitiesToExport.values()) {
            try {
                jsonEntities.add(this.exportEntity(class_12973));
            }
            catch (DuplicateEntityException e) {
                LOGGER.error("Ignoring duplicate entity while exporting to JSON: {}", (Object)e.getMessage());
            }
        }
        return (EntityData[])jsonEntities.toArray(EntityData[]::new);
    }

    private EntityData exportEntity(class_1297 entity) {
        String uuid = entity.method_5667().toString();
        if (this.exportedEntityUuids.contains(uuid)) {
            throw new DuplicateEntityException(uuid);
        }
        this.exportedEntityUuids.add(uuid);
        if (this.entitiesToExport.containsKey(uuid)) {
            this.entitiesToExport.remove(uuid);
        }
        class_310 minecraft = class_310.method_1551();
        EntityData entityData = new EntityData();
        entityData.name = entity.method_5477().getString();
        entityData.type = entity.method_5864().toString();
        entityData.uuid = uuid;
        entityData.id = entity.method_5628();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            entityData.health = Float.valueOf(livingEntity.method_6032());
        }
        if (entity == minecraft.field_1724) {
            entityData.local = true;
        }
        class_243 v = entity.method_18798();
        double x = entity.method_23317();
        double y = entity.method_23318();
        double z = entity.method_23321();
        entityData.position[0] = x;
        entityData.position[1] = y;
        entityData.position[2] = z;
        double epsilon = 1.0E-4;
        if (this.positionInterpolation > 1.0E-4 && (Math.abs(v.field_1352) > 1.0E-4 || Math.abs(v.field_1351) > 1.0E-4 || Math.abs(v.field_1350) > 1.0E-4)) {
            entityData.lerp_position = new double[]{x + v.field_1352 * this.positionInterpolation, y + v.field_1351 * this.positionInterpolation, z + v.field_1350 * this.positionInterpolation};
        }
        entityData.yaw = entity.method_36454();
        entityData.pitch = entity.method_36455();
        entityData.velocity[0] = v.field_1352;
        entityData.velocity[1] = v.field_1351;
        entityData.velocity[2] = v.field_1350;
        if (!entity.method_5685().isEmpty()) {
            ArrayList<String> jsonPassengers = new ArrayList<String>();
            for (class_1297 passenger : entity.method_5685()) {
                jsonPassengers.add(passenger.method_5667().toString());
            }
            entityData.passengers = (String[])jsonPassengers.toArray(String[]::new);
        }
        if (this.includeNbt) {
            class_2487 nbt = new class_2487();
            entityData.nbt = entity.method_5647(nbt).toString();
        }
        return entityData;
    }

    private static class DuplicateEntityException
    extends RuntimeException {
        public DuplicateEntityException(String message) {
            super(message);
        }
    }
}

