/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common.blocks;

import java.util.List;
import net.minecraft.world.level.Level;
import net.minescript.common.blocks.BlockPositionReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pyjinn.interpreter.Script;

public class BlockSequenceReader {
    private static final Logger LOGGER = LogManager.getLogger();

    public static String[] toStringArray(Level level, Object blockPositions) {
        if (blockPositions instanceof List) {
            List positions = (List)blockPositions;
            LOGGER.info("Identified getblocklist sequence type: List<?> ({})", (Object)positions.getClass().getName());
            return BlockSequenceReader.positionListToBlockStrings(level, positions);
        }
        if (blockPositions instanceof Script.Lengthable) {
            Script.Lengthable positions = (Script.Lengthable)blockPositions;
            LOGGER.info("Identified getblocklist sequence type: Script.Lengthable ({})", (Object)positions.getClass().getName());
            return BlockSequenceReader.positionLengthableToBlockStrings(level, positions);
        }
        if (blockPositions instanceof Object[]) {
            Object[] positions = (Object[])blockPositions;
            LOGGER.info("Identified getblocklist sequence type: Object[]");
            return BlockSequenceReader.positionArrayToBlockStrings(level, positions);
        }
        throw new IllegalArgumentException("`getblocklist` expected a list, tuple, or array of (x, y, z) positions but got %s".formatted(blockPositions == null ? "null" : blockPositions.getClass().getName()));
    }

    private static String[] positionListToBlockStrings(Level level, List<?> positions) {
        String[] blocks = new String[positions.size()];
        int blockIndex = -1;
        BlockPositionReader blockReader = null;
        for (Object position : positions) {
            if (++blockIndex == 0) {
                blockReader = BlockPositionReader.create(level, position);
            }
            blocks[blockIndex] = blockReader.getblock(position);
        }
        return blocks;
    }

    private static String[] positionLengthableToBlockStrings(Level level, Script.Lengthable positions) {
        String[] blocks = new String[positions.__len__()];
        int blockIndex = -1;
        BlockPositionReader blockReader = null;
        for (Object position : positions) {
            if (++blockIndex == 0) {
                blockReader = BlockPositionReader.create(level, position);
            }
            blocks[blockIndex] = blockReader.getblock(position);
        }
        return blocks;
    }

    private static String[] positionArrayToBlockStrings(Level level, Object[] positions) {
        String[] blocks = new String[positions.length];
        int blockIndex = -1;
        BlockPositionReader blockReader = null;
        for (Object position : positions) {
            if (++blockIndex == 0) {
                blockReader = BlockPositionReader.create(level, position);
            }
            blocks[blockIndex] = blockReader.getblock(position);
        }
        return blocks;
    }
}

