/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common.mixin;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minescript.common.Minescript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ClientPacketListenerMixin");

    @Inject(at={@At(value="TAIL")}, method={"handleAddEntity(Lnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;)V"}, cancellable=false)
    private void handleAddEntity(ClientboundAddEntityPacket packet, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.isSameThread()) {
            return;
        }
        ClientLevel level = minecraft.level;
        Entity entity = level.getEntity(packet.getId());
        if (entity == null) {
            LOGGER.warn("AddEntity event got null entity with ID {} at ({}, {}, {})", new Object[]{packet.getId(), packet.getX(), packet.getY(), packet.getZ()});
            return;
        }
        Minescript.onAddEntityEvent(entity);
    }

    @Inject(at={@At(value="HEAD")}, method={"handleBlockUpdate(Lnet/minecraft/network/protocol/game/ClientboundBlockUpdatePacket;)V"}, cancellable=false)
    private void handleBlockUpdate(ClientboundBlockUpdatePacket packet, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.isSameThread()) {
            return;
        }
        Minescript.onBlockUpdateEvent(packet.getPos(), packet.getBlockState());
    }

    @Inject(at={@At(value="HEAD")}, method={"handleTakeItemEntity(Lnet/minecraft/network/protocol/game/ClientboundTakeItemEntityPacket;)V"}, cancellable=false)
    private void handleTakeItemEntity(ClientboundTakeItemEntityPacket packet, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.isSameThread()) {
            return;
        }
        ClientLevel level = minecraft.level;
        Entity player = level.getEntity(packet.getPlayerId());
        if (player == null) {
            LOGGER.warn("TakeItemEntity event got null player with ID {}", (Object)packet.getPlayerId());
            return;
        }
        Entity item = level.getEntity(packet.getItemId());
        if (item == null) {
            LOGGER.warn("TakeItemEntity event got null item with ID {}", (Object)packet.getItemId());
            return;
        }
        Minescript.onTakeItemEvent(player, item, packet.getAmount());
    }

    @Inject(at={@At(value="HEAD")}, method={"handleDamageEvent(Lnet/minecraft/network/protocol/game/ClientboundDamageEventPacket;)V"}, cancellable=false)
    private void handleDamageEvent(ClientboundDamageEventPacket packet, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.isSameThread()) {
            return;
        }
        ClientLevel level = minecraft.level;
        Entity entity = level.getEntity(packet.entityId());
        if (entity == null) {
            LOGGER.warn("Damage event got null item with ID {}", (Object)packet.entityId());
            return;
        }
        Entity cause = level.getEntity(packet.sourceCauseId());
        DamageSource source = packet.getSource((Level)level);
        DamageType sourceType = source == null ? null : source.type();
        String sourceMessage = sourceType == null ? null : sourceType.msgId();
        Minescript.onDamageEvent(entity, cause, sourceMessage);
    }

    @Inject(at={@At(value="HEAD")}, method={"handleExplosion(Lnet/minecraft/network/protocol/game/ClientboundExplodePacket;)V"}, cancellable=false)
    private void handleExplosion(ClientboundExplodePacket packet, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.isSameThread()) {
            return;
        }
        Minescript.onExplosionEvent(packet.center().x, packet.center().y, packet.center().z, List.of());
    }
}

