/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minescript.common.Config;
import net.minescript.common.FilePattern;
import net.minescript.common.Job;
import net.minescript.common.JobControl;
import net.minescript.common.JobState;
import net.minescript.common.Minescript;
import net.minescript.common.ScriptConfig;
import net.minescript.common.ScriptExceptionHandler;
import net.minescript.common.ScriptValue;
import net.minescript.common.SystemMessageQueue;
import net.minescript.common.Task;
import net.minescript.common.mappings.NameMappings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pyjinn.interpreter.Script;
import org.pyjinn.parser.PyjinnParser;

public class PyjinnScript {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Script.PyjDict gameGlobalDict = new Script.PyjDict(new ConcurrentHashMap());

    private PyjinnScript() {
    }

    public static PyjinnJob createJob(int jobId, Optional<Integer> parentJobId, ScriptConfig.BoundCommand boundCommand, String scriptCode, Config config, SystemMessageQueue systemMessageQueue, NameMappings nameMappings, boolean autoExit, Runnable doneCallback) throws Exception {
        Script script = PyjinnScript.loadScript(boundCommand.command(), scriptCode, config.scriptConfig(), nameMappings);
        PyjinnJob job = new PyjinnJob(jobId, parentJobId, boundCommand, new PyjinnTask(systemMessageQueue), script, config, systemMessageQueue, autoExit, doneCallback);
        script.vars.__setitem__((Object)"job", (Object)job);
        script.vars.__setitem__((Object)"game", (Object)gameGlobalDict);
        script.redirectStdout(job::processStdout);
        script.redirectStderr(job::processStderr);
        script.atExit(job::atExit);
        return job;
    }

    public static Script loadScript(String[] argv, String scriptCode, ScriptConfig scriptConfig, NameMappings nameMappings) throws Exception {
        Object scriptFilename = argv[0].toLowerCase().endsWith(".pyj") ? argv[0] : argv[0] + ".pyj";
        MinescriptModuleHandler moduleHandler = new MinescriptModuleHandler(scriptConfig.pyjinnImportPath());
        Script script = new Script((String)scriptFilename, PyjinnScript.class.getClassLoader(), (Script.ModuleHandler)moduleHandler, nameMappings::getRuntimeClassName, nameMappings::getPrettyClassName, nameMappings::getRuntimeFieldName, nameMappings::getRuntimeMethodNames);
        script.vars.__setitem__((Object)"sys_version", (Object)Script.versionInfo().toString());
        script.vars.__setitem__((Object)"sys_argv", (Object)argv);
        script.redirectStdout(arg_0 -> PyjinnScript.lambda$loadScript$0((String)scriptFilename, arg_0));
        script.redirectStderr(arg_0 -> PyjinnScript.lambda$loadScript$1((String)scriptFilename, arg_0));
        script.setZombieCallbackHandler((zombieScriptName, callable, count) -> {
            if (count == 1 || count % 10000 == 0) {
                LOGGER.warn("[zombie callback] Invocation of {} (count: {}) defined in script that already exited: {}", (Object)callable, (Object)count, (Object)zombieScriptName);
            }
        });
        JsonElement scriptAst = PyjinnParser.parse((String)scriptFilename, (String)scriptCode);
        script.parse(scriptAst, (String)scriptFilename);
        return script;
    }

    private static /* synthetic */ void lambda$loadScript$1(String scriptFilename, String s) {
        LOGGER.info("[{} stderr] {}", (Object)scriptFilename, (Object)s);
    }

    private static /* synthetic */ void lambda$loadScript$0(String scriptFilename, String s) {
        LOGGER.info("[{} stdout] {}", (Object)scriptFilename, (Object)s);
    }

    static class PyjinnJob
    extends Job {
        private static final long ASYNC_FCALL_START_ID = 1000L;
        private final Script script;
        private final PyjinnTask task;
        private final boolean autoExit;
        private long nextFcallId = 1000L;
        private boolean isRunningScriptGlobals = false;
        private boolean hasPendingCallbacksAfterExec = false;
        private boolean handlingExit = false;

        public PyjinnJob(int jobId, Optional<Integer> parentJobId, ScriptConfig.BoundCommand command, PyjinnTask task, Script script, Config config, SystemMessageQueue systemMessageQueue, boolean autoExit, Runnable doneCallback) {
            super(jobId, parentJobId, command, task, config, systemMessageQueue, Minescript::processMessage, doneCallback);
            this.task = task;
            this.script = script;
            this.autoExit = autoExit;
        }

        Script script() {
            return this.script;
        }

        @Override
        protected void start() {
            this.setState(JobState.RUNNING);
            try {
                this.isRunningScriptGlobals = true;
                this.script.exec();
                this.isRunningScriptGlobals = false;
                this.hasPendingCallbacksAfterExec = !this.task.callbackMap.isEmpty();
            }
            catch (Exception e) {
                this.isRunningScriptGlobals = false;
                ScriptExceptionHandler.reportException(this.systemMessageQueue, e);
                this.script.exit(1);
                return;
            }
            if (this.autoExit && !this.hasPendingCallbacksAfterExec) {
                this.script.exit(0);
            }
        }

        private void atExit(Integer exitCode) {
            if (this.handlingExit) {
                return;
            }
            try {
                this.handlingExit = true;
                if (exitCode != null && exitCode != 0) {
                    if (this.parentJobId().isEmpty()) {
                        this.systemMessageQueue.logUserError(this.jobSummaryWithStatus("Exited with error code " + exitCode), new Object[0]);
                    }
                } else if (this.hasPendingCallbacksAfterExec) {
                    if (this.state() != JobState.KILLED) {
                        this.setState(JobState.DONE);
                    }
                    if (this.parentJobId().isEmpty()) {
                        this.systemMessageQueue.logUserInfo(this.toString(), new Object[0]);
                    }
                }
            }
            finally {
                this.close();
            }
        }

        @Override
        public void requestKill() {
            super.requestKill();
            this.script.exit(128);
        }

        @Override
        protected void onClose() {
        }
    }

    private static class PyjinnTask
    implements Task {
        private final Map<Long, Callback> callbackMap = new HashMap<Long, Callback>();
        private final SystemMessageQueue systemMessageQueue;

        public PyjinnTask(SystemMessageQueue systemMessageQueue) {
            this.systemMessageQueue = systemMessageQueue;
        }

        @Override
        public int run(ScriptConfig.BoundCommand command, JobControl jobControl) {
            return 0;
        }

        @Override
        public boolean sendResponse(long functionCallId, ScriptValue scriptValue, boolean finalReply) {
            Callback callback = this.callbackMap.get(functionCallId);
            if (callback == null) {
                LOGGER.error("No callback found in Pyjinn task for function call {}", (Object)functionCallId);
                return false;
            }
            try {
                callback.function.call(callback.env, new Object[]{scriptValue.get()});
            }
            catch (Exception e) {
                ScriptExceptionHandler.reportException(this.systemMessageQueue, e);
            }
            return true;
        }

        @Override
        public boolean sendException(long functionCallId, Exception exception) {
            if (exception instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)exception;
                throw runtimeException;
            }
            throw new RuntimeException(exception);
        }

        public record Callback(Script.Environment env, Script.Function function) {
        }
    }

    private record MinescriptModuleHandler(ImmutableList<FilePattern> pyjinnImportPath) implements Script.ModuleHandler
    {
        private static Path minescriptDir = Paths.get("minescript", new String[0]);

        public void onParseImport(Script.Module module, Script.Import importModules) {
            for (Script.ImportName importedModule : importModules.modules()) {
                switch (importedModule.name()) {
                    case "minescript": 
                    case "system.pyj.minescript": {
                        module.globals().set("__has_explicit_minescript_import__", (Object)true);
                        return;
                    }
                }
            }
        }

        public void onParseImport(Script.Module module, Script.ImportFrom fromModule) {
            switch (fromModule.module()) {
                case "minescript": 
                case "system.pyj.minescript": {
                    module.globals().set("__has_explicit_minescript_import__", (Object)true);
                    return;
                }
            }
        }

        public Path getModulePath(String name) {
            Path relativeImportPath = super.getModulePath(name);
            for (FilePattern dir : this.pyjinnImportPath) {
                Optional<Path> resolvedPath = FilePattern.of(minescriptDir).and(dir).and(relativeImportPath).resolvePath();
                if (!resolvedPath.isPresent()) continue;
                Path path = resolvedPath.get();
                LOGGER.info("Resolved import of {} to {}", (Object)name, (Object)path);
                return path;
            }
            throw new IllegalArgumentException("No module named '%s' (%s) found in import dirs: %s".formatted(name, relativeImportPath, this.pyjinnImportPath));
        }

        public void onExecModule(Script.Module module) {
            LOGGER.info("Running Minescript module handler for Pyjinn module: {}", (Object)module.name());
            if (module.name().equals("minescript.system.pyj.minescript")) {
                LOGGER.info("Adding built-in functions to Minescript Pyjinn module");
                module.globals().set("add_event_listener", (Object)new AddEventListener());
                module.globals().set("remove_event_listener", (Object)new RemoveEventListener());
            } else if (module.name().equals("__main__") && !((Boolean)module.globals().vars().get((Object)"__has_explicit_minescript_import__", (Object)false)).booleanValue()) {
                LOGGER.info("Adding implicit import of Minescript Pyjinn module");
                module.globals().globalStatements().add(0, new Script.ImportFrom(-1, "system.pyj.minescript", List.of(new Script.ImportName("*", Optional.empty()))));
                module.globals().set("add_event_listener", (Object)new AddEventListener());
                module.globals().set("remove_event_listener", (Object)new RemoveEventListener());
            }
        }
    }

    public static class RemoveEventListener
    implements Script.Function {
        public Object call(Script.Environment env, Object ... params) {
            this.expectNumParams(params, 1);
            Object object = params[0];
            if (object instanceof Number) {
                Number listenerNum = (Number)object;
                try {
                    Script script = (Script)env.get("__script__");
                    PyjinnJob job = (PyjinnJob)script.vars.__getitem__((Object)"job");
                    Long listenerId = listenerNum.longValue();
                    job.cancelOperation(listenerId);
                    PyjinnTask.Callback removedListener = job.task.callbackMap.remove(listenerId);
                    if (removedListener != null) {
                        if (job.autoExit && job.task.callbackMap.isEmpty() && !job.isRunningScriptGlobals) {
                            script.exit(0);
                        }
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException("Expected param to `remove_event_listener` to be java.lang.Long but got %s".formatted(params[0]));
        }
    }

    public static class AddEventListener
    implements Script.Function {
        public Object call(Script.Environment env, Object ... params) {
            Script.KeywordArgs ka;
            Object object;
            this.expectMinParams(params, 2);
            this.expectMaxParams(params, 3);
            Object object2 = params[0];
            if (!(object2 instanceof String)) {
                throw new IllegalArgumentException("Expected first param to add_event_listener to be string (event type) but got " + params[0].toString());
            }
            String eventName = (String)object2;
            if ("render".equals(eventName)) {
                eventName = "render_after_main";
            }
            if (!Minescript.eventDispatchers.containsKey(eventName) && !Minescript.RENDER_EVENT_NAME_RE.matcher(eventName).matches()) {
                throw new IllegalArgumentException("Unsupported event type: \"%s\". Must be one of: %s".formatted(eventName, Minescript.eventDispatchers.keySet().stream().map(s -> "\"" + s + "\"").sorted().collect(Collectors.joining(", "))));
            }
            Script.KeywordArgs kwargs = params.length > 2 && (object = params[2]) instanceof Script.KeywordArgs ? (ka = (Script.KeywordArgs)object) : new Script.KeywordArgs();
            try {
                Script script = (Script)env.get("__script__");
                PyjinnJob job = (PyjinnJob)script.vars.__getitem__((Object)"job");
                long listenerId = job.nextFcallId++;
                Object object3 = params[1];
                if (!(object3 instanceof Script.Function)) {
                    throw new IllegalArgumentException("Expected second param to `add_event_listener` to be callable but got %s".formatted(params[1]));
                }
                Script.Function callback = (Script.Function)object3;
                job.task.callbackMap.put(listenerId, new PyjinnTask.Callback(env, callback));
                Minescript.registerEventListener(job, listenerId, eventName, (Map<String, Object>)kwargs);
                Minescript.startEventListener(job, listenerId, eventName, listenerId);
                return listenerId;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

