/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1132;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_155;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2791;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_318;
import net.minecraft.class_338;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5219;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import net.minecraft.class_863;
import net.minecraft.class_8824;
import net.minescript.common.BlockPack;
import net.minescript.common.BlockPacker;
import net.minescript.common.ChunkLoadEventListener;
import net.minescript.common.CommandSyntax;
import net.minescript.common.Config;
import net.minescript.common.EntityExporter;
import net.minescript.common.EntitySelection;
import net.minescript.common.EventDispatcher;
import net.minescript.common.EventListener;
import net.minescript.common.Job;
import net.minescript.common.JobControl;
import net.minescript.common.JobOperationId;
import net.minescript.common.JobState;
import net.minescript.common.LevelRenderContext;
import net.minescript.common.Math3d;
import net.minescript.common.Message;
import net.minescript.common.Platform;
import net.minescript.common.PyjinnScript;
import net.minescript.common.ScriptConfig;
import net.minescript.common.ScriptExceptionHandler;
import net.minescript.common.ScriptFunctionCall;
import net.minescript.common.ScriptRedirect;
import net.minescript.common.ScriptValue;
import net.minescript.common.SubprocessTask;
import net.minescript.common.SystemMessageQueue;
import net.minescript.common.Task;
import net.minescript.common.blocks.BlockPositionReader;
import net.minescript.common.blocks.BlockRegionReader;
import net.minescript.common.blocks.BlockSequenceReader;
import net.minescript.common.dataclasses.BlockRegion;
import net.minescript.common.dataclasses.HandItems;
import net.minescript.common.dataclasses.ItemStackData;
import net.minescript.common.dataclasses.JobInfo;
import net.minescript.common.dataclasses.TargetedBlock;
import net.minescript.common.dataclasses.VersionInfo;
import net.minescript.common.dataclasses.WorldInfo;
import net.minescript.common.events.AddEntityEvent;
import net.minescript.common.events.BlockUpdateEvent;
import net.minescript.common.events.ChatEvent;
import net.minescript.common.events.ChunkEvent;
import net.minescript.common.events.DamageEvent;
import net.minescript.common.events.ExplosionEvent;
import net.minescript.common.events.KeyEvent;
import net.minescript.common.events.MouseEvent;
import net.minescript.common.events.RenderEvent;
import net.minescript.common.events.TakeItemEvent;
import net.minescript.common.events.TickEvent;
import net.minescript.common.events.WorldEvent;
import net.minescript.common.mappings.MappingsLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pyjinn.interpreter.ConstructorInvoker;
import org.pyjinn.interpreter.MethodInvoker;
import org.pyjinn.interpreter.Script;

public class Minescript {
    static final Logger LOGGER = LogManager.getLogger();
    public static Config config;
    private static final String MINESCRIPT_DIR = "minescript";
    private static Platform platform;
    private static String version;
    private static Thread worldListenerThread;
    public static MappingsLoader mappingsLoader;
    private static AtomicBoolean autorunHandled;
    private static Gson GSON;
    private static final String LEGACY_VERSION = "legacy";
    private static final ImmutableList<String> BUILTIN_COMMANDS;
    private static final ImmutableSet<String> IGNORE_DIRS_FOR_COMPLETIONS;
    private static final Pattern TILDE_RE;
    private static JobManager jobs;
    public static final SystemMessageQueue systemMessageQueue;
    private static Pattern SETBLOCK_COMMAND_RE;
    private static Pattern FILL_COMMAND_RE;
    public static final String[] EMPTY_STRING_ARRAY;
    private static long worldRenderEventCounter;
    private static long clientTickEventCounter;
    private static int BACKSLASH_KEY;
    private static int ESCAPE_KEY;
    public static int ENTER_KEY;
    private static int TAB_KEY;
    private static int BACKSPACE_KEY;
    private static int UP_ARROW_KEY;
    private static int DOWN_ARROW_KEY;
    private static List<String> commandSuggestions;
    private static LevelRenderContext levelRenderContext;
    private static long lastRenderEventWarningTimeMillis;
    private static class_342 chatEditBox;
    private static boolean reportedChatEditBoxError;
    private static final ImmutableSet<String> COMMANDS_WITH_FIRST_PARAM_COMPLETIONS;
    private static boolean loggedMethodNameFallback;
    private static Pattern CHAT_WHISPER_MESSAGE_RE;
    private static ServerBlockList serverBlockList;
    private static EventDispatcher tickEventListeners;
    private static EventDispatcher keyEventListeners;
    private static EventDispatcher mouseEventListeners;
    private static EventDispatcher chatEventListeners;
    private static EventDispatcher chatInterceptors;
    private static EventDispatcher addEntityEventListeners;
    private static EventDispatcher blockUpdateEventListeners;
    private static EventDispatcher takeItemEventListeners;
    private static EventDispatcher damageEventListeners;
    private static EventDispatcher explosionEventListeners;
    private static EventDispatcher chunkEventListeners;
    private static EventDispatcher worldListeners;
    static Map<String, EventDispatcher> eventDispatchers;
    static Pattern RENDER_EVENT_NAME_RE;
    private static Map<JobOperationId, ChunkLoadEventListener> chunkLoadEventListeners;
    private static String customNickname;
    private static final Map<String, class_3675.class_306> keyBinds;
    private static final Optional<JsonElement> OPTIONAL_JSON_NULL;
    private static final JsonElement JSON_TRUE;
    private static final Optional<JsonElement> OPTIONAL_JSON_TRUE;
    private static volatile long lastTickStartTime;

    public static void init(Platform platform) {
        File undoDir;
        String blockpacksDir;
        Minescript.platform = platform;
        LOGGER.info("Starting Minescript on OS: {}", (Object)System.getProperty("os.name"));
        if (new File(MINESCRIPT_DIR).mkdir()) {
            LOGGER.info("Created minescript dir");
        }
        if (new File(blockpacksDir = Paths.get(MINESCRIPT_DIR, "blockpacks").toString()).mkdir()) {
            LOGGER.info("Created minescript blockpacks dir");
        }
        if ((undoDir = new File(Paths.get(MINESCRIPT_DIR, "undo").toString())).exists()) {
            int numDeletedFiles = 0;
            LOGGER.info("Deleting undo files from previous run...");
            for (File undoFile : undoDir.listFiles()) {
                if (!undoFile.getName().endsWith(".txt") && !undoFile.getName().endsWith(".zip") || !undoFile.delete()) continue;
                ++numDeletedFiles;
            }
            LOGGER.info("{} undo file(s) deleted.", (Object)numDeletedFiles);
        }
        String lastRunVersion = Minescript.getLastRunVersion();
        version = Minescript.getCurrentVersion();
        if (!version.equals(lastRunVersion)) {
            LOGGER.info("Current version ({}) does not match last run version ({})", (Object)version, (Object)lastRunVersion);
            LOGGER.info("Deleting files from version `{}` of Minescript...", (Object)lastRunVersion);
            Minescript.deleteObsoleteFiles();
            LOGGER.info("Loading files for current version `{}` of Minescript from jar resources...", (Object)version);
            Minescript.loadMinescriptResources();
        }
        worldListenerThread = new Thread(Minescript::runWorldListenerThread, "minescript-world-listener");
        worldListenerThread.start();
        Path minescriptDir = Paths.get(System.getProperty("user.dir"), MINESCRIPT_DIR);
        if (System.getProperty("os.name").startsWith("Windows")) {
            Minescript.copyJarResourceToFile("windows_config.txt", minescriptDir, "config.txt", FileOverwritePolicy.DO_NOT_OVERWRITE);
        } else {
            Minescript.copyJarResourceToFile("posix_config.txt", minescriptDir, "config.txt", FileOverwritePolicy.DO_NOT_OVERWRITE);
        }
        config = new Config(MINESCRIPT_DIR, "config.txt", BUILTIN_COMMANDS, IGNORE_DIRS_FOR_COMPLETIONS);
        config.load();
        boolean isMinecraftClassObfuscated = !class_310.class.getName().equals("net.minecraft.client.Minecraft");
        mappingsLoader = new MappingsLoader(class_155.method_16673().comp_4025(), platform.modLoaderName(), isMinecraftClassObfuscated);
        try {
            mappingsLoader.load();
        }
        catch (Exception e) {
            LOGGER.error("Error loading mappings: {}", (Object)e.toString());
        }
    }

    public static void reloadMappings() throws Exception {
        mappingsLoader.load();
    }

    public static void enableDebugPyjinnLogging(boolean enable) {
        if (enable) {
            Script.setDebugLogger((message, args) -> LOGGER.info("Pyjinn debug output: " + message.formatted(args)));
        } else {
            Script.setDebugLogger((message, args) -> {});
        }
    }

    private static void deleteObsoleteFiles() {
        Path minescriptDir = Paths.get(System.getProperty("user.dir"), MINESCRIPT_DIR);
        Path systemDir = minescriptDir.resolve("system");
        Path libDir = systemDir.resolve("lib");
        Path execDir = systemDir.resolve("exec");
        Minescript.deleteMinescriptFile(minescriptDir, "version.txt");
        Minescript.deleteMinescriptFile(minescriptDir, "minescript.py");
        Minescript.deleteMinescriptFile(libDir, "minescript.pyj");
        Minescript.deleteMinescriptFile(minescriptDir, "minescript_runtime.py");
        Minescript.deleteMinescriptFile(minescriptDir, "help.py");
        Minescript.deleteMinescriptFile(minescriptDir, "copy.py");
        Minescript.deleteMinescriptFile(minescriptDir, "paste.py");
        Minescript.deleteMinescriptFile(minescriptDir, "eval.py");
        Minescript.deleteMinescriptFile(execDir, "eval.py");
    }

    private static void loadMinescriptResources() {
        Path systemDir = Paths.get(MINESCRIPT_DIR, "system");
        Path libDir = systemDir.resolve("lib");
        Path pyjDir = systemDir.resolve("pyj");
        Path execDir = systemDir.resolve("exec");
        new File(libDir.toString()).mkdirs();
        new File(pyjDir.toString()).mkdirs();
        new File(execDir.toString()).mkdirs();
        Minescript.copyJarResourceToFile("version.txt", systemDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/lib/minescript.py", libDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/lib/java.py", libDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/lib/minescript_runtime.py", libDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/pyj/minescript.py", pyjDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/pyj/sys.py", pyjDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/pyj/math.py", pyjDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/pyj/json.py", pyjDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/pyj/pathlib.py", pyjDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/pyj/atexit.py", pyjDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/exec/help.py", execDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/exec/copy_blocks.py", execDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/exec/paste.py", execDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/exec/install_mappings.pyj", execDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/exec/eval.pyj", execDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/exec/pyeval.py", execDir, FileOverwritePolicy.OVERWRITTE);
        Minescript.copyJarResourceToFile("system/exec/pyinterpreter.py", execDir, FileOverwritePolicy.OVERWRITTE);
    }

    private static void deleteMinescriptFile(Path dir, String fileName) {
        File fileToDelete = new File(dir.resolve(fileName).toString());
        if (fileToDelete.exists() && fileToDelete.delete()) {
            LOGGER.info("Deleted obsolete file: `{}`", (Object)fileToDelete.getPath());
        }
    }

    private static void cancelOrphanedOperations(Set<Integer> jobIdsToKeep, EventDispatcher eventDispatcher) {
        if (!eventDispatcher.isEmpty()) {
            LOGGER.info("Cancelling orphaned operations when exiting world (excluding jobs with 'world' event listeners): {}", eventDispatcher.entrySet().stream().filter(e -> !jobIdsToKeep.contains(((EventListener)e.getValue()).jobId())).map(e -> String.format("%s %s", ((EventListener)e.getValue()).name(), e.getKey())).collect(Collectors.toList()));
            new ArrayList<EventListener>(eventDispatcher.values()).stream().forEach(op -> {
                if (!jobIdsToKeep.contains(op.jobId())) {
                    op.cancel();
                }
            });
        }
    }

    private static void killAllJobs() {
        HashSet<Integer> jobIdsToKeep = new HashSet<Integer>(worldListeners.keySet().stream().map(key -> key.jobId()).toList());
        for (JobControl job : jobs.getMap().values()) {
            if (jobIdsToKeep.contains(job.jobId())) {
                LOGGER.info("Keeping job alive because it has a world event listener: {}", (Object)job.jobSummary());
                continue;
            }
            LOGGER.info("Killing job that has no world event listener: {}", (Object)job.jobSummary());
            job.requestKill();
        }
        for (EventDispatcher dispatcher : eventDispatchers.values()) {
            Minescript.cancelOrphanedOperations(jobIdsToKeep, dispatcher);
        }
        customNickname = null;
    }

    private static void runWorldListenerThread() {
        int millisToSleep = 1000;
        class_310 minecraft = class_310.method_1551();
        boolean noWorld = minecraft.field_1687 == null;
        while (true) {
            boolean noWorldNow;
            boolean bl = noWorldNow = minecraft.field_1687 == null;
            if (noWorld != noWorldNow) {
                if (noWorldNow) {
                    Minescript.onWorldConnectionChange(false);
                    autorunHandled.set(false);
                    LOGGER.info("Exited world");
                    Minescript.killAllJobs();
                    systemMessageQueue.clear();
                } else {
                    LOGGER.info("Entered world");
                    Minescript.onWorldConnectionChange(true);
                }
                noWorld = noWorldNow;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                systemMessageQueue.logException(e);
                continue;
            }
            break;
        }
    }

    private static void onWorldConnectionChange(boolean connected) {
        ScriptValue eventValue = null;
        for (EventListener listener : worldListeners.values()) {
            if (!listener.isActive()) continue;
            if (eventValue == null) {
                WorldEvent event = new WorldEvent();
                event.connected = connected;
                event.time = (double)System.currentTimeMillis() / 1000.0;
                eventValue = ScriptValue.of(event);
            }
            listener.respond(eventValue);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String getCurrentVersion() {
        try (InputStream in = Minescript.class.getResourceAsStream("/version.txt");){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                string = reader.readLine().strip();
            }
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Exception loading version resource: {}", (Object)e.toString());
            return "";
        }
    }

    private static String getLastRunVersion() {
        Path legacyVersionPath = Paths.get(MINESCRIPT_DIR, "version.txt");
        if (Files.exists(legacyVersionPath, new LinkOption[0])) {
            return LEGACY_VERSION;
        }
        Path versionPath = Paths.get(MINESCRIPT_DIR, "system", "version.txt");
        if (!Files.exists(versionPath, new LinkOption[0])) {
            return "";
        }
        try {
            return Files.readString(versionPath).strip();
        }
        catch (IOException e) {
            LOGGER.error("Exception loading version file: {}", (Object)e.toString());
            return "";
        }
    }

    private static void copyJarResourceToFile(String resourcePath, Path dir, FileOverwritePolicy overwritePolicy) {
        String filename = resourcePath.substring(resourcePath.lastIndexOf(47) + 1);
        Minescript.copyJarResourceToFile(resourcePath, dir, filename, overwritePolicy);
    }

    private static void copyJarResourceToFile(String resourceName, Path dir, String fileName, FileOverwritePolicy overwritePolicy) {
        Path filePath = dir.resolve(fileName);
        if (Files.exists(filePath, new LinkOption[0])) {
            switch (overwritePolicy.ordinal()) {
                case 1: {
                    try {
                        Files.delete(filePath);
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to delete file to be overwritten: {}", (Object)filePath);
                        return;
                    }
                    LOGGER.info("Deleted outdated file: {}", (Object)filePath);
                    break;
                }
                case 0: {
                    return;
                }
            }
        }
        try (InputStream in = Minescript.class.getResourceAsStream("/" + resourceName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));
             FileWriter writer = new FileWriter(filePath.toString());){
            reader.transferTo(writer);
            LOGGER.info("Copied jar resource \"{}\" to \"{}\"", (Object)resourceName, (Object)filePath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to copy jar resource \"{}\" to \"{}\"", (Object)resourceName, (Object)filePath);
        }
    }

    private static String tildeParamToNumber(String param, double playerPosition) {
        Matcher match = TILDE_RE.matcher(param);
        if (match.find()) {
            return String.valueOf((int)playerPosition + (match.group(1).equals("-") ? -1 : 1) * (match.group(2).isEmpty() ? 0 : Integer.valueOf(match.group(2))));
        }
        systemMessageQueue.logUserError("Cannot parse tilde-param: \"{}\"", param);
        return String.valueOf((int)playerPosition);
    }

    private static String[] substituteMinecraftVars(String[] originalCommand) {
        String[] command = Arrays.copyOf(originalCommand, originalCommand.length);
        class_746 player = class_310.method_1551().field_1724;
        ArrayList<Integer> tildeParamPositions = new ArrayList<Integer>();
        int consecutiveTildes = 0;
        for (int i = 0; i < command.length; ++i) {
            if (TILDE_RE.matcher(command[i]).find()) {
                ++consecutiveTildes;
                tildeParamPositions.add(i);
            } else {
                if (consecutiveTildes % 3 != 0) {
                    systemMessageQueue.logUserError("Expected number of consecutive tildes to be a multple of 3, but got {}.", consecutiveTildes);
                    break;
                }
                consecutiveTildes = 0;
            }
            if (command[i].matches(".*\\$x\\b.*")) {
                LOGGER.info("$x matched command arg[" + i + "]: \"" + command[i] + "\"");
                command[i] = command[i].replaceAll("\\$x\\b", String.valueOf(player.method_23317()));
                LOGGER.info("command arg[" + i + "] substituted: \"" + command[i] + "\"");
            }
            if (command[i].matches(".*\\$y\\b.*")) {
                LOGGER.info("$y matched command arg[" + i + "]: \"" + command[i] + "\"");
                command[i] = command[i].replaceAll("\\$y\\b", String.valueOf(player.method_23318()));
                LOGGER.info("command arg[" + i + "] substituted: \"" + command[i] + "\"");
            }
            if (!command[i].matches(".*\\$z\\b.*")) continue;
            LOGGER.info("$z matched command arg[" + i + "]: \"" + command[i] + "\"");
            command[i] = command[i].replaceAll("\\$z\\b", String.valueOf(player.method_23321()));
            LOGGER.info("command arg[" + i + "] substituted: \"" + command[i] + "\"");
        }
        if (consecutiveTildes % 3 != 0) {
            systemMessageQueue.logUserError("Expected number of consecutive tildes to be a multple of 3, but got {}.", consecutiveTildes);
            return command;
        }
        int tildeCount = 0;
        Iterator iterator = tildeParamPositions.iterator();
        while (iterator.hasNext()) {
            int tildePos = (Integer)iterator.next();
            switch (tildeCount++ % 3) {
                case 0: {
                    command[tildePos] = Minescript.tildeParamToNumber(command[tildePos], player.method_23317());
                    break;
                }
                case 1: {
                    command[tildePos] = Minescript.tildeParamToNumber(command[tildePos], player.method_23318());
                    break;
                }
                case 2: {
                    command[tildePos] = Minescript.tildeParamToNumber(command[tildePos], player.method_23321());
                }
            }
        }
        return command;
    }

    public static Script loadPyjinnScript(List<String> scriptCommand, String scriptCode) throws Exception {
        return PyjinnScript.loadScript((String[])scriptCommand.toArray(String[]::new), scriptCode, mappingsLoader.get());
    }

    private static boolean checkMinescriptDir() {
        Path minescriptDir = Paths.get(System.getProperty("user.dir"), MINESCRIPT_DIR);
        if (!Files.isDirectory(minescriptDir, new LinkOption[0])) {
            systemMessageQueue.logUserError("Minescript folder is missing. It should have been created at: {}", minescriptDir);
            return false;
        }
        return true;
    }

    private static boolean checkParamTypes(String[] command, ParamType ... types) {
        if (types.length == 0 || types[types.length - 1] != ParamType.VAR_ARGS ? command.length - 1 != types.length : command.length - 1 < types.length - 1) {
            return false;
        }
        block6: for (int i = 0; i < types.length && types[i] != ParamType.VAR_ARGS; ++i) {
            String param = command[i + 1];
            switch (types[i].ordinal()) {
                case 0: {
                    try {
                        Integer.valueOf(param);
                        continue block6;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                case 1: {
                    if (param.equals("true") || param.equals("false")) continue block6;
                    return false;
                }
            }
        }
        return true;
    }

    private static String getParamsAsString(String[] command) {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < command.length; ++i) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(CommandSyntax.quoteString(command[i]));
        }
        return result.toString();
    }

    private static void listJobs(boolean allJobs) {
        if (jobs.getMap().isEmpty()) {
            systemMessageQueue.logUserInfo("There are no jobs running.", new Object[0]);
            return;
        }
        for (JobControl job : jobs.getMap().values()) {
            if (!allJobs && !job.parentJobId().isEmpty()) continue;
            systemMessageQueue.logUserInfo(job.toString(), new Object[0]);
        }
    }

    private static void suspendJob(OptionalInt jobId) {
        if (jobId.isPresent()) {
            JobControl job = jobs.getMap().get(jobId.getAsInt());
            if (job == null) {
                systemMessageQueue.logUserError("No job with ID {}. Use \\jobs to list jobs.", jobId.getAsInt());
                return;
            }
            if (job.suspend()) {
                systemMessageQueue.logUserInfo("Job suspended: {}", job.jobSummary());
            }
        } else {
            for (JobControl job : jobs.getMap().values()) {
                if (!job.suspend()) continue;
                systemMessageQueue.logUserInfo("Job suspended: {}", job.jobSummary());
            }
        }
    }

    private static void resumeJob(OptionalInt jobId) {
        if (jobId.isPresent()) {
            JobControl job = jobs.getMap().get(jobId.getAsInt());
            if (job == null) {
                systemMessageQueue.logUserError("No job with ID {}. Use \\jobs to list jobs.", jobId.getAsInt());
                return;
            }
            if (job.resume()) {
                systemMessageQueue.logUserInfo("Job resumed: {}", job.jobSummary());
            }
        } else {
            for (JobControl job : jobs.getMap().values()) {
                if (!job.resume()) continue;
                systemMessageQueue.logUserInfo("Job resumed: {}", job.jobSummary());
            }
        }
    }

    private static void killJob(int jobId) {
        if (jobId == -1) {
            for (JobControl job : jobs.getMap().values()) {
                job.requestKill();
            }
            return;
        }
        JobControl job = jobs.getMap().get(jobId);
        if (job == null) {
            systemMessageQueue.logUserError("No job with ID {}. Use \\jobs to list jobs.", jobId);
            return;
        }
        job.requestKill();
        systemMessageQueue.logUserInfo("Removed job: {}", job.jobSummary());
    }

    private static boolean getSetblockCoords(String setblockCommand, int[] coords) {
        Matcher match = SETBLOCK_COMMAND_RE.matcher(setblockCommand);
        if (!match.find()) {
            return false;
        }
        if (setblockCommand.contains("~")) {
            systemMessageQueue.logUserInfo("Warning: /setblock commands with ~ syntax cannot be undone.", new Object[0]);
            systemMessageQueue.logUserInfo("           Use minescript.player_position() instead.", new Object[0]);
            return false;
        }
        try {
            coords[0] = Integer.valueOf(match.group(1));
            coords[1] = Integer.valueOf(match.group(2));
            coords[2] = Integer.valueOf(match.group(3));
        }
        catch (NumberFormatException e) {
            systemMessageQueue.logUserError("Error: invalid number format for /setblock coordinates: {} {} {}", match.group(1), match.group(2), match.group(3));
            return false;
        }
        return true;
    }

    private static boolean getFillCoords(String fillCommand, int[] coords) {
        Matcher match = FILL_COMMAND_RE.matcher(fillCommand);
        if (!match.find()) {
            return false;
        }
        if (fillCommand.contains("~")) {
            systemMessageQueue.logUserError("Warning: /fill commands with ~ syntax cannot be undone.", new Object[0]);
            systemMessageQueue.logUserError("           Use minescript.player_position() instead.", new Object[0]);
            return false;
        }
        coords[0] = Integer.valueOf(match.group(1));
        coords[1] = Integer.valueOf(match.group(2));
        coords[2] = Integer.valueOf(match.group(3));
        coords[3] = Integer.valueOf(match.group(4));
        coords[4] = Integer.valueOf(match.group(5));
        coords[5] = Integer.valueOf(match.group(6));
        return true;
    }

    private static void runMinescriptCommand(String commandLine) {
        try {
            if (!Minescript.checkMinescriptDir()) {
                return;
            }
            config.load();
            List<CommandSyntax.Token> tokens = CommandSyntax.parseCommand(commandLine);
            if (tokens.isEmpty()) {
                systemMessageQueue.add(Message.fromJsonFormattedText("{\"text\":\"Technoblade never dies.\",\"color\":\"dark_red\",\"bold\":true}"));
                return;
            }
            Minescript.runParsedMinescriptCommand(tokens);
        }
        catch (RuntimeException e) {
            systemMessageQueue.logException(e);
        }
    }

    private static boolean printBuiltinHelp(String command) {
        switch (command) {
            case "help": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\help [command]", new Object[0]);
                systemMessageQueue.logUserInfo("Prints documentation for the given command,", new Object[0]);
                systemMessageQueue.logUserInfo("or this documentation if no command is given.", new Object[0]);
                return true;
            }
            case "ls": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\ls", new Object[0]);
                systemMessageQueue.logUserInfo("Lists available commands.", new Object[0]);
                return true;
            }
            case "copy": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\copy ...", new Object[0]);
                systemMessageQueue.logUserInfo("Alias for the built-in `copy_blocks` script.", new Object[0]);
                return true;
            }
            case "jobs": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\jobs [all]", new Object[0]);
                systemMessageQueue.logUserInfo("Lists currently running (or suspended) script jobs.", new Object[0]);
                return true;
            }
            case "suspend": {
                systemMessageQueue.logUserInfo("{} (built-in command) (alias: `z`)", command);
                systemMessageQueue.logUserInfo("Usage: \\suspend [jobID]", new Object[0]);
                systemMessageQueue.logUserInfo("Suspends the job with the given ID, or all jobs if none given.", new Object[0]);
                return true;
            }
            case "z": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\z [jobID]", new Object[0]);
                systemMessageQueue.logUserInfo("Alias for `\\suspend [jobID]`.", new Object[0]);
                return true;
            }
            case "resume": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\resume [jobID]", new Object[0]);
                systemMessageQueue.logUserInfo("Resumes the suspended job with the given ID.", new Object[0]);
                return true;
            }
            case "killjob": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\killjob [jobID]", new Object[0]);
                systemMessageQueue.logUserInfo("Kills the job with the given ID.", new Object[0]);
                return true;
            }
            case "undo": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\undo", new Object[0]);
                systemMessageQueue.logUserInfo("Undoes the setblock and fill commands of the most recent job.", new Object[0]);
                systemMessageQueue.logUserInfo("`undo` can be run multiple times to undo multiple jobs.", new Object[0]);
                return true;
            }
            case "which": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\which [command]", new Object[0]);
                systemMessageQueue.logUserInfo("Prints the location of the given command.", new Object[0]);
                return true;
            }
            case "config": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\config [name [value]]", new Object[0]);
                systemMessageQueue.logUserInfo("`\\config`: lists all config values", new Object[0]);
                systemMessageQueue.logUserInfo("`\\config name`: echoes the value of the named variable", new Object[0]);
                systemMessageQueue.logUserInfo("`\\config name value`: sets the value of the named variable", new Object[0]);
                return true;
            }
            case "reload_mappings": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\reload_mappings", new Object[0]);
                systemMessageQueue.logUserInfo("Reloads mappings files from `minescript/mappings` dir.", new Object[0]);
                return true;
            }
            case "reload_minescript_resources": {
                systemMessageQueue.logUserInfo("{} (built-in command)", command);
                systemMessageQueue.logUserInfo("Usage: \\reload_minescript_resources", new Object[0]);
                systemMessageQueue.logUserInfo("Reloads resources from the Minescript jar to the `minescript` dir.", new Object[0]);
                return true;
            }
        }
        return false;
    }

    private static void runParsedMinescriptCommand(List<CommandSyntax.Token> tokens) {
        if (tokens.isEmpty()) {
            return;
        }
        try {
            Path commandPath;
            int semicolonPos = tokens.indexOf(CommandSyntax.Token.semicolon());
            List<CommandSyntax.Token> nextCommand = Collections.emptyList();
            if (semicolonPos != -1) {
                nextCommand = tokens.subList(semicolonPos + 1, tokens.size());
                tokens = tokens.subList(0, semicolonPos);
            }
            if (tokens.isEmpty()) {
                Minescript.runParsedMinescriptCommand(nextCommand);
                return;
            }
            List<String> tokenStrings = tokens.stream().map(CommandSyntax.Token::toString).collect(Collectors.toList());
            String[] command = Minescript.substituteMinecraftVars(tokenStrings.toArray(EMPTY_STRING_ARRAY));
            switch (command[0]) {
                case "help": {
                    if (Minescript.checkParamTypes(command, new ParamType[0])) {
                        Minescript.printBuiltinHelp("help");
                        Minescript.runParsedMinescriptCommand(nextCommand);
                        return;
                    }
                    if (!Minescript.checkParamTypes(command, ParamType.STRING)) {
                        systemMessageQueue.logUserError("Expected one param (command name), instead got `{}`", Minescript.getParamsAsString(command));
                        Minescript.runParsedMinescriptCommand(nextCommand);
                        return;
                    }
                    if (!Minescript.printBuiltinHelp(command[1])) break;
                    Minescript.runParsedMinescriptCommand(nextCommand);
                    return;
                }
                case "jobs": {
                    boolean allParam;
                    boolean noParams = Minescript.checkParamTypes(command, new ParamType[0]);
                    boolean bl = allParam = Minescript.checkParamTypes(command, ParamType.STRING) && command[1].equals("all");
                    if (noParams || allParam) {
                        Minescript.listJobs(allParam);
                    } else {
                        systemMessageQueue.logUserError("Expected no params, instead got `{}`", Minescript.getParamsAsString(command));
                    }
                    Minescript.runParsedMinescriptCommand(nextCommand);
                    return;
                }
                case "suspend": 
                case "z": {
                    if (Minescript.checkParamTypes(command, new ParamType[0])) {
                        Minescript.suspendJob(OptionalInt.empty());
                    } else if (Minescript.checkParamTypes(command, ParamType.INT)) {
                        Minescript.suspendJob(OptionalInt.of(Integer.valueOf(command[1])));
                    } else {
                        systemMessageQueue.logUserError("Expected no params or 1 param of type integer, instead got `{}`", Minescript.getParamsAsString(command));
                    }
                    Minescript.runParsedMinescriptCommand(nextCommand);
                    return;
                }
                case "resume": {
                    if (Minescript.checkParamTypes(command, new ParamType[0])) {
                        Minescript.resumeJob(OptionalInt.empty());
                    } else if (Minescript.checkParamTypes(command, ParamType.INT)) {
                        Minescript.resumeJob(OptionalInt.of(Integer.valueOf(command[1])));
                    } else {
                        systemMessageQueue.logUserError("Expected no params or 1 param of type integer, instead got `{}`", Minescript.getParamsAsString(command));
                    }
                    Minescript.runParsedMinescriptCommand(nextCommand);
                    return;
                }
                case "killjob": {
                    if (Minescript.checkParamTypes(command, ParamType.INT)) {
                        Minescript.killJob(Integer.valueOf(command[1]));
                    } else {
                        systemMessageQueue.logUserError("Expected 1 param of type integer, instead got `{}`", Minescript.getParamsAsString(command));
                    }
                    Minescript.runParsedMinescriptCommand(nextCommand);
                    return;
                }
                case "undo": {
                    if (Minescript.checkParamTypes(command, new ParamType[0])) {
                        jobs.startUndo();
                    } else {
                        systemMessageQueue.logUserError("Expected no params or 1 param of type integer, instead got `{}`", Minescript.getParamsAsString(command));
                    }
                    Minescript.runParsedMinescriptCommand(nextCommand);
                    return;
                }
                case "which": {
                    if (Minescript.checkParamTypes(command, ParamType.STRING)) {
                        String arg = command[1];
                        if (BUILTIN_COMMANDS.contains((Object)arg)) {
                            systemMessageQueue.logUserInfo("Built-in command: `{}`", arg);
                        } else {
                            Path commandPath2 = config.scriptConfig().resolveCommandPath(arg);
                            if (commandPath2 == null) {
                                systemMessageQueue.logUserInfo("Command `{}` not found.", arg);
                            } else {
                                systemMessageQueue.logUserInfo(commandPath2.toString(), new Object[0]);
                            }
                        }
                    } else {
                        systemMessageQueue.logUserError("Expected 1 param of type string, instead got `{}`", Minescript.getParamsAsString(command));
                    }
                    Minescript.runParsedMinescriptCommand(nextCommand);
                    return;
                }
                case "config": {
                    if (command.length == 1) {
                        systemMessageQueue.logUserInfo("Minescript config:", new Object[0]);
                        config.forEachValue((name, value) -> systemMessageQueue.logUserInfo("  {} = \"{}\"", name, value));
                    } else if (command.length == 2) {
                        String name2 = command[1];
                        try {
                            systemMessageQueue.logUserInfo("{} = \"{}\"", name2, config.getValue(name2));
                        }
                        catch (IllegalArgumentException e) {
                            systemMessageQueue.logUserError("{}", e.getMessage());
                        }
                    } else if (command.length == 3) {
                        String name3 = command[1];
                        String value2 = command[2];
                        int[] infoMessages = new int[1];
                        config.setValue(name3, value2, status -> {
                            if (status.success()) {
                                systemMessageQueue.logUserInfo(status.message(), new Object[0]);
                                infoMessages[0] = infoMessages[0] + 1;
                            } else {
                                systemMessageQueue.logUserError(status.message(), new Object[0]);
                            }
                        });
                        if (infoMessages[0] > 0) {
                            systemMessageQueue.logUserInfo("(Note: Config value will revert when config.txt is reloaded.)", new Object[0]);
                        }
                    } else {
                        systemMessageQueue.logUserError("Expected 2 or fewer params, instead got `{}`", Minescript.getParamsAsString(command));
                    }
                    Minescript.runParsedMinescriptCommand(nextCommand);
                    return;
                }
                case "reload_mappings": {
                    try {
                        Minescript.reloadMappings();
                        systemMessageQueue.logUserInfo("Reloaded mappings from `minescript/mappings`.", new Object[0]);
                    }
                    catch (Exception e) {
                        systemMessageQueue.logException(e);
                    }
                    Minescript.runParsedMinescriptCommand(nextCommand);
                    return;
                }
                case "reload_minescript_resources": {
                    Minescript.loadMinescriptResources();
                    systemMessageQueue.logUserInfo("Reloaded resources from Minescript jar.", new Object[0]);
                    Minescript.runParsedMinescriptCommand(nextCommand);
                    return;
                }
                case "NullPointerException": {
                    if (!config.debugOutput()) break;
                    String s = null;
                    systemMessageQueue.logUserError("Length of a null string is {}", s.length());
                }
            }
            if ("copy".equals(command[0])) {
                command[0] = "copy_blocks";
            }
            if ((commandPath = config.scriptConfig().resolveCommandPath(command[0])) == null) {
                systemMessageQueue.logUserInfo("Minescript built-in commands:", new Object[0]);
                for (String builtin : BUILTIN_COMMANDS) {
                    systemMessageQueue.logUserInfo("  {}", builtin);
                }
                systemMessageQueue.logUserInfo("", new Object[0]);
                systemMessageQueue.logUserInfo("Minescript command directories:", new Object[0]);
                Path minescriptDir = Paths.get(System.getProperty("user.dir"), MINESCRIPT_DIR);
                for (Path commandDir : config.scriptConfig().commandPath()) {
                    Path path = minescriptDir.resolve(commandDir);
                    systemMessageQueue.logUserInfo("  {}", path);
                }
                if (!command[0].equals("ls")) {
                    systemMessageQueue.logUserError("No Minescript command named \"{}\"", command[0]);
                }
                Minescript.runParsedMinescriptCommand(nextCommand);
                return;
            }
            ScriptRedirect.Pair redirects = ScriptRedirect.parseAndRemoveRedirects(tokenStrings);
            command = Minescript.substituteMinecraftVars(tokenStrings.toArray(EMPTY_STRING_ARRAY));
            ScriptConfig.BoundCommand boundCommand = new ScriptConfig.BoundCommand(commandPath, command, redirects);
            if (commandPath.getFileName().toString().toLowerCase().endsWith(".pyj")) {
                try {
                    jobs.createPyjinnJob(boundCommand, nextCommand);
                }
                catch (Exception e) {
                    systemMessageQueue.logException(e);
                }
                return;
            }
            jobs.createSubprocessJob(boundCommand, nextCommand);
        }
        catch (RuntimeException e) {
            systemMessageQueue.logException(e);
        }
    }

    private static String insertSubstring(String original, int position, String insertion) {
        return original.substring(0, position) + insertion + original.substring(position);
    }

    private static String eraseChar(String original, int position) {
        if (original.isEmpty() || position == 0) {
            return original;
        }
        Object modified = original.substring(0, position - 1);
        if (position < original.length()) {
            modified = (String)modified + original.substring(position);
        }
        return modified;
    }

    private static String longestCommonPrefix(List<String> strings) {
        if (strings.isEmpty()) {
            return "";
        }
        String longest = strings.get(0);
        block0: for (int i = 1; i < strings.size(); ++i) {
            String string = strings.get(i);
            int end = Math.min(string.length(), longest.length());
            if (end < longest.length()) {
                longest = longest.substring(0, end);
            }
            for (int j = 0; j < end; ++j) {
                if (string.charAt(j) == longest.charAt(j)) continue;
                longest = longest.substring(0, j);
                continue block0;
            }
        }
        return longest;
    }

    public static void onKeyboardEvent(int key, int scanCode, int action, int modifiers) {
        ScriptValue eventValue = null;
        for (Map.Entry<JobOperationId, EventListener> entry : keyEventListeners.entrySet()) {
            EventListener listener = entry.getValue();
            if (!listener.isActive()) continue;
            if (eventValue == null) {
                String screenName = Minescript.getScreenName().orElse(null);
                long timeMillis = System.currentTimeMillis();
                KeyEvent event = new KeyEvent();
                event.key = key;
                event.scan_code = scanCode;
                event.action = action;
                event.modifiers = modifiers;
                event.time = (double)timeMillis / 1000.0;
                event.screen = screenName;
                eventValue = ScriptValue.of(event);
            }
            if (config.debugOutput()) {
                LOGGER.info("Forwarding key event to listener {}: {}", (Object)entry.getKey(), eventValue);
            }
            listener.respond(eventValue);
        }
    }

    public static void onMouseClick(int button, int action, int modifiers, double x, double y) {
        ScriptValue eventValue = null;
        for (Map.Entry<JobOperationId, EventListener> entry : mouseEventListeners.entrySet()) {
            EventListener listener = entry.getValue();
            if (!listener.isActive()) continue;
            if (eventValue == null) {
                String screenName = Minescript.getScreenName().orElse(null);
                long timeMillis = System.currentTimeMillis();
                MouseEvent event = new MouseEvent();
                event.button = button;
                event.action = action;
                event.modifiers = modifiers;
                event.time = (double)timeMillis / 1000.0;
                event.x = x;
                event.y = y;
                event.screen = screenName;
                eventValue = ScriptValue.of(event);
            }
            if (config.debugOutput()) {
                LOGGER.info("Forwarding mouse event to listener {}: {}", (Object)entry.getKey(), eventValue);
            }
            listener.respond(eventValue);
        }
    }

    public static void onRenderBegin(LevelRenderContext context) {
        if (config.debugOutput()) {
            LOGGER.info("Begin render frame");
        }
        levelRenderContext = context;
    }

    public static void onRenderEnd() {
        levelRenderContext = null;
        if (config.debugOutput()) {
            LOGGER.info("End render frame");
        }
        if (++worldRenderEventCounter % (long)config.ticksPerCycle() == 0L) {
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            if (player != null && !jobs.getMap().isEmpty()) {
                Minescript.processMessageQueue(false, job -> job.renderQueue().poll());
            }
        }
    }

    public static void onRenderPassBegin(String pass) {
        if (levelRenderContext != null) {
            Minescript.onRender("render_before_" + pass);
            if (config.debugOutput()) {
                LOGGER.info("Begin render pass: {}", (Object)pass);
            }
        }
    }

    public static void onRenderPassEnd(String pass) {
        if (levelRenderContext != null) {
            Minescript.onRender("render_after_" + pass);
            if (config.debugOutput()) {
                LOGGER.info("End render pass: {}", (Object)pass);
            }
        }
    }

    private static void onRender(String renderEvent) {
        EventDispatcher renderEventDispatcher;
        try {
            renderEventDispatcher = Minescript.getDispatcherForEventName(renderEvent);
        }
        catch (Exception e) {
            long nowMillis = System.currentTimeMillis();
            if (nowMillis - lastRenderEventWarningTimeMillis > 60000L) {
                LOGGER.warn("Render exception (rate-limited to 1 per minute):", (Throwable)e);
                lastRenderEventWarningTimeMillis = nowMillis;
            }
            return;
        }
        ScriptValue eventValue = null;
        for (Map.Entry<JobOperationId, EventListener> entry : renderEventDispatcher.entrySet()) {
            EventListener listener = entry.getValue();
            if (!listener.isActive()) continue;
            if (eventValue == null) {
                RenderEvent event = new RenderEvent();
                event.context = levelRenderContext;
                event.time = (double)System.currentTimeMillis() / 1000.0;
                eventValue = ScriptValue.of(event);
            }
            listener.respond(eventValue);
        }
    }

    public static void setChatScreenInput(class_342 input) {
        chatEditBox = input;
    }

    private static boolean checkChatScreenInput() {
        if (chatEditBox == null) {
            if (!reportedChatEditBoxError) {
                reportedChatEditBoxError = true;
                systemMessageQueue.logUserError("Minescript internal error: Expected ChatScreen.input to be initialized by ChatScreen.init(), but it's null instead. Minescript commands sent through chat will not be interpreted as commands, and sent as normal chats instead.", new Object[0]);
            }
            return false;
        }
        return true;
    }

    private static String getCompletableCommand(String input) {
        String[] words = input.split("\\s+", -1);
        if (words.length > 1 && COMMANDS_WITH_FIRST_PARAM_COMPLETIONS.contains((Object)words[0])) {
            return words[0] + " " + words[1];
        }
        return words.length > 0 ? words[0] : "";
    }

    private static List<String> getCommandCompletions(String command) {
        try {
            if (command.equals("config") || command.startsWith("config ")) {
                return config.getConfigVariables().stream().filter(s -> s.startsWith(command)).sorted().collect(Collectors.toList());
            }
            if (command.equals("help") || command.startsWith("help ")) {
                return config.scriptConfig().findCommandPrefixMatches("").stream().sorted().map(s -> "help " + s).filter(s -> s.startsWith(command)).collect(Collectors.toList());
            }
            if (command.equals("which") || command.startsWith("which ")) {
                return config.scriptConfig().findCommandPrefixMatches("").stream().sorted().map(s -> "which " + s).filter(s -> s.startsWith(command)).collect(Collectors.toList());
            }
            List<String> completions = config.scriptConfig().findCommandPrefixMatches(command);
            completions.sort(null);
            return completions;
        }
        catch (InvalidPathException e) {
            LOGGER.warn("Exception while finding command completions: {}", (Object)e.toString());
            return new ArrayList<String>();
        }
    }

    public static boolean onKeyboardKeyPressed(class_437 screen, int key) {
        boolean cancel = false;
        if (screen != null && screen instanceof class_408) {
            if (!Minescript.checkChatScreenInput()) {
                return cancel;
            }
            if (key == UP_ARROW_KEY || key == DOWN_ARROW_KEY) {
                return cancel;
            }
            String value = chatEditBox.method_1882();
            if (!value.startsWith("\\")) {
                if (!(key != ENTER_KEY && key != config.secondaryEnterKeyCode() || value.startsWith("/") || customNickname == null && !Minescript.matchesChatInterceptor(value))) {
                    cancel = true;
                    chatEditBox.method_1852("");
                    Minescript.onClientChat(value);
                    screen.method_25419();
                }
                return cancel;
            }
            if (key == ENTER_KEY || key == config.secondaryEnterKeyCode()) {
                cancel = true;
                String text = chatEditBox.method_1882();
                chatEditBox.method_1852("");
                Minescript.onClientChat(text);
                screen.method_25419();
                return cancel;
            }
            int cursorPos = chatEditBox.method_1881();
            if (key >= 32 && key < 127) {
                String extraChar = Character.toString((char)key).toLowerCase();
                value = Minescript.insertSubstring(value, cursorPos, extraChar);
            } else if (key == BACKSPACE_KEY) {
                value = Minescript.eraseChar(value, cursorPos);
            }
            if (value.stripTrailing().length() > 0) {
                List<String> completions;
                String command = Minescript.getCompletableCommand(value.substring(1));
                if (key == TAB_KEY && !commandSuggestions.isEmpty()) {
                    cancel = true;
                    if (cursorPos == command.length() + 1) {
                        String maybeTrailingSpace = cursorPos < value.length() && value.charAt(cursorPos) == ' ' || commandSuggestions.size() > 1 || commandSuggestions.get(0).endsWith(File.separator) ? "" : " ";
                        try {
                            chatEditBox.method_1867(Minescript.longestCommonPrefix(commandSuggestions).substring(command.length()) + maybeTrailingSpace);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            systemMessageQueue.logUserError("Minescript internal error: StringIndexOutOfBoundsException from (longestCommonPrefix([\"{}\"]) = \"{}\").substring(\"{}\".length() = {})", String.join((CharSequence)"\", \"", commandSuggestions), Minescript.longestCommonPrefix(commandSuggestions), command, command.length());
                            return cancel;
                        }
                        if (commandSuggestions.size() > 1) {
                            chatEditBox.method_1868(-10557208);
                        } else {
                            chatEditBox.method_1868(-10557346);
                        }
                        commandSuggestions = new ArrayList<String>();
                        return cancel;
                    }
                }
                if ((completions = Minescript.getCommandCompletions(command)).contains(command)) {
                    chatEditBox.method_1868(-10557346);
                    commandSuggestions = new ArrayList<String>();
                } else {
                    ArrayList<String> newCommandSuggestions = new ArrayList<String>();
                    newCommandSuggestions.addAll(completions);
                    if (!newCommandSuggestions.isEmpty()) {
                        if (!newCommandSuggestions.equals(commandSuggestions)) {
                            if (key == TAB_KEY || config.incrementalCommandSuggestions()) {
                                if (key == TAB_KEY) {
                                    cancel = true;
                                }
                                systemMessageQueue.add(Message.formatAsJsonColoredText("completions:", "aqua"));
                                for (String suggestion : newCommandSuggestions) {
                                    systemMessageQueue.add(Message.formatAsJsonColoredText("  " + suggestion, "aqua"));
                                }
                            }
                            commandSuggestions = newCommandSuggestions;
                        }
                        chatEditBox.method_1868(-10557208);
                    } else {
                        chatEditBox.method_1868(-1548706);
                        commandSuggestions = new ArrayList<String>();
                    }
                }
            }
        }
        return cancel;
    }

    public static void onKeyInput(int key) {
        class_310 minecraft = class_310.method_1551();
        class_437 screen = minecraft.field_1755;
        if (screen == null && key == BACKSLASH_KEY) {
            minecraft.method_1507((class_437)new class_408(""));
        }
    }

    public static boolean onClientChatReceived(class_2561 message) {
        Matcher matcher;
        boolean cancel = false;
        String text = message.getString();
        ScriptValue eventValue = null;
        for (Map.Entry<JobOperationId, EventListener> entry : chatEventListeners.entrySet()) {
            EventListener listener = entry.getValue();
            if (!listener.isActive()) continue;
            if (eventValue == null) {
                ChatEvent event = new ChatEvent();
                event.type = "chat";
                event.message = text;
                event.time = (double)System.currentTimeMillis() / 1000.0;
                eventValue = ScriptValue.of(event);
            }
            if (config.debugOutput()) {
                LOGGER.info("Forwarding chat message to listener {}: {}", (Object)entry.getKey(), eventValue);
            }
            listener.respond(eventValue);
        }
        if (config.minescriptOnChatReceivedEvent() && (matcher = CHAT_WHISPER_MESSAGE_RE.matcher(text)).find() && matcher.group(1).startsWith("\\")) {
            String command = matcher.group(1);
            LOGGER.info("Processing command from received chat event: {}", (Object)command);
            Minescript.runMinescriptCommand(command.substring(1));
            cancel = true;
        }
        return cancel;
    }

    private static int chunkCoordToWorldCoord(int x) {
        return x >= 0 ? 16 * x : 16 * (x + 1) - 1;
    }

    private static void handleChunkEvent(int chunkX, int chunkZ, boolean loaded) {
        ScriptValue eventValue = null;
        for (EventListener handler : chunkEventListeners.values()) {
            if (!handler.isActive()) continue;
            if (eventValue == null) {
                int worldX = Minescript.chunkCoordToWorldCoord(chunkX);
                int worldZ = Minescript.chunkCoordToWorldCoord(chunkZ);
                ChunkEvent event = new ChunkEvent();
                event.loaded = loaded;
                event.x_min = worldX;
                event.z_min = worldZ;
                event.x_max = worldX + 15;
                event.z_max = worldZ + 15;
                event.time = (double)System.currentTimeMillis() / 1000.0;
                eventValue = ScriptValue.of(event);
            }
            handler.respond(eventValue);
        }
    }

    public static void onChunkLoad(class_1936 chunkLevel, class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        if (config.debugOutput()) {
            LOGGER.info("world {} chunk loaded: {} {}", (Object)chunkLevel.hashCode(), (Object)chunkX, (Object)chunkZ);
        }
        Iterator<Map.Entry<JobOperationId, ChunkLoadEventListener>> iter = chunkLoadEventListeners.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<JobOperationId, ChunkLoadEventListener> entry = iter.next();
            ChunkLoadEventListener listener = entry.getValue();
            if (!listener.onChunkLoaded(chunkLevel, chunkX, chunkZ)) continue;
            iter.remove();
        }
        Minescript.handleChunkEvent(chunkX, chunkZ, true);
    }

    public static void onChunkUnload(class_1936 chunkLevel, class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        if (config.debugOutput()) {
            LOGGER.info("world {} chunk unloaded: {} {}", (Object)chunkLevel.hashCode(), (Object)chunkX, (Object)chunkZ);
        }
        for (Map.Entry<JobOperationId, ChunkLoadEventListener> entry : chunkLoadEventListeners.entrySet()) {
            ChunkLoadEventListener listener = entry.getValue();
            listener.onChunkUnloaded(chunkLevel, chunkX, chunkZ);
        }
        Minescript.handleChunkEvent(chunkX, chunkZ, false);
    }

    private static boolean matchesChatInterceptor(String message) {
        for (EventListener interceptor : chatInterceptors.values()) {
            if (!interceptor.applies(message)) continue;
            return true;
        }
        return false;
    }

    private static boolean applyChatInterceptors(String message) {
        for (EventListener interceptor : chatInterceptors.values()) {
            if (!interceptor.applies(message)) continue;
            ChatEvent event = new ChatEvent();
            event.type = "outgoing_chat_intercept";
            event.message = message;
            event.time = (double)System.currentTimeMillis() / 1000.0;
            interceptor.respond(ScriptValue.of(event));
            return true;
        }
        return false;
    }

    public static boolean onClientChat(String message) {
        boolean cancel = false;
        class_310 minecraft = class_310.method_1551();
        if (message.startsWith("\\")) {
            minecraft.field_1705.method_1743().method_1803(message);
            LOGGER.info("Processing command from chat event: {}", (Object)message);
            Minescript.runMinescriptCommand(message.substring(1));
            cancel = true;
        } else if (!message.startsWith("/") && Minescript.applyChatInterceptors(message)) {
            cancel = true;
        } else if (customNickname != null && !message.startsWith("/")) {
            String tellrawCommand = "tellraw @a " + String.format(customNickname, message);
            systemMessageQueue.add(Message.createMinecraftCommand(tellrawCommand));
            class_338 chat = minecraft.field_1705.method_1743();
            chat.method_1803(message);
            cancel = true;
        }
        return cancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EventDispatcher getDispatcherForEventName(String eventName) throws Exception {
        EventDispatcher dispatcher = eventDispatchers.get(eventName);
        if (dispatcher == null) {
            Map<String, EventDispatcher> map = eventDispatchers;
            synchronized (map) {
                if (!RENDER_EVENT_NAME_RE.matcher(eventName).matches()) {
                    throw new IllegalArgumentException("No event named '%s'".formatted(eventName));
                }
                dispatcher = new EventDispatcher();
                eventDispatchers.put(eventName, dispatcher);
            }
        }
        return dispatcher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Optional<Predicate<Object>> getOutgoingChatInterceptFilter(Map<String, Object> listenerArgs) {
        String eventName = "outgoing_chat_intercept";
        Optional<Predicate<Object>> filter = Optional.empty();
        Object prefixArg = listenerArgs.get("prefix");
        Object patternArg = listenerArgs.get("pattern");
        if (prefixArg != null && patternArg != null) {
            throw new IllegalArgumentException("Only one of `prefix` and `pattern` can be specified");
        }
        if (prefixArg != null) {
            if (!(prefixArg instanceof String)) throw new IllegalArgumentException("Expected keyword arg `prefix` to event listener of `%s` to be string but got `%s`".formatted(eventName, prefixArg));
            String prefix = (String)prefixArg;
            return Optional.of(o -> {
                String s;
                return o instanceof String && (s = (String)o).startsWith(prefix);
            });
        }
        if (patternArg == null) return filter;
        if (!(patternArg instanceof String)) throw new IllegalArgumentException("Expected keyword arg `pattern` to event listener of `%s` to be string but got `%s`".formatted(eventName, patternArg));
        String patternString = (String)patternArg;
        Pattern pattern = Pattern.compile(patternString);
        return Optional.of(o -> {
            String s;
            return o instanceof String && pattern.matcher(s = (String)o).matches();
        });
    }

    public static void onAddEntityEvent(class_1297 entity) {
        ScriptValue eventValue = null;
        for (EventListener handler : addEntityEventListeners.values()) {
            if (!handler.isActive()) continue;
            if (eventValue == null) {
                boolean includeNbt = false;
                AddEntityEvent event = new AddEntityEvent();
                event.entity = new EntityExporter(Minescript.entityPositionInterpolation(), includeNbt).export(entity);
                event.time = (double)System.currentTimeMillis() / 1000.0;
                eventValue = ScriptValue.of(event);
            }
            handler.respond(eventValue);
        }
    }

    public static void onBlockUpdateEvent(class_2338 pos, class_2680 newState) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        ScriptValue eventValue = null;
        for (EventListener handler : blockUpdateEventListeners.values()) {
            if (!handler.isActive()) continue;
            if (eventValue == null) {
                BlockUpdateEvent event = new BlockUpdateEvent();
                event.position[0] = pos.method_10263();
                event.position[1] = pos.method_10264();
                event.position[2] = pos.method_10260();
                event.old_state = BlockPositionReader.getBlockStateString((class_1937)level, pos);
                event.new_state = BlockPositionReader.blockStateToString(newState);
                event.time = (double)System.currentTimeMillis() / 1000.0;
                eventValue = ScriptValue.of(event);
            }
            handler.respond(eventValue);
        }
    }

    public static void onTakeItemEvent(class_1297 player, class_1297 item, int amount) {
        ScriptValue eventValue = null;
        for (EventListener handler : takeItemEventListeners.values()) {
            if (!handler.isActive()) continue;
            if (eventValue == null) {
                boolean includeNbt = false;
                TakeItemEvent event = new TakeItemEvent();
                event.player_uuid = player.method_5667().toString();
                event.item = new EntityExporter(Minescript.entityPositionInterpolation(), includeNbt).export(item);
                event.amount = amount;
                event.time = (double)System.currentTimeMillis() / 1000.0;
                eventValue = ScriptValue.of(event);
            }
            handler.respond(eventValue);
        }
    }

    public static void onDamageEvent(class_1297 entity, class_1297 cause, String source) {
        ScriptValue eventValue = null;
        for (EventListener handler : damageEventListeners.values()) {
            if (!handler.isActive()) continue;
            if (eventValue == null) {
                DamageEvent event = new DamageEvent();
                event.entity_uuid = entity.method_5667().toString();
                event.cause_uuid = cause == null ? null : cause.method_5667().toString();
                event.source = source;
                event.time = (double)System.currentTimeMillis() / 1000.0;
                eventValue = ScriptValue.of(event);
            }
            handler.respond(eventValue);
        }
    }

    public static void onExplosionEvent(double x, double y, double z, List<class_2338> toExplode) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        ScriptValue eventValue = null;
        for (EventListener handler : explosionEventListeners.values()) {
            if (!handler.isActive()) continue;
            if (eventValue == null) {
                ExplosionEvent event = new ExplosionEvent();
                BlockPacker blockpacker = new BlockPacker();
                for (class_2338 pos : toExplode) {
                    String block = BlockPositionReader.getBlockStateString((class_1937)level, pos);
                    if (block == null) continue;
                    blockpacker.setblock(pos.method_10263(), pos.method_10264(), pos.method_10260(), block);
                }
                String encodedBlockpack = blockpacker.pack().toBase64EncodedString();
                event.position[0] = x;
                event.position[1] = y;
                event.position[2] = z;
                event.blockpack_base64 = encodedBlockpack;
                event.time = (double)System.currentTimeMillis() / 1000.0;
                eventValue = ScriptValue.of(event);
            }
            handler.respond(eventValue);
        }
    }

    private static boolean areCommandsAllowed() {
        class_310 minecraft = class_310.method_1551();
        class_642 serverData = minecraft.method_1558();
        return serverData == null || serverBlockList.areCommandsAllowedForServer(serverData.field_3752, serverData.field_3761);
    }

    private static void processMinecraftCommand(String command) {
        class_310 minecraft = class_310.method_1551();
        class_634 connection = minecraft.field_1724.field_3944;
        if (!Minescript.areCommandsAllowed()) {
            LOGGER.info("Minecraft command blocked for server: /{}", (Object)command);
            return;
        }
        connection.method_45730(command);
    }

    private static void processChatMessage(String message) {
        class_310 minecraft = class_310.method_1551();
        class_634 connection = minecraft.field_1724.field_3944;
        connection.method_45729(message);
    }

    private static void processPlainText(String text) {
        class_310 minecraft = class_310.method_1551();
        class_338 chat = minecraft.field_1705.method_1743();
        chat.method_1812(class_2561.method_30163((String)text));
    }

    private static void processJsonFormattedText(String text) {
        class_310 minecraft = class_310.method_1551();
        class_338 chat = minecraft.field_1705.method_1743();
        JsonElement jsonElement = JsonParser.parseString((String)text);
        class_2561 component = class_8824.field_46597.parse((DynamicOps)class_5455.field_40585.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)jsonElement).resultOrPartial(string -> LOGGER.warn("Failed to parse JSON-formatted text '{}': {}", (Object)text, string)).orElse(null);
        chat.method_1812(component);
    }

    static void processMessage(Message message) {
        switch (message.type()) {
            case MINECRAFT_COMMAND: {
                Minescript.processMinecraftCommand(message.value());
                return;
            }
            case MINESCRIPT_COMMAND: {
                LOGGER.info("Processing command: {}", (Object)message.value());
                Minescript.runMinescriptCommand(message.value());
                return;
            }
            case CHAT_MESSAGE: {
                Minescript.processChatMessage(message.value());
                return;
            }
            case PLAIN_TEXT: {
                Minescript.processPlainText(message.value());
                return;
            }
            case JSON_FORMATTED_TEXT: {
                Minescript.processJsonFormattedText(message.value());
                return;
            }
        }
    }

    public static void setKeyBind(String keyMappingName, class_3675.class_306 key) {
        LOGGER.info("Set key binding: {} -> {}", (Object)keyMappingName, (Object)key);
        keyBinds.put(keyMappingName, key);
    }

    private static void pressKeyBind(String keyMappingName, boolean pressed) {
        class_3675.class_306 key = keyBinds.get(keyMappingName);
        if (key == null) {
            throw new IllegalArgumentException(String.format("No key mapping with name `%s`; assigned values are: %s", keyMappingName, String.join((CharSequence)", ", (CharSequence[])keyBinds.keySet().toArray(String[]::new))));
        }
        if (pressed) {
            class_304.method_1416((class_3675.class_306)key, (boolean)true);
            class_304.method_1420((class_3675.class_306)key);
        } else {
            class_304.method_1416((class_3675.class_306)key, (boolean)false);
        }
    }

    private static ScriptValue doPlayerAction(String functionName, class_304 keyMapping, ScriptFunctionCall.ArgList args) {
        args.expectSize(1);
        boolean pressed = args.getBoolean(0);
        Minescript.pressKeyBind(keyMapping.method_1431(), pressed);
        return ScriptValue.TRUE;
    }

    public static String getWorldName() {
        class_310 minecraft = class_310.method_1551();
        class_642 serverData = minecraft.method_1558();
        String serverName = serverData == null ? null : serverData.field_3752;
        class_1132 server = minecraft.method_1576();
        class_5219 saveProperties = server == null ? null : server.method_27728();
        String saveName = saveProperties == null ? null : saveProperties.method_150();
        return serverName == null ? saveName : serverName;
    }

    public static Optional<String> getScreenName() {
        class_310 minecraft = class_310.method_1551();
        class_437 screen = minecraft.field_1755;
        if (screen == null) {
            return Optional.empty();
        }
        String name = screen.method_25440().getString();
        if (name.isEmpty()) {
            name = mappingsLoader.get().getPrettyClassName(screen.getClass().getName());
        }
        return Optional.of(name);
    }

    public static void processScriptFunction(Job.SubprocessJob job, String functionName, long funcCallId, List<?> parsedArgs) {
        ScriptFunctionCall funcCall = new ScriptFunctionCall(functionName, parsedArgs);
        try {
            Optional<JsonElement> response = Minescript.runExternalScriptFunction(job, funcCallId, funcCall);
            if (response.isPresent()) {
                job.respond(funcCallId, response.map(json -> ScriptValue.fromJson(json)).get(), true);
            }
            if (config.debugOutput()) {
                LOGGER.info("(debug) Script function {} `{}`: {}  ->  {}", (Object)funcCallId, (Object)functionName, parsedArgs, (Object)response.map(JsonElement::toString).orElse("<no response>"));
            }
        }
        catch (Exception e) {
            if (funcCallId == 0L) {
                job.logJobException(new RuntimeException(String.format("Exception while calling script function `%s` with args %s: %s", functionName, funcCall.args(), e.toString())));
            }
            job.raiseException(funcCallId, e);
        }
    }

    static void registerEventListener(JobControl job, long funcCallId, String eventName, Map<String, Object> listenerArgs) throws Exception {
        JobOperationId jobOpId = new JobOperationId(job.jobId(), funcCallId);
        EventDispatcher eventDispatcher = Minescript.getDispatcherForEventName(eventName);
        if (eventDispatcher.containsKey(jobOpId)) {
            throw new IllegalStateException("Failed to create event listener because function call ID '%s' is already registered for job '%s': %s".formatted(funcCallId, job.jobSummary()));
        }
        LOGGER.info("Creating `{}` listener {} for `{}` with args {}", (Object)eventName, (Object)funcCallId, (Object)job, listenerArgs);
        EventListener listener = new EventListener(job, eventName, () -> eventDispatcher.remove(jobOpId));
        eventDispatcher.addListener(jobOpId, listenerArgs, listener);
    }

    public static Object call(JobControl job, long funcCallId, String function, List<?> args) throws Exception {
        ScriptFunctionCall functionCall = new ScriptFunctionCall(function, args);
        if (Minescript.runNoReturnScriptFunction(functionCall)) {
            return null;
        }
        return Minescript.runScriptFunction(job, funcCallId, functionCall).get();
    }

    private static ScriptValue runScriptFunction(JobControl job, long funcCallId, ScriptFunctionCall functionCall) throws Exception {
        class_310 minecraft = class_310.method_1551();
        class_638 world = minecraft.field_1687;
        class_746 player = minecraft.field_1724;
        class_315 options = minecraft.field_1690;
        String functionName = functionCall.name();
        ScriptFunctionCall.ArgList args = functionCall.args();
        switch (functionName) {
            case "player_position": {
                args.expectSize(0);
                return ScriptValue.of(new Double[]{player.method_23317(), player.method_23318(), player.method_23321()});
            }
            case "player_name": {
                args.expectSize(0);
                return ScriptValue.of(player.method_5477().getString());
            }
            case "getblock": {
                args.expectSize(3);
                class_638 level = minecraft.field_1687;
                int arg0 = args.getConvertibleInt(0);
                int arg1 = args.getConvertibleInt(1);
                int arg2 = args.getConvertibleInt(2);
                String block = BlockPositionReader.getBlockStateString((class_1937)level, new class_2338(arg0, arg1, arg2));
                if (block != null) {
                    return ScriptValue.of(block);
                }
                return ScriptValue.NULL;
            }
            case "getblocklist": {
                args.expectSize(1);
                return ScriptValue.of(BlockSequenceReader.toStringArray((class_1937)minecraft.field_1687, args.get(0)));
            }
            case "get_block_region": {
                args.expectArgs("min_pos", "max_pos", "safety_limit");
                List<Integer> pos1 = args.getIntListWithSize(0, 3);
                List<Integer> pos2 = args.getIntListWithSize(1, 3);
                boolean safetyLimit = args.getBoolean(2);
                int numBlocks = (Math.abs(pos1.get(0) - pos2.get(0)) + 1) * (Math.abs(pos1.get(1) - pos2.get(1)) + 1) * (Math.abs(pos1.get(2) - pos2.get(2)) + 1);
                String[] blocks = new String[numBlocks];
                BlockRegionReader blockReader = BlockRegionReader.withBounds(pos1.get(0), pos1.get(1), pos1.get(2), pos2.get(0), pos2.get(1), pos2.get(2), safetyLimit);
                blockReader.readBlocks(new BlockRegionConsumer(blocks));
                BlockRegion blockRegion = new BlockRegion();
                blockRegion.min_pos = new int[]{blockReader.xMin(), blockReader.yMin(), blockReader.zMin()};
                blockRegion.max_pos = new int[]{blockReader.xMax(), blockReader.yMax(), blockReader.zMax()};
                blockRegion.blocks = blocks;
                return ScriptValue.of(blockRegion);
            }
            case "unregister_event_handler": {
                args.expectArgs("handler_id");
                long handlerId = args.getStrictLong(0);
                return ScriptValue.of(job.cancelOperation(handlerId));
            }
            case "set_nickname": {
                args.expectSize(1);
                if (args.get(0) == null) {
                    systemMessageQueue.logUserInfo("Chat nickname reset to default; was {}", customNickname == null ? "default already" : CommandSyntax.quoteString(customNickname));
                    customNickname = null;
                } else {
                    String arg = args.get(0).toString();
                    if (!arg.contains("%s")) {
                        throw new IllegalArgumentException("Expected nickname to contain %s as a placeholder for message text but got: " + arg);
                    }
                    systemMessageQueue.logUserInfo("Chat nickname set to {}.", CommandSyntax.quoteString(arg));
                    customNickname = arg;
                }
                return ScriptValue.TRUE;
            }
            case "player_hand_items": {
                args.expectSize(0);
                HandItems handItems = new HandItems();
                handItems.main_hand = ItemStackData.of(player.method_6047(), OptionalInt.empty(), false);
                handItems.off_hand = ItemStackData.of(player.method_6079(), OptionalInt.empty(), false);
                return ScriptValue.of(handItems);
            }
            case "player_inventory": {
                args.expectSize(0);
                class_1661 inventory = player.method_31548();
                ArrayList<ItemStackData> result = new ArrayList<ItemStackData>();
                int selectedSlot = inventory.method_67532();
                for (int i2 = 0; i2 < inventory.method_5439(); ++i2) {
                    class_1799 itemStack = inventory.method_5438(i2);
                    if (itemStack.method_7947() <= 0) continue;
                    result.add(ItemStackData.of(itemStack, OptionalInt.of(i2), i2 == selectedSlot));
                }
                return ScriptValue.of((ItemStackData[])result.toArray(ItemStackData[]::new));
            }
            case "player_inventory_slot_to_hotbar": {
                throw new UnsupportedOperationException("player_inventory_slot_to_hotbar: support for ServerboundPickItemPacket removed in Minecraft 1.21.4");
            }
            case "player_inventory_select_slot": {
                args.expectSize(1);
                int slot = args.getStrictInt(0);
                class_1661 inventory = player.method_31548();
                int previouslySelectedSlot = inventory.method_67532();
                inventory.method_61496(slot);
                return ScriptValue.of(previouslySelectedSlot);
            }
            case "press_key_bind": {
                args.expectSize(2);
                Minescript.pressKeyBind(args.getString(0), args.getBoolean(1));
                return ScriptValue.TRUE;
            }
            case "player_press_forward": {
                return Minescript.doPlayerAction(functionName, options.field_1894, args);
            }
            case "player_press_backward": {
                return Minescript.doPlayerAction(functionName, options.field_1881, args);
            }
            case "player_press_left": {
                return Minescript.doPlayerAction(functionName, options.field_1913, args);
            }
            case "player_press_right": {
                return Minescript.doPlayerAction(functionName, options.field_1849, args);
            }
            case "player_press_jump": {
                return Minescript.doPlayerAction(functionName, options.field_1903, args);
            }
            case "player_press_sprint": {
                return Minescript.doPlayerAction(functionName, options.field_1867, args);
            }
            case "player_press_sneak": {
                return Minescript.doPlayerAction(functionName, options.field_1832, args);
            }
            case "player_press_pick_item": {
                return Minescript.doPlayerAction(functionName, options.field_1871, args);
            }
            case "player_press_use": {
                return Minescript.doPlayerAction(functionName, options.field_1904, args);
            }
            case "player_press_attack": {
                return Minescript.doPlayerAction(functionName, options.field_1886, args);
            }
            case "player_press_swap_hands": {
                return Minescript.doPlayerAction(functionName, options.field_1831, args);
            }
            case "player_press_drop": {
                return Minescript.doPlayerAction(functionName, options.field_1869, args);
            }
            case "player_orientation": {
                args.expectSize(0);
                return ScriptValue.of(new Float[]{Float.valueOf(player.method_36454()), Float.valueOf(player.method_36455())});
            }
            case "player_set_orientation": {
                args.expectSize(2);
                Double yaw = args.getDouble(0);
                Double pitch = args.getDouble(1);
                player.method_36456(yaw.floatValue() % 360.0f);
                player.method_36457(pitch.floatValue() % 360.0f);
                return ScriptValue.TRUE;
            }
            case "player_get_targeted_block": {
                args.expectSize(1);
                double maxDistance = args.getDouble(0);
                class_1297 entity = minecraft.method_1560();
                class_239 blockHit = entity.method_5745(maxDistance, 0.0f, false);
                if (blockHit.method_17783() == class_239.class_240.field_1332) {
                    class_3965 hitResult = (class_3965)blockHit;
                    class_2338 blockPos = hitResult.method_17777();
                    double playerDistance = Math3d.computeDistance(player.method_23317(), player.method_23318(), player.method_23321(), blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
                    class_638 level = minecraft.field_1687;
                    String block = BlockPositionReader.getBlockStateString((class_1937)level, blockPos);
                    TargetedBlock targetedBlock = new TargetedBlock();
                    targetedBlock.position[0] = blockPos.method_10263();
                    targetedBlock.position[1] = blockPos.method_10264();
                    targetedBlock.position[2] = blockPos.method_10260();
                    targetedBlock.distance = playerDistance;
                    targetedBlock.side = hitResult.method_17780().toString();
                    targetedBlock.type = block;
                    return ScriptValue.of(targetedBlock);
                }
                return ScriptValue.NULL;
            }
            case "player_get_targeted_entity": {
                args.expectArgs("max_distance", "nbt");
                double maxDistance = args.getDouble(0);
                boolean includeNbt = args.getBoolean(1);
                return class_863.method_23101((class_1297)player, (int)((int)maxDistance)).map(e -> new EntityExporter(Minescript.entityPositionInterpolation(), includeNbt).export((class_1297)e)).map(e -> ScriptValue.of(e)).orElse(ScriptValue.NULL);
            }
            case "player_health": {
                return ScriptValue.of(Float.valueOf(player.method_6032()));
            }
            case "player": {
                args.expectArgs("nbt");
                boolean includeNbt = args.getBoolean(0);
                return ScriptValue.of(new EntityExporter(Minescript.entityPositionInterpolation(), includeNbt).export((class_1297)player));
            }
            case "players": {
                args.expectArgs("nbt", "uuid", "name", "position", "offset", "min_distance", "max_distance", "sort", "limit");
                boolean includeNbt = args.getBoolean(0);
                Optional<String> uuid = args.getOptionalString(1);
                Optional<String> name = args.getOptionalString(2);
                Optional<String> type = Optional.empty();
                Optional<List<Double>> position = args.getOptionalDoubleListWithSize(3, 3);
                Optional<List<Double>> offset = args.getOptionalDoubleListWithSize(4, 3);
                OptionalDouble minDistance = args.getOptionalDouble(5);
                OptionalDouble maxDistance = args.getOptionalDouble(6);
                Optional<EntitySelection.SortType> sort = args.getOptionalString(7).map(String::toUpperCase).map(EntitySelection.SortType::valueOf);
                OptionalInt limit = args.getOptionalStrictInt(8);
                return ScriptValue.of(new EntityExporter(Minescript.entityPositionInterpolation(), includeNbt).export(new EntitySelection(uuid, name, type, position, offset, minDistance, maxDistance, sort, limit).selectFrom(world.method_18456())));
            }
            case "entities": {
                args.expectArgs("nbt", "uuid", "name", "type", "position", "offset", "min_distance", "max_distance", "sort", "limit");
                boolean includeNbt = args.getBoolean(0);
                Optional<String> uuid = args.getOptionalString(1);
                Optional<String> name = args.getOptionalString(2);
                Optional<String> type = args.getOptionalString(3);
                Optional<List<Double>> position = args.getOptionalDoubleListWithSize(4, 3);
                Optional<List<Double>> offset = args.getOptionalDoubleListWithSize(5, 3);
                OptionalDouble minDistance = args.getOptionalDouble(6);
                OptionalDouble maxDistance = args.getOptionalDouble(7);
                Optional<EntitySelection.SortType> sort = args.getOptionalString(8).map(String::toUpperCase).map(EntitySelection.SortType::valueOf);
                OptionalInt limit = args.getOptionalStrictInt(9);
                return ScriptValue.of(new EntityExporter(Minescript.entityPositionInterpolation(), includeNbt).export(new EntitySelection(uuid, name, type, position, offset, minDistance, maxDistance, sort, limit).selectFrom(world.method_18112())));
            }
            case "version_info": {
                args.expectSize(0);
                VersionInfo result = new VersionInfo();
                result.minecraft = class_155.method_16673().comp_4025();
                result.minescript = version;
                result.mod_loader = platform.modLoaderName();
                result.launcher = minecraft.method_1515();
                result.os_name = System.getProperty("os.name");
                result.os_version = System.getProperty("os.version");
                result.minecraft_class_name = class_310.class.getName();
                result.pyjinn = Script.versionInfo().toString();
                return ScriptValue.of(result);
            }
            case "world_info": {
                args.expectSize(0);
                class_638.class_5271 levelProperties = world.method_28104();
                class_1267 difficulty = levelProperties.method_207();
                class_642 serverData = minecraft.method_1558();
                String serverAddress = serverData == null ? "localhost" : serverData.field_3761;
                WorldInfo result = new WorldInfo();
                result.game_ticks = levelProperties.method_188();
                result.day_ticks = levelProperties.method_217();
                result.raining = levelProperties.method_156();
                result.thundering = levelProperties.method_203();
                class_2338 spawnPos = levelProperties.method_56126();
                result.spawn[0] = spawnPos.method_10263();
                result.spawn[1] = spawnPos.method_10264();
                result.spawn[2] = spawnPos.method_10260();
                result.hardcore = levelProperties.method_152();
                result.difficulty = difficulty.method_15434();
                result.name = Minescript.getWorldName();
                result.address = serverAddress;
                return ScriptValue.of(result);
            }
            case "screenshot": {
                Object filename;
                args.expectArgs("filename");
                Object object = filename = args.get(0) == null ? null : args.getString(0);
                if (filename != null) {
                    if (((String)filename).contains(File.separator)) {
                        throw new IllegalArgumentException(String.format("`screenshot` does not support filenames with `%s` character.", File.separator));
                    }
                    int length = ((String)filename).length();
                    if (length > 4 && !((String)filename).substring(length - 4).toLowerCase().equals(".png")) {
                        filename = (String)filename + ".png";
                    }
                }
                class_318.method_22690((File)minecraft.field_1697, (String)filename, (class_276)minecraft.method_1522(), (int)1, message -> job.log(message.getString(), new Object[0]));
                return ScriptValue.TRUE;
            }
            case "screen_name": {
                if (!args.isEmpty()) {
                    throw new IllegalArgumentException("Expected no params but got: " + args.toString());
                }
                return Minescript.getScreenName().map(ScriptValue::of).orElse(ScriptValue.NULL);
            }
            case "container_get_items": {
                if (!args.isEmpty()) {
                    throw new IllegalArgumentException("Expected no params but got: " + args.toString());
                }
                class_437 screen = minecraft.field_1755;
                if (screen instanceof class_465) {
                    class_465 handledScreen = (class_465)screen;
                    class_1703 screenHandler = handledScreen.method_17577();
                    class_1735[] slots = (class_1735[])screenHandler.field_7761.toArray((Object[])new class_1735[0]);
                    ArrayList<ItemStackData> result = new ArrayList<ItemStackData>();
                    for (class_1735 slot : slots) {
                        class_1799 itemStack = slot.method_7677();
                        if (itemStack.method_7960()) continue;
                        result.add(ItemStackData.of(itemStack, OptionalInt.of(slot.field_7874), false));
                    }
                    return ScriptValue.of((ItemStackData[])result.toArray(ItemStackData[]::new));
                }
                return ScriptValue.NULL;
            }
            case "player_look_at": {
                args.expectSize(3);
                double x = args.getDouble(0);
                double y = args.getDouble(1);
                double z = args.getDouble(2);
                player.method_5702(class_2183.class_2184.field_9851, new class_243(x, y, z));
                return ScriptValue.TRUE;
            }
            case "show_chat_screen": {
                ScriptValue result;
                args.expectSize(2);
                boolean show = args.getBoolean(0);
                class_437 screen = minecraft.field_1755;
                if (show) {
                    Object prompt;
                    if (screen == null) {
                        minecraft.method_1507((class_437)new class_408(""));
                    }
                    if ((prompt = args.get(1)) != null && Minescript.checkChatScreenInput()) {
                        chatEditBox.method_1852(prompt.toString());
                    }
                    result = ScriptValue.TRUE;
                } else if (screen != null && screen instanceof class_408) {
                    screen.method_25419();
                    result = ScriptValue.TRUE;
                } else {
                    result = ScriptValue.FALSE;
                }
                return result;
            }
            case "job_info": {
                args.expectSize(0);
                ArrayList result = new ArrayList();
                jobs.getMap().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).forEach(j -> {
                    Path path = j.boundCommand().scriptPath();
                    result.add(new JobInfo(j.jobId(), j.boundCommand().command(), path == null ? null : path.toString(), j.state().name(), j.parentJobId().orElse(null), j == job));
                });
                return ScriptValue.ofNullables((JobInfo[])result.toArray(JobInfo[]::new));
            }
            case "append_chat_history": {
                args.expectSize(1);
                minecraft.field_1705.method_1743().method_1803(args.getString(0));
                return ScriptValue.NULL;
            }
            case "chat_input": {
                args.expectSize(0);
                return ScriptValue.of(new Object[]{chatEditBox.method_1882(), chatEditBox.method_1881()});
            }
            case "set_chat_input": {
                args.expectSize(3);
                args.getOptionalString(0).ifPresent(arg_0 -> ((class_342)chatEditBox).method_1852(arg_0));
                args.getOptionalStrictInt(1).ifPresent(arg_0 -> ((class_342)chatEditBox).method_1875(arg_0));
                args.getOptionalStrictInt(2).ifPresent(i -> {
                    if ((i & 0xFF000000) == 0) {
                        i |= 0xFF000000;
                    }
                    chatEditBox.method_1868(i);
                });
                return ScriptValue.NULL;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown function `%s` called from job: %s", functionName, job.jobSummary()));
    }

    private static boolean runNoReturnScriptFunction(ScriptFunctionCall functionCall) {
        String functionName = functionCall.name();
        ScriptFunctionCall.ArgList args = functionCall.args();
        switch (functionName) {
            case "execute": {
                args.expectArgs("command");
                String command = args.getString(0);
                if (command.startsWith("\\")) {
                    Minescript.runMinescriptCommand(command.substring(1));
                } else {
                    Minescript.processMinecraftCommand(command.startsWith("/") ? command.substring(1) : command);
                }
                return true;
            }
            case "echo_json": {
                args.expectArgs("json_text");
                String message = args.getString(0);
                Minescript.processJsonFormattedText(message);
                return true;
            }
            case "echo": {
                String message;
                try {
                    args.expectSize(1);
                    message = args.getString(0);
                }
                catch (IllegalArgumentException e) {
                    message = String.join((CharSequence)" ", (CharSequence[])args.rawArgs().stream().map(Object::toString).collect(Collectors.toList()).toArray(String[]::new));
                }
                Minescript.processPlainText(message);
                return true;
            }
            case "chat": {
                char firstLetter;
                Object message;
                try {
                    args.expectSize(1);
                    message = args.getString(0);
                }
                catch (IllegalArgumentException e) {
                    message = String.join((CharSequence)" ", (CharSequence[])args.rawArgs().stream().map(Object::toString).collect(Collectors.toList()).toArray(String[]::new));
                }
                if (((String)message).length() > 0 && ((firstLetter = ((String)message).charAt(0)) == '\\' || firstLetter == '/')) {
                    message = " " + (String)message;
                }
                Minescript.processChatMessage((String)message);
                return true;
            }
            case "log": {
                String message;
                try {
                    args.expectSize(1);
                    message = args.getString(0);
                }
                catch (IllegalArgumentException e) {
                    message = String.join((CharSequence)" ", (CharSequence[])args.rawArgs().stream().map(Object::toString).collect(Collectors.toList()).toArray(String[]::new));
                }
                LOGGER.info(message);
                return true;
            }
        }
        return false;
    }

    static void startEventListener(JobControl job, long funcCallId, String eventName, long listenerId) throws Exception {
        JobOperationId jobOpId;
        EventDispatcher eventDispatcher = Minescript.getDispatcherForEventName(eventName);
        EventListener listener = eventDispatcher.get(jobOpId = new JobOperationId(job.jobId(), listenerId));
        if (listener == null) {
            throw new IllegalStateException("No %s listener found with requested ID: %s".formatted(eventName, jobOpId.toString()));
        }
        job.addOperation(listenerId, listener);
        listener.start(funcCallId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Optional<JsonElement> runExternalScriptFunction(Job.SubprocessJob job, long funcCallId, ScriptFunctionCall functionCall) throws Exception {
        String functionName = functionCall.name();
        ScriptFunctionCall.ArgList args = functionCall.args();
        switch (functionName) {
            case "register_event_listener": {
                args.expectArgs("event_name", "kwargs");
                String eventName = args.getString(0);
                Map<String, Object> kwargs = args.getStringKeyMap(1);
                Minescript.registerEventListener(job, funcCallId, eventName, kwargs);
                return Optional.of(new JsonPrimitive((Number)funcCallId));
            }
            case "start_event_listener": {
                args.expectArgs("event_name", "listener_id");
                String eventName = args.getString(0);
                long listenerId = args.getStrictLong(1);
                Minescript.startEventListener(job, funcCallId, eventName, listenerId);
                return Optional.empty();
            }
            case "blockpack_read_world": {
                args.expectSize(6);
                List<Integer> pos1 = args.getIntListWithSize(0, 3);
                List<Integer> pos2 = args.getIntListWithSize(1, 3);
                int[] rotation = null;
                if (args.get(2) != null) {
                    rotation = args.getIntListWithSize(2, 9).stream().mapToInt(Integer::intValue).toArray();
                }
                int[] offset = null;
                if (args.get(3) != null) {
                    offset = args.getIntListWithSize(3, 3).stream().mapToInt(Integer::intValue).toArray();
                }
                Map<String, String> comments = args.getConvertibleStringMap(4);
                boolean safetyLimit = args.getBoolean(5);
                BlockPacker blockpacker = new BlockPacker();
                final BlockPack.TransformedBlockConsumer blockConsumer = new BlockPack.TransformedBlockConsumer(rotation, offset, blockpacker);
                BlockRegionReader blockReader = BlockRegionReader.withBounds(pos1.get(0), pos1.get(1), pos1.get(2), pos2.get(0), pos2.get(1), pos2.get(2), safetyLimit);
                blockReader.readBlocks(new BlockRegionReader.BlockConsumer(){

                    @Override
                    public void setblock(int x, int y, int z, String block) {
                        blockConsumer.setblock(x, y, z, block);
                    }

                    @Override
                    public void setAir(int x, int y, int z) {
                    }

                    @Override
                    public void reportBlockError(int x, int y, int z, String error) {
                        systemMessageQueue.logUserError(error, new Object[0]);
                    }
                });
                blockpacker.comments().putAll(comments);
                BlockPack blockpack = blockpacker.pack();
                long key = job.blockpacks.retain(blockpack);
                return Optional.of(new JsonPrimitive((Number)key));
            }
            case "blockpack_read_file": {
                args.expectSize(1);
                String blockpackFilename = args.getString(0);
                BlockPack blockpack = BlockPack.readZipFile(blockpackFilename);
                long key = job.blockpacks.retain(blockpack);
                return Optional.of(new JsonPrimitive((Number)key));
            }
            case "blockpack_import_data": {
                args.expectSize(1);
                String base64Data = args.getString(0);
                BlockPack blockpack = BlockPack.fromBase64EncodedString(base64Data);
                long key = job.blockpacks.retain(blockpack);
                return Optional.of(new JsonPrimitive((Number)key));
            }
            case "blockpack_block_bounds": {
                args.expectSize(1);
                long blockpackId = args.getStrictLong(0);
                BlockPack blockpack = job.blockpacks.getById(blockpackId);
                if (blockpack == null) {
                    throw new IllegalStateException(String.format("`%s` failed to find BlockPack[%d]", functionName, blockpackId));
                }
                int[] bounds = blockpack.blockBounds();
                JsonArray minBound = new JsonArray();
                minBound.add((Number)bounds[0]);
                minBound.add((Number)bounds[1]);
                minBound.add((Number)bounds[2]);
                JsonArray maxBound = new JsonArray();
                maxBound.add((Number)bounds[3]);
                maxBound.add((Number)bounds[4]);
                maxBound.add((Number)bounds[5]);
                JsonArray result = new JsonArray();
                result.add((JsonElement)minBound);
                result.add((JsonElement)maxBound);
                return Optional.of(result);
            }
            case "blockpack_comments": {
                args.expectSize(1);
                long blockpackId = args.getStrictLong(0);
                BlockPack blockpack = job.blockpacks.getById(blockpackId);
                if (blockpack != null) return Optional.of(GSON.toJsonTree(blockpack.comments()));
                throw new IllegalStateException(String.format("`%s` Failed to find BlockPack[%d]", functionName, blockpackId));
            }
            case "blockpack_write_world": {
                BlockPack blockpack;
                args.expectSize(3);
                long blockpackId = args.getStrictLong(0);
                int[] rotation = null;
                if (args.get(1) != null) {
                    rotation = args.getIntListWithSize(1, 9).stream().mapToInt(Integer::intValue).toArray();
                }
                int[] offset = null;
                if (args.get(2) != null) {
                    offset = args.getIntListWithSize(2, 3).stream().mapToInt(Integer::intValue).toArray();
                }
                if ((blockpack = job.blockpacks.getById(blockpackId)) == null) {
                    throw new IllegalStateException(String.format("`%s` failed to find BlockPack[%d] to write to world", functionName, blockpackId));
                }
                blockpack.getBlockCommands(rotation, offset, s -> job.tickQueue().add(Message.createMinecraftCommand(s)));
                return OPTIONAL_JSON_TRUE;
            }
            case "blockpack_write_file": {
                args.expectSize(2);
                long blockpackId = args.getStrictLong(0);
                String blockpackFilename = args.getString(1);
                BlockPack blockpack = job.blockpacks.getById(blockpackId);
                if (blockpack == null) {
                    throw new IllegalStateException(String.format("`%s` failed to find BlockPack[%d] to write to file `%s`", functionName, blockpackId, blockpackFilename));
                }
                blockpack.writeZipFile(blockpackFilename);
                return OPTIONAL_JSON_TRUE;
            }
            case "blockpack_export_data": {
                args.expectSize(1);
                long blockpackId = args.getStrictLong(0);
                BlockPack blockpack = job.blockpacks.getById(blockpackId);
                if (blockpack != null) return Optional.of(new JsonPrimitive(blockpack.toBase64EncodedString()));
                throw new IllegalStateException(String.format("`%s` failed to find BlockPack[%d] from which to export data", functionName, blockpackId));
            }
            case "blockpack_delete": {
                args.expectSize(1);
                long blockpackId = args.getStrictLong(0);
                BlockPack blockpack = job.blockpacks.releaseById(blockpackId);
                if (blockpack != null) return OPTIONAL_JSON_TRUE;
                throw new IllegalStateException(String.format("`%s` failed to find BlockPack[%d] to delete", functionName, blockpackId));
            }
            case "blockpacker_create": {
                return Optional.of(new JsonPrimitive((Number)job.blockpackers.retain(new BlockPacker())));
            }
            case "blockpacker_add_blocks": {
                args.expectSize(5);
                long blockpackerId = args.getStrictLong(0);
                List<Integer> basePos = args.getIntListWithSize(1, 3);
                String setblocksBase64 = args.getString(2);
                String fillsBase64 = args.getString(3);
                List<String> blocks = args.getConvertibleStringList(4);
                BlockPacker blockpacker = job.blockpackers.getById(blockpackerId);
                if (blockpacker == null) {
                    throw new IllegalStateException(String.format("`%s` failed to find BlockPacker[%d]", functionName, blockpackerId));
                }
                blockpacker.addBlocks((int)basePos.get(0), (int)basePos.get(1), (int)basePos.get(2), setblocksBase64, fillsBase64, blocks);
                return OPTIONAL_JSON_TRUE;
            }
            case "blockpacker_add_blockpack": {
                BlockPacker blockpacker;
                args.expectSize(4);
                long blockpackerId = args.getStrictLong(0);
                long blockpackId = args.getStrictLong(1);
                int[] rotation = null;
                if (args.get(2) != null) {
                    rotation = args.getIntListWithSize(2, 9).stream().mapToInt(Integer::intValue).toArray();
                }
                int[] offset = null;
                if (args.get(3) != null) {
                    offset = args.getIntListWithSize(3, 3).stream().mapToInt(Integer::intValue).toArray();
                }
                if ((blockpacker = job.blockpackers.getById(blockpackerId)) == null) {
                    throw new IllegalStateException(String.format("`%s` failed to find BlockPacker[%d]", functionName, blockpackerId));
                }
                BlockPack blockpack = job.blockpacks.getById(blockpackId);
                if (blockpack == null) {
                    throw new IllegalStateException(String.format("`%s` failed to find BlockPack[%d]", functionName, blockpackId));
                }
                blockpack.getBlocks(new BlockPack.TransformedBlockConsumer(rotation, offset, blockpacker));
                return OPTIONAL_JSON_TRUE;
            }
            case "blockpacker_pack": {
                args.expectSize(2);
                long blockpackerId = args.getStrictLong(0);
                Map<String, String> comments = args.getConvertibleStringMap(1);
                BlockPacker blockpacker = job.blockpackers.getById(blockpackerId);
                if (blockpacker == null) {
                    throw new IllegalStateException(String.format("`%s` failed to find BlockPacker[%d]", functionName, blockpackerId));
                }
                blockpacker.comments().putAll(comments);
                return Optional.of(new JsonPrimitive((Number)job.blockpacks.retain(blockpacker.pack())));
            }
            case "blockpacker_delete": {
                args.expectSize(1);
                long blockpackerId = args.getStrictLong(0);
                BlockPacker blockpacker = job.blockpackers.releaseById(blockpackerId);
                if (blockpacker != null) return OPTIONAL_JSON_TRUE;
                throw new IllegalStateException(String.format("`%s` failed to find BlockPacker[%d]", functionName, blockpackerId));
            }
            case "await_loaded_region": {
                args.expectSize(4);
                int arg0 = args.getStrictInt(0);
                int arg1 = args.getStrictInt(1);
                int arg2 = args.getStrictInt(2);
                int arg3 = args.getStrictInt(3);
                JobOperationId jobOpId = new JobOperationId(job.jobId(), funcCallId);
                ChunkLoadEventListener listener = new ChunkLoadEventListener(arg0, arg1, arg2, arg3, (success, removeFromListeners) -> {
                    job.respond(funcCallId, ScriptValue.fromJson((JsonElement)(functionCall.callingConvention() == ScriptFunctionCall.CallingConvention.JAVA ? new JsonPrimitive((Number)job.objects.retain(success)) : new JsonPrimitive(Boolean.valueOf(success)))), true);
                    job.removeOperation(funcCallId);
                    if (removeFromListeners) {
                        chunkLoadEventListeners.remove(jobOpId);
                    }
                });
                listener.updateChunkStatuses();
                if (listener.checkFullyLoaded()) return Optional.empty();
                job.addOperation(funcCallId, listener);
                chunkLoadEventListeners.put(jobOpId, listener);
                return Optional.empty();
            }
            case "java_string": {
                args.expectSize(1);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(args.getString(0))));
            }
            case "java_float": {
                args.expectSize(1);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(Float.valueOf((float)args.getDouble(0)))));
            }
            case "java_double": {
                args.expectSize(1);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(args.getDouble(0))));
            }
            case "java_long": {
                args.expectSize(1);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(args.getStrictLong(0))));
            }
            case "java_int": {
                args.expectSize(1);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(args.getStrictInt(0))));
            }
            case "java_bool": {
                args.expectSize(1);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(args.getBoolean(0))));
            }
            case "java_class": {
                args.expectSize(1);
                Class<?> object = Class.forName(mappingsLoader.get().getRuntimeClassName(args.getString(0)));
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(object)));
            }
            case "java_ctor": {
                args.expectSize(1);
                Class target = (Class)job.objects.getById(args.getStrictLong(0));
                ClassConstructor ctor = new ClassConstructor(target);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(ctor)));
            }
            case "java_new_instance": {
                ClassConstructor klass = (ClassConstructor)job.objects.getById(args.getStrictLong(0));
                Object[] params = new Object[args.size() - 1];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = job.objects.getById(args.getStrictLong(i + 1));
                }
                Class[] paramTypes = Script.TypeChecker.getTypes((Object[])params);
                Optional ctor = Script.TypeChecker.findBestMatchingConstructor(klass.type(), (Class[])paramTypes, null);
                if (ctor.isEmpty()) {
                    Script.TypeChecker.Diagnostics diagnostics = new Script.TypeChecker.Diagnostics(mappingsLoader.get()::getPrettyClassName);
                    Script.TypeChecker.findBestMatchingConstructor(klass.type(), (Class[])paramTypes, (Script.TypeChecker.Diagnostics)diagnostics);
                    throw diagnostics.createTruncatedException();
                }
                Object result = ((ConstructorInvoker)ctor.get()).newInstance(null, params);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(result)));
            }
            case "java_member": {
                args.expectSize(2);
                Class type = (Class)job.objects.getById(args.getStrictLong(0));
                String memberName = args.getString(1);
                ClassMember classMember = new ClassMember(type, memberName);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(classMember)));
            }
            case "java_call_method": {
                Object target = job.objects.getById(args.getStrictLong(0));
                ClassMember member = (ClassMember)job.objects.getById(args.getStrictLong(1));
                Object[] params = new Object[args.size() - 2];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = job.objects.getById(args.getStrictLong(i + 2));
                }
                Class[] paramTypes = Script.TypeChecker.getTypes((Object[])params);
                boolean isStaticMethod = target == null;
                Class<?> classForLookup = target == null ? member.type() : target.getClass();
                Optional method = Script.TypeChecker.findBestMatchingMethod(classForLookup, (boolean)isStaticMethod, mappingsLoader.get()::getRuntimeMethodNames, (String)member.name(), (Class[])paramTypes, null);
                if (method.isEmpty()) {
                    Script.TypeChecker.Diagnostics diagnostics = new Script.TypeChecker.Diagnostics(mappingsLoader.get()::getPrettyClassName);
                    Script.TypeChecker.findBestMatchingMethod(classForLookup, (boolean)isStaticMethod, mappingsLoader.get()::getRuntimeMethodNames, (String)member.name(), (Class[])paramTypes, (Script.TypeChecker.Diagnostics)diagnostics);
                    throw diagnostics.createTruncatedException();
                }
                Object result = ((MethodInvoker)method.get()).invoke(null, target, params);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(result)));
            }
            case "java_call_script_function": {
                String funcName;
                OptionalLong funcNameObjectHandle = ScriptFunctionCall.ArgList.getStrictLongValue(args.get(0));
                if (funcNameObjectHandle.isPresent()) {
                    String string;
                    Object functionNameObject = job.objects.getById(funcNameObjectHandle.getAsLong());
                    if (!(functionNameObject instanceof String)) throw new IllegalArgumentException(String.format("Expected first arg to java_call_script_function to be a handle to a Java String but got `%s` instead: %s", functionNameObject.getClass().getName(), functionNameObject));
                    funcName = string = (String)functionNameObject;
                } else {
                    funcName = args.getString(0);
                }
                ArrayList<Object> params = new ArrayList<Object>();
                for (int i = 1; i < args.size(); ++i) {
                    params.add(job.objects.getById(args.getStrictLong(i)));
                }
                ScriptFunctionCall funcCall = new ScriptFunctionCall(funcName, params);
                funcCall.setCallingConvention(ScriptFunctionCall.CallingConvention.JAVA);
                Optional<JsonElement> result = Minescript.runExternalScriptFunction(job, funcCallId, funcCall);
                return result.isEmpty() ? result : Optional.of(new JsonPrimitive((Number)job.objects.retain(result)));
            }
            case "java_access_field": {
                args.expectSize(2);
                Object target = job.objects.getById(args.getStrictLong(0));
                ClassMember member = (ClassMember)job.objects.getById(args.getStrictLong(1));
                Field field = member.type().getField(mappingsLoader.get().getRuntimeFieldName(member.type(), member.name()));
                boolean isClass = target instanceof Class;
                Object result = field.get(isClass ? null : target);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(result)));
            }
            case "java_array_length": {
                args.expectSize(1);
                Object[] array = (Object[])job.objects.getById(args.getStrictLong(0));
                return Optional.of(new JsonPrimitive((Number)array.length));
            }
            case "java_array_index": {
                args.expectSize(2);
                Object[] array = (Object[])job.objects.getById(args.getStrictLong(0));
                int index = args.getStrictInt(1);
                Object result = array[index];
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(result)));
            }
            case "java_new_array": {
                if (args.size() == 0) {
                    throw new IllegalArgumentException("java_new_array has 1 required arg but got no args");
                }
                Object argId0 = job.objects.getById(args.getStrictLong(0));
                if (!(argId0 instanceof Class)) throw new IllegalArgumentException("Expected first arg to java_new_array to be a Java class (Class<?>) but got %s".formatted(argId0 == null ? "null" : argId0.getClass().getName()));
                Class clazz = (Class)argId0;
                int arraySize = args.size() - 1;
                Object specificArray = Array.newInstance(clazz, arraySize);
                if (clazz.isPrimitive()) {
                    if (clazz == Byte.TYPE) {
                        for (int i = 0; i < arraySize; ++i) {
                            Array.setByte(specificArray, i, (Byte)job.objects.getById(args.getStrictLong(i + 1)));
                        }
                        return Optional.of(new JsonPrimitive((Number)job.objects.retain(specificArray)));
                    } else if (clazz == Integer.TYPE) {
                        for (int i = 0; i < arraySize; ++i) {
                            Array.setInt(specificArray, i, (Integer)job.objects.getById(args.getStrictLong(i + 1)));
                        }
                        return Optional.of(new JsonPrimitive((Number)job.objects.retain(specificArray)));
                    } else if (clazz == Long.TYPE) {
                        for (int i = 0; i < arraySize; ++i) {
                            Array.setLong(specificArray, i, (Long)job.objects.getById(args.getStrictLong(i + 1)));
                        }
                        return Optional.of(new JsonPrimitive((Number)job.objects.retain(specificArray)));
                    } else if (clazz == Float.TYPE) {
                        for (int i = 0; i < arraySize; ++i) {
                            Array.setFloat(specificArray, i, ((Float)job.objects.getById(args.getStrictLong(i + 1))).floatValue());
                        }
                        return Optional.of(new JsonPrimitive((Number)job.objects.retain(specificArray)));
                    } else if (clazz == Double.TYPE) {
                        for (int i = 0; i < arraySize; ++i) {
                            Array.setDouble(specificArray, i, (Double)job.objects.getById(args.getStrictLong(i + 1)));
                        }
                        return Optional.of(new JsonPrimitive((Number)job.objects.retain(specificArray)));
                    } else if (clazz == Character.TYPE) {
                        for (int i = 0; i < arraySize; ++i) {
                            Array.setChar(specificArray, i, ((Character)job.objects.getById(args.getStrictLong(i + 1))).charValue());
                        }
                        return Optional.of(new JsonPrimitive((Number)job.objects.retain(specificArray)));
                    } else {
                        if (clazz != Short.TYPE) throw new IllegalArgumentException("Unexpected primitive type '%s' passed as first param to java_new_array".formatted(clazz.getName()));
                        for (int i = 0; i < arraySize; ++i) {
                            Array.setShort(specificArray, i, (Short)job.objects.getById(args.getStrictLong(i + 1)));
                        }
                    }
                    return Optional.of(new JsonPrimitive((Number)job.objects.retain(specificArray)));
                } else {
                    for (int i = 0; i < arraySize; ++i) {
                        Array.set(specificArray, i, job.objects.getById(args.getStrictLong(i + 1)));
                    }
                }
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(specificArray)));
            }
            case "java_to_string": {
                args.expectSize(1);
                Object object = job.objects.getById(args.getStrictLong(0));
                return Optional.of(new JsonPrimitive(object == null ? "null" : object.toString()));
            }
            case "java_assign": {
                args.expectArgs("dest", "source");
                long dest = args.getStrictLong(0);
                long source = args.getStrictLong(1);
                job.objects.reassignId(dest, job.objects.getById(source));
                return OPTIONAL_JSON_NULL;
            }
            case "java_field_names": {
                args.expectSize(1);
                Object object = job.objects.getById(args.getStrictLong(0));
                if (!(object instanceof Class)) throw new IllegalArgumentException(String.format("Expected arg to java_field_names to be a handle to a Java Class but got `%s` instead: %s", object.getClass().getName(), object));
                Class klass = (Class)object;
                JsonArray array = new JsonArray();
                mappingsLoader.get().getPrettyFieldNames(klass).stream().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                return Optional.of(array);
            }
            case "java_method_names": {
                args.expectSize(1);
                Object object = job.objects.getById(args.getStrictLong(0));
                if (!(object instanceof Class)) throw new IllegalArgumentException(String.format("Expected arg to java_method_names to be a handle to a Java Class but got `%s` instead: %s", object.getClass().getName(), object));
                Class klass = (Class)object;
                JsonArray array = new JsonArray();
                mappingsLoader.get().getPrettyMethodNames(klass).stream().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                return Optional.of(array);
            }
            case "java_release": {
                for (Object arg : args.rawArgs()) {
                    long id = ScriptFunctionCall.ArgList.getStrictLongValue(arg).getAsLong();
                    if (id == 0L) continue;
                    job.objects.releaseById(id);
                }
                return OPTIONAL_JSON_NULL;
            }
            case "eval_pyjinn_script": {
                args.expectSize(2);
                String scriptName = args.getString(0);
                String scriptCode = args.getString(1);
                Script script = jobs.createPyjinnSubjob(job, funcCallId, scriptName, scriptCode);
                return Optional.of(new JsonPrimitive((Number)job.objects.retain(script)));
            }
            case "flush": {
                args.expectSize(0);
                return OPTIONAL_JSON_TRUE;
            }
            case "cancelfn!": {
                Optional<JsonPrimitive> cancelfnRetval = Optional.of(new JsonPrimitive("cancelfn!"));
                if (funcCallId != 0L) {
                    LOGGER.error("Internal error while cancelling function: funcCallId = 0 but got {} in job: {}", (Object)funcCallId, (Object)job.jobSummary());
                    return cancelfnRetval;
                }
                if (args.size() != 2 || !(args.get(0) instanceof Number) || !(args.get(1) instanceof String)) {
                    LOGGER.error("Internal error while cancelling function: expected [int, str] but got {} in job: {}", (Object)args, (Object)job.jobSummary());
                    return cancelfnRetval;
                }
                long funcIdToCancel = ((Number)args.get(0)).longValue();
                String funcName = (String)args.get(1);
                if (job.cancelOperation(funcIdToCancel)) {
                    LOGGER.info("Cancelled function call {} for \"{}\" in job: {}", (Object)funcIdToCancel, (Object)funcName, (Object)job.jobSummary());
                    return cancelfnRetval;
                } else {
                    LOGGER.warn("Failed to find operation to cancel: funcCallId {} for \"{}\" in job: {}", (Object)funcIdToCancel, (Object)funcName, (Object)job.jobSummary());
                }
                return cancelfnRetval;
            }
            case "exit!": {
                if (funcCallId != 0L) return OPTIONAL_JSON_NULL;
                return Optional.of(new JsonPrimitive("exit!"));
            }
        }
        if (!Minescript.runNoReturnScriptFunction(functionCall)) return Optional.of(Minescript.runScriptFunction(job, funcCallId, functionCall).toJson());
        return Optional.empty();
    }

    public static void handleAutorun(String worldName) {
        List<Message> worldCommands;
        LOGGER.info("Handling autorun for world `{}`", (Object)worldName);
        ArrayList<Message> commands = new ArrayList<Message>();
        List<Message> wildcardCommands = config.getAutorunCommands("*");
        if (wildcardCommands != null) {
            LOGGER.info("Matched {} command(s) with autorun[*] for world `{}`", (Object)wildcardCommands.size(), (Object)worldName);
            commands.addAll(wildcardCommands);
        }
        if ((worldCommands = config.getAutorunCommands(worldName)) != null) {
            LOGGER.info("Matched {} command(s) with autorun[{}]", (Object)worldCommands.size(), (Object)worldName);
            commands.addAll(worldCommands);
        }
        for (Message command : commands) {
            LOGGER.info("Running autorun command for world `{}`: {}", (Object)worldName, (Object)command);
            Minescript.processMessage(command);
        }
    }

    private static double entityPositionInterpolation() {
        class_310 minecraft = class_310.method_1551();
        double millisPerTick = minecraft.field_1687.method_54719().method_54749();
        long now = System.currentTimeMillis();
        return Math.min(1.0, (double)(now - lastTickStartTime) / millisPerTick);
    }

    public static void onClientWorldTick() {
        ScriptValue eventValue = null;
        for (Map.Entry<JobOperationId, EventListener> entry : tickEventListeners.entrySet()) {
            EventListener listener = entry.getValue();
            if (!listener.isActive()) continue;
            if (eventValue == null) {
                TickEvent event = new TickEvent();
                event.time = (double)System.currentTimeMillis() / 1000.0;
                eventValue = ScriptValue.of(event);
            }
            listener.respond(eventValue);
        }
        lastTickStartTime = System.currentTimeMillis();
        if (++clientTickEventCounter % (long)config.ticksPerCycle() == 0L) {
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            String worldName = Minescript.getWorldName();
            if (!autorunHandled.getAndSet(true) && worldName != null) {
                systemMessageQueue.clear();
                config.load();
                Minescript.handleAutorun(worldName);
            }
            if (!(player == null || systemMessageQueue.isEmpty() && jobs.getMap().isEmpty())) {
                Minescript.processMessageQueue(true, job -> job.tickQueue().poll());
            }
        }
    }

    public static void reportException(Throwable e) {
        ScriptExceptionHandler.reportException(systemMessageQueue, e);
    }

    public static void processMessageQueue(boolean processSystemMessages, Function<JobControl, Message> jobMessageQueue) {
        boolean hasMessage;
        class_310 minecraft = class_310.method_1551();
        int iterations = 0;
        long loopStartTimeUsecs = System.nanoTime() / 1000L;
        do {
            Message sysMessage;
            hasMessage = false;
            ++iterations;
            if (processSystemMessages && (sysMessage = systemMessageQueue.poll()) != null) {
                hasMessage = true;
                Minescript.processMessage(sysMessage);
            }
            for (JobControl job : jobs.getMap().values()) {
                Message message;
                if (job.state() != JobState.RUNNING && job.state() != JobState.DONE) continue;
                if (job instanceof Job.SubprocessJob) {
                    Job.SubprocessJob externalJob = (Job.SubprocessJob)job;
                    try {
                        message = jobMessageQueue.apply(externalJob);
                        if (message == null) continue;
                        hasMessage = true;
                        if (message.type() == Message.Type.FUNCTION_CALL) {
                            String functionName = message.value();
                            Message.FunctionCallData funcCallData = (Message.FunctionCallData)message.data();
                            Minescript.processScriptFunction(externalJob, functionName, funcCallData.funcCallId(), funcCallData.args());
                            continue;
                        }
                        class_638 level = minecraft.field_1687;
                        jobs.getUndoForJob(externalJob).ifPresent(arg_0 -> Minescript.lambda$processMessageQueue$35((class_1937)level, message, arg_0));
                        Minescript.processMessage(message);
                    }
                    catch (RuntimeException e) {
                        externalJob.logJobException(e);
                    }
                    continue;
                }
                message = jobMessageQueue.apply(job);
                if (message == null) continue;
                hasMessage = true;
                Minescript.processMessage(message);
            }
        } while (hasMessage && iterations < config.maxCommandsPerCycle() && System.nanoTime() / 1000L - loopStartTimeUsecs < (long)config.commandCycleDeadlineUsecs());
    }

    private static /* synthetic */ void lambda$processMessageQueue$35(class_1937 level, Message message, UndoableAction u) {
        u.processCommandToUndo(level, message);
    }

    static {
        autorunHandled = new AtomicBoolean(false);
        GSON = new GsonBuilder().serializeNulls().create();
        BUILTIN_COMMANDS = ImmutableList.of((Object)"help", (Object)"ls", (Object)"copy", (Object)"jobs", (Object)"suspend", (Object)"z", (Object)"resume", (Object)"killjob", (Object)"undo", (Object)"which", (Object)"config", (Object)"reload_mappings", (Object[])new String[]{"reload_minescript_resources"});
        IGNORE_DIRS_FOR_COMPLETIONS = ImmutableSet.of((Object)"blockpacks", (Object)"undo");
        TILDE_RE = Pattern.compile("^~([-\\+]?)([0-9]*)$");
        jobs = new JobManager();
        systemMessageQueue = new SystemMessageQueue();
        SETBLOCK_COMMAND_RE = Pattern.compile("setblock ([^ ]+) ([^ ]+) ([^ ]+).*");
        FILL_COMMAND_RE = Pattern.compile("fill ([^ ]+) ([^ ]+) ([^ ]+) ([^ ]+) ([^ ]+) ([^ ]+).*");
        EMPTY_STRING_ARRAY = new String[0];
        worldRenderEventCounter = 0L;
        clientTickEventCounter = 0L;
        BACKSLASH_KEY = 92;
        ESCAPE_KEY = 256;
        ENTER_KEY = 257;
        TAB_KEY = 258;
        BACKSPACE_KEY = 259;
        UP_ARROW_KEY = 265;
        DOWN_ARROW_KEY = 264;
        commandSuggestions = new ArrayList<String>();
        levelRenderContext = null;
        lastRenderEventWarningTimeMillis = 0L;
        chatEditBox = null;
        reportedChatEditBoxError = false;
        COMMANDS_WITH_FIRST_PARAM_COMPLETIONS = ImmutableSet.of((Object)"config", (Object)"help", (Object)"which");
        loggedMethodNameFallback = false;
        CHAT_WHISPER_MESSAGE_RE = Pattern.compile("You whisper to [^ :]+: (.*)");
        serverBlockList = new ServerBlockList();
        tickEventListeners = new EventDispatcher();
        keyEventListeners = new EventDispatcher();
        mouseEventListeners = new EventDispatcher();
        chatEventListeners = new EventDispatcher();
        chatInterceptors = new EventDispatcher(Minescript::getOutgoingChatInterceptFilter);
        addEntityEventListeners = new EventDispatcher();
        blockUpdateEventListeners = new EventDispatcher();
        takeItemEventListeners = new EventDispatcher();
        damageEventListeners = new EventDispatcher();
        explosionEventListeners = new EventDispatcher();
        chunkEventListeners = new EventDispatcher();
        worldListeners = new EventDispatcher();
        eventDispatchers = new HashMap<String, EventDispatcher>();
        eventDispatchers.put("tick", tickEventListeners);
        eventDispatchers.put("key", keyEventListeners);
        eventDispatchers.put("mouse", mouseEventListeners);
        eventDispatchers.put("chat", chatEventListeners);
        eventDispatchers.put("outgoing_chat_intercept", chatInterceptors);
        eventDispatchers.put("add_entity", addEntityEventListeners);
        eventDispatchers.put("block_update", blockUpdateEventListeners);
        eventDispatchers.put("take_item", takeItemEventListeners);
        eventDispatchers.put("damage", damageEventListeners);
        eventDispatchers.put("explosion", explosionEventListeners);
        eventDispatchers.put("chunk", chunkEventListeners);
        eventDispatchers.put("world", worldListeners);
        RENDER_EVENT_NAME_RE = Pattern.compile("render_(before|after)_.*");
        chunkLoadEventListeners = new ConcurrentHashMap<JobOperationId, ChunkLoadEventListener>();
        customNickname = null;
        keyBinds = new ConcurrentHashMap<String, class_3675.class_306>();
        OPTIONAL_JSON_NULL = Optional.of(JsonNull.INSTANCE);
        JSON_TRUE = new JsonPrimitive(Boolean.valueOf(true));
        OPTIONAL_JSON_TRUE = Optional.of(JSON_TRUE);
        lastTickStartTime = 0L;
    }

    private static enum FileOverwritePolicy {
        DO_NOT_OVERWRITE,
        OVERWRITTE;

    }

    static class JobManager {
        private final Map<Integer, JobControl> jobMap = new ConcurrentHashMap<Integer, JobControl>();
        private int nextJobId = 1;
        private final Map<Integer, UndoableAction> jobUndoMap = new ConcurrentHashMap<Integer, UndoableAction>();
        private final Deque<UndoableAction> undoStack = new ArrayDeque<UndoableAction>();

        JobManager() {
        }

        public void createPyjinnJob(ScriptConfig.BoundCommand command, List<CommandSyntax.Token> nextCommand) {
            try {
                String scriptCode = Files.readString(command.scriptPath());
                int jobId = this.allocateJobId();
                PyjinnScript.PyjinnJob job = PyjinnScript.createJob(jobId, Optional.empty(), command, scriptCode, config, systemMessageQueue, mappingsLoader.get(), true, () -> this.finishJob(jobId, nextCommand));
                this.jobMap.put(job.jobId(), job);
                job.start();
            }
            catch (Exception e) {
                systemMessageQueue.logException(e);
            }
        }

        public Script createPyjinnSubjob(Job.SubprocessJob parentJob, long opId, String scriptName, String scriptCode) throws Exception {
            ScriptConfig.BoundCommand parentCommand = parentJob.boundCommand();
            ScriptConfig.BoundCommand childCommand = new ScriptConfig.BoundCommand(parentCommand.scriptPath(), new String[]{scriptName}, parentCommand.redirects());
            int jobId = this.allocateJobId();
            PyjinnScript.PyjinnJob scriptJob = PyjinnScript.createJob(jobId, Optional.of(parentJob.jobId()), childCommand, scriptCode, config, systemMessageQueue, mappingsLoader.get(), false, () -> this.finishJob(jobId, List.of()));
            this.jobMap.put(scriptJob.jobId(), scriptJob);
            parentJob.addOperation(opId, new PyjinnScriptOperation(this, scriptName, scriptJob));
            scriptJob.start();
            return scriptJob.script();
        }

        public void createSubprocessJob(ScriptConfig.BoundCommand command, List<CommandSyntax.Token> nextCommand) {
            int jobId = this.allocateJobId();
            Job.SubprocessJob job = new Job.SubprocessJob(jobId, Optional.empty(), command, (Task)new SubprocessTask(config), config, systemMessageQueue, Minescript::processScriptFunction, () -> this.finishJob(jobId, nextCommand));
            UndoableActionBlockPack undo = new UndoableActionBlockPack(job.jobId(), command.command());
            this.jobUndoMap.put(job.jobId(), undo);
            this.undoStack.addFirst(undo);
            this.jobMap.put(job.jobId(), job);
            job.start();
        }

        public Optional<UndoableAction> getUndoForJob(JobControl job) {
            UndoableAction undo = this.jobUndoMap.get(job.jobId());
            if (undo == null) {
                return Optional.empty();
            }
            return Optional.of(undo);
        }

        public void startUndo() {
            JobControl job;
            UndoableAction undo = this.undoStack.pollFirst();
            if (undo == null) {
                systemMessageQueue.logUserError("The undo stack is empty.", new Object[0]);
                return;
            }
            int originalJobId = undo.originalJobId();
            if (originalJobId != -1 && (job = this.jobMap.get(undo.originalJobId())) != null) {
                job.requestKill();
            }
            int jobId = this.allocateJobId();
            Job.SubprocessJob undoJob = new Job.SubprocessJob(jobId, Optional.empty(), new ScriptConfig.BoundCommand(null, undo.derivativeCommand(), ScriptRedirect.Pair.DEFAULTS), (Task)new UndoTask(undo), config, systemMessageQueue, Minescript::processScriptFunction, () -> this.finishJob(jobId, Collections.emptyList()));
            this.jobMap.put(undoJob.jobId(), undoJob);
            undoJob.start();
        }

        private synchronized int allocateJobId() {
            if (this.jobMap.isEmpty()) {
                this.nextJobId = 1;
            }
            return this.nextJobId++;
        }

        private void finishJob(int jobId, List<CommandSyntax.Token> nextCommand) {
            UndoableAction undo = this.jobUndoMap.remove(jobId);
            if (undo != null) {
                undo.onOriginalJobDone();
            }
            this.jobMap.remove(jobId);
            Minescript.runParsedMinescriptCommand(nextCommand);
        }

        public Map<Integer, JobControl> getMap() {
            return this.jobMap;
        }

        private class PyjinnScriptOperation
        implements JobControl.Operation {
            private final String name;
            private final PyjinnScript.PyjinnJob job;
            private final AtomicBoolean done = new AtomicBoolean(false);

            PyjinnScriptOperation(JobManager jobManager, String name, PyjinnScript.PyjinnJob job) {
                this.name = name;
                this.job = job;
                job.script().atExit(status -> this.done.set(true));
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public void suspend() {
                this.job.suspend();
            }

            @Override
            public boolean resumeAndCheckDone() {
                this.job.resume();
                return this.done.get();
            }

            @Override
            public void cancel() {
                this.job.script().exit(0);
            }
        }
    }

    public static enum ParamType {
        INT,
        BOOL,
        STRING,
        VAR_ARGS;

    }

    private static class ServerBlockList {
        private final Path serverBlockListPath = Paths.get("minescript", "server_block_list.txt");
        private boolean lastCheckedValue = true;
        private String lastCheckedServerName = "";
        private String lastCheckedServerIp = "";
        private long lastCheckedTime = 0L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean areCommandsAllowedForServer(String serverName, String serverIp) {
            if (!Files.exists(this.serverBlockListPath, new LinkOption[0])) {
                return true;
            }
            if (serverName.equals(this.lastCheckedServerName) && serverIp.equals(this.lastCheckedServerIp) && new File(this.serverBlockListPath.toString()).lastModified() < this.lastCheckedTime) {
                return this.lastCheckedValue;
            }
            this.lastCheckedServerName = serverName;
            this.lastCheckedServerIp = serverIp;
            this.lastCheckedTime = System.currentTimeMillis();
            LOGGER.info("{} modified since last checked; refreshing...", (Object)this.serverBlockListPath.toString());
            try (BufferedReader reader = new BufferedReader(new FileReader(this.serverBlockListPath.toString()));){
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.replaceAll("#.*$", "").strip()).equals(serverName) || line.equals(serverIp)) {
                        LOGGER.info("Found server match in {}, commands disabled: {}", (Object)this.serverBlockListPath.toString(), (Object)line);
                        boolean bl = this.lastCheckedValue = false;
                        return bl;
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                systemMessageQueue.logException(e);
            }
            LOGGER.info("No server match in {}, commands enabled: {} / {}", (Object)this.serverBlockListPath.toString(), (Object)serverName, (Object)serverIp);
            this.lastCheckedValue = true;
            return this.lastCheckedValue;
        }
    }

    private static class BlockRegionConsumer
    implements BlockRegionReader.BlockConsumer {
        private String[] blocks;
        private int index = 0;

        public BlockRegionConsumer(String[] blocks) {
            this.blocks = blocks;
        }

        @Override
        public void setblock(int x, int y, int z, String block) {
            this.blocks[this.index++] = block;
        }

        @Override
        public void setAir(int x, int y, int z) {
            this.blocks[this.index++] = null;
        }

        @Override
        public void reportBlockError(int x, int y, int z, String error) {
            this.blocks[this.index++] = null;
            systemMessageQueue.logUserError(error, new Object[0]);
        }
    }

    private record ClassConstructor(Class<?> type) {
    }

    private record ClassMember(Class<?> type, String name) {
    }

    static interface UndoableAction {
        public int originalJobId();

        public void onOriginalJobDone();

        public String[] originalCommand();

        public String[] derivativeCommand();

        public void processCommandToUndo(class_1937 var1, Message var2);

        public void enqueueCommands(Queue<Message> var1);
    }

    static class UndoTask
    implements Task {
        private final UndoableAction undo;

        public UndoTask(UndoableAction undo) {
            this.undo = undo;
        }

        @Override
        public int run(ScriptConfig.BoundCommand command, JobControl job) {
            this.undo.enqueueCommands(job.tickQueue());
            return 0;
        }
    }

    static class UndoableActionBlockPack
    implements UndoableAction {
        private static String UNDO_DIR = Paths.get("minescript", "undo").toString();
        private volatile int originalJobId;
        private String[] originalCommand;
        private final long startTimeMillis;
        private BlockPacker blockpacker = new BlockPacker();
        private final Set<Position> blocks = new HashSet<Position>();
        private String blockpackFilename;
        private boolean undone = false;
        private int[] coords = new int[6];
        private class_2338.class_2339 pos = new class_2338.class_2339();

        public UndoableActionBlockPack(int originalJobId, String[] originalCommand) {
            this.originalJobId = originalJobId;
            this.originalCommand = originalCommand;
            this.startTimeMillis = System.currentTimeMillis();
        }

        @Override
        public int originalJobId() {
            return this.originalJobId;
        }

        @Override
        public synchronized void onOriginalJobDone() {
            this.originalJobId = -1;
            if (!this.blocks.isEmpty()) {
                new File(UNDO_DIR).mkdirs();
                this.blockpackFilename = Paths.get(UNDO_DIR, this.startTimeMillis + ".zip").toString();
                this.blockpacker.comments().put("source command", "undo");
                this.blockpacker.comments().put("command to undo", CommandSyntax.quoteCommand(this.originalCommand));
                BlockPack blockpack = this.blockpacker.pack();
                try {
                    blockpack.writeZipFile(this.blockpackFilename);
                }
                catch (Exception e) {
                    systemMessageQueue.logException(e);
                }
                this.blockpacker = null;
                this.blocks.clear();
            }
        }

        @Override
        public String[] originalCommand() {
            return this.originalCommand;
        }

        @Override
        public String[] derivativeCommand() {
            String[] derivative = new String[]{"\\undo", "(" + String.join((CharSequence)" ", this.originalCommand) + ")"};
            return derivative;
        }

        @Override
        public synchronized void processCommandToUndo(class_1937 level, Message output) {
            if (output.type() != Message.Type.MINECRAFT_COMMAND) {
                return;
            }
            String command = output.value();
            if (command.startsWith("setblock ") && Minescript.getSetblockCoords(command, this.coords)) {
                String block = BlockPositionReader.getBlockStateString(level, (class_2338)this.pos.method_10103(this.coords[0], this.coords[1], this.coords[2]));
                if (block != null && !this.addBlockToUndoQueue(this.coords[0], this.coords[1], this.coords[2], block)) {
                    return;
                }
            } else if (command.startsWith("fill ") && Minescript.getFillCoords(command, this.coords)) {
                int x0 = this.coords[0];
                int y0 = this.coords[1];
                int z0 = this.coords[2];
                int x1 = this.coords[3];
                int y1 = this.coords[4];
                int z1 = this.coords[5];
                for (int x = x0; x <= x1; ++x) {
                    for (int y = y0; y <= y1; ++y) {
                        for (int z = z0; z <= z1; ++z) {
                            String block = BlockPositionReader.getBlockStateString(level, (class_2338)this.pos.method_10103(x, y, z));
                            if (block == null || this.addBlockToUndoQueue(x, y, z, block)) continue;
                            return;
                        }
                    }
                }
            }
        }

        private boolean addBlockToUndoQueue(int x, int y, int z, String block) {
            if (this.undone) {
                LOGGER.error("Cannot add command to undoable action after already undone: {}", (Object)String.join((CharSequence)" ", this.originalCommand));
                return false;
            }
            if (this.blocks.add(new Position(x, y, z))) {
                this.blockpacker.setblock(x, y, z, block);
            }
            return true;
        }

        @Override
        public synchronized void enqueueCommands(Queue<Message> messageQueue) {
            this.undone = true;
            int[] nullRotation = null;
            int[] nullOffset = null;
            if (this.blockpackFilename == null) {
                this.blockpacker.pack().getBlockCommands(nullRotation, nullOffset, s -> messageQueue.add(Message.createMinecraftCommand(s)));
                this.blockpacker = null;
                this.blocks.clear();
            } else {
                try {
                    BlockPack.readZipFile(this.blockpackFilename).getBlockCommands(nullRotation, nullOffset, s -> messageQueue.add(Message.createMinecraftCommand(s)));
                }
                catch (Exception e) {
                    systemMessageQueue.logException(e);
                }
            }
        }

        private static class Position {
            public final int x;
            public final int y;
            public final int z;

            public Position(int x, int y, int z) {
                this.x = x;
                this.y = y;
                this.z = z;
            }

            public int hashCode() {
                return Objects.hash(this.x, this.y, this.z);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Position)) {
                    return false;
                }
                Position other = (Position)o;
                return this.x == other.x && this.y == other.y && this.z == other.z;
            }
        }
    }
}

